/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Location;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B!\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\u000bB\u0013\b\u0016\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0004\u0010\rJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\u0011\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0086\u0002J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017J\u0018\u0010\u0019\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u001b\u001a\u00020\u0007J\u0006\u0010\u001c\u001a\u00020\u0017J\u0006\u0010\u001d\u001a\u00020\u0017J\u0006\u0010\u001e\u001a\u00020\u0012J\u000e\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0007J\u000e\u0010!\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0007J\u0016\u0010\u0010\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0007J\u000e\u0010\u0010\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0007J\u0006\u0010\"\u001a\u00020\u0003J\u001e\u0010#\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J\u000e\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\u0007J\u0010\u0010&\u001a\u00020\u00122\b\u0010\f\u001a\u0004\u0018\u00010\u0000J\b\u0010'\u001a\u00020(H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0005\u00a8\u0006)"}, d2={"Lorg/locationtech/jts/geomgraph/TopologyLocation;", "", "location", "", "<init>", "([I)V", "on", "", "left", "right", "(III)V", "(I)V", "gl", "(Lorg/locationtech/jts/geomgraph/TopologyLocation;)V", "getLocation", "()[I", "setLocation", "init", "", "size", "get", "posIndex", "isNull", "", "isAnyNull", "isEqualOnSide", "le", "locIndex", "isArea", "isLine", "flip", "setAllLocations", "locValue", "setAllLocationsIfNull", "getLocations", "setLocations", "allPositionsEqual", "loc", "merge", "toString", "", "kts-core"})
public final class TopologyLocation {
    public int[] location;

    @NotNull
    public final int[] getLocation() {
        if (this.location != null) {
            return this.location;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"location");
        return null;
    }

    public final void setLocation(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.location = nArray;
    }

    public TopologyLocation(@NotNull int[] location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.init(location.length);
    }

    public TopologyLocation(int on, int left, int right) {
        this.init(3);
        this.getLocation()[0] = on;
        this.getLocation()[1] = left;
        this.getLocation()[2] = right;
    }

    public TopologyLocation(int on) {
        this.init(1);
        this.getLocation()[0] = on;
    }

    public TopologyLocation(@Nullable TopologyLocation gl) {
        TopologyLocation topologyLocation = gl;
        Intrinsics.checkNotNull((Object)topologyLocation);
        this.init(topologyLocation.getLocation().length);
        int n = this.getLocation().length;
        for (int i = 0; i < n; ++i) {
            this.getLocation()[i] = gl.getLocation()[i];
        }
    }

    private final void init(int size) {
        this.setLocation(new int[size]);
        this.setAllLocations(-1);
    }

    public final int get(int posIndex) {
        return posIndex < this.getLocation().length ? this.getLocation()[posIndex] : -1;
    }

    public final boolean isNull() {
        int n = this.getLocation().length;
        for (int i = 0; i < n; ++i) {
            if (this.getLocation()[i] == -1) continue;
            return false;
        }
        return true;
    }

    public final boolean isAnyNull() {
        int n = this.getLocation().length;
        for (int i = 0; i < n; ++i) {
            if (this.getLocation()[i] != -1) continue;
            return true;
        }
        return false;
    }

    public final boolean isEqualOnSide(@Nullable TopologyLocation le, int locIndex) {
        int n = this.getLocation()[locIndex];
        TopologyLocation topologyLocation = le;
        Intrinsics.checkNotNull((Object)topologyLocation);
        return n == topologyLocation.getLocation()[locIndex];
    }

    public final boolean isArea() {
        return this.getLocation().length > 1;
    }

    public final boolean isLine() {
        return this.getLocation().length == 1;
    }

    public final void flip() {
        if (this.getLocation().length <= 1) {
            return;
        }
        int temp = this.getLocation()[1];
        this.getLocation()[1] = this.getLocation()[2];
        this.getLocation()[2] = temp;
    }

    public final void setAllLocations(int locValue) {
        int n = this.getLocation().length;
        for (int i = 0; i < n; ++i) {
            this.getLocation()[i] = locValue;
        }
    }

    public final void setAllLocationsIfNull(int locValue) {
        int n = this.getLocation().length;
        for (int i = 0; i < n; ++i) {
            if (this.getLocation()[i] != -1) continue;
            this.getLocation()[i] = locValue;
        }
    }

    public final void setLocation(int locIndex, int locValue) {
        this.getLocation()[locIndex] = locValue;
    }

    public final void setLocation(int locValue) {
        this.setLocation(0, locValue);
    }

    @NotNull
    public final int[] getLocations() {
        return this.getLocation();
    }

    public final void setLocations(int on, int left, int right) {
        this.getLocation()[0] = on;
        this.getLocation()[1] = left;
        this.getLocation()[2] = right;
    }

    public final boolean allPositionsEqual(int loc) {
        int n = this.getLocation().length;
        for (int i = 0; i < n; ++i) {
            if (this.getLocation()[i] == loc) continue;
            return false;
        }
        return true;
    }

    public final void merge(@Nullable TopologyLocation gl) {
        TopologyLocation topologyLocation = gl;
        Intrinsics.checkNotNull((Object)topologyLocation);
        if (topologyLocation.getLocation().length > this.getLocation().length) {
            int[] newLoc = new int[]{this.getLocation()[0], -1, -1};
            this.setLocation(newLoc);
        }
        int n = this.getLocation().length;
        for (int i = 0; i < n; ++i) {
            if (this.getLocation()[i] != -1 || i >= gl.getLocation().length) continue;
            this.getLocation()[i] = gl.getLocation()[i];
        }
    }

    @NotNull
    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.getLocation().length > 1) {
            buf.append(Location.INSTANCE.toLocationSymbol(this.getLocation()[1]));
        }
        buf.append(Location.INSTANCE.toLocationSymbol(this.getLocation()[0]));
        if (this.getLocation().length > 1) {
            buf.append(Location.INSTANCE.toLocationSymbol(this.getLocation()[2]));
        }
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

