/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph.index;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Quadrant;
import org.locationtech.jts.util.IntArrayList;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0019\u0010\n\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ#\u0010\u000b\u001a\u00020\f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lorg/locationtech/jts/geomgraph/index/MonotoneChainIndexer;", "", "<init>", "()V", "getChainStartIndices", "", "pts", "", "Lorg/locationtech/jts/geom/Coordinate;", "([Lorg/locationtech/jts/geom/Coordinate;)[I", "OLDgetChainStartIndices", "findChainEnd", "", "start", "([Lorg/locationtech/jts/geom/Coordinate;I)I", "Companion", "kts-core"})
public final class MonotoneChainIndexer {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final int[] getChainStartIndices(@NotNull Coordinate[] pts) {
        int last;
        Intrinsics.checkNotNullParameter((Object)pts, (String)"pts");
        int start = 0;
        IntArrayList startIndexList = new IntArrayList(pts.length / 2);
        startIndexList.add(start);
        do {
            last = this.findChainEnd(pts, start);
            startIndexList.add(last);
        } while ((start = last) < pts.length - 1);
        return startIndexList.toArray();
    }

    @NotNull
    public final int[] OLDgetChainStartIndices(@NotNull Coordinate[] pts) {
        int last;
        Intrinsics.checkNotNullParameter((Object)pts, (String)"pts");
        int start = 0;
        List startIndexList = new ArrayList();
        startIndexList.add(start);
        do {
            last = this.findChainEnd(pts, start);
            startIndexList.add(last);
        } while ((start = last) < pts.length - 1);
        return Companion.toIntArray(startIndexList);
    }

    private final int findChainEnd(Coordinate[] pts, int start) {
        int quad;
        int last;
        int chainQuad = Quadrant.INSTANCE.quadrant(pts[start], pts[start + 1]);
        for (last = start + 1; last < pts.length && (quad = Quadrant.INSTANCE.quadrant(pts[last - 1], pts[last])) == chainQuad; ++last) {
        }
        return last - 1;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010!\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a8\u0006\t"}, d2={"Lorg/locationtech/jts/geomgraph/index/MonotoneChainIndexer$Companion;", "", "<init>", "()V", "toIntArray", "", "list", "", "", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final int[] toIntArray(@NotNull List<Integer> list) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            int[] array = new int[list.size()];
            int n = array.length;
            for (int i = 0; i < n; ++i) {
                array[i] = ((Number)list.get(i)).intValue();
            }
            return array;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

