/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph.index;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.Node;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 /2\u00020\u0001:\u0001/B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001e\u0010\u001d\u001a\u00020\u001e2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u001b2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\u001bJ\u0006\u0010\t\u001a\u00020\u0005J\u0006\u0010#\u001a\u00020\u0005J\u0006\u0010$\u001a\u00020\u0005J(\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020'2\u0006\u0010*\u001a\u00020\u0013H\u0002J&\u0010+\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020'2\u0006\u0010*\u001a\u00020\u0013J)\u0010,\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0019\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b\u0018\u00010\u001aH\u0002\u00a2\u0006\u0002\u0010-J\u001c\u0010.\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u0011\u0010!\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u00060"}, d2={"Lorg/locationtech/jts/geomgraph/index/SegmentIntersector;", "", "li", "Lorg/locationtech/jts/algorithm/LineIntersector;", "includeProper", "", "recordIsolated", "<init>", "(Lorg/locationtech/jts/algorithm/LineIntersector;ZZ)V", "hasIntersection", "hasProper", "hasProperInterior", "value", "Lorg/locationtech/jts/geom/Coordinate;", "properIntersectionPoint", "getProperIntersectionPoint", "()Lorg/locationtech/jts/geom/Coordinate;", "isSelfIntersection", "numIntersections", "", "numTests", "getNumTests", "()I", "setNumTests", "(I)V", "bdyNodes", "", "", "[Ljava/util/Collection;", "setBoundaryNodes", "", "bdyNodes0", "bdyNodes1", "isDone", "()Z", "hasProperIntersection", "hasProperInteriorIntersection", "isTrivialIntersection", "e0", "Lorg/locationtech/jts/geomgraph/Edge;", "segIndex0", "e1", "segIndex1", "addIntersections", "isBoundaryPoint", "(Lorg/locationtech/jts/algorithm/LineIntersector;[Ljava/util/Collection;)Z", "isBoundaryPointInternal", "Companion", "kts-core"})
public final class SegmentIntersector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LineIntersector li;
    private final boolean includeProper;
    private final boolean recordIsolated;
    private boolean hasIntersection;
    private boolean hasProper;
    private boolean hasProperInterior;
    @Nullable
    private Coordinate properIntersectionPoint;
    private final boolean isSelfIntersection;
    private int numIntersections;
    private int numTests;
    @Nullable
    private Collection<?>[] bdyNodes;

    public SegmentIntersector(@NotNull LineIntersector li, boolean includeProper, boolean recordIsolated) {
        Intrinsics.checkNotNullParameter((Object)li, (String)"li");
        this.li = li;
        this.includeProper = includeProper;
        this.recordIsolated = recordIsolated;
    }

    @Nullable
    public final Coordinate getProperIntersectionPoint() {
        return this.properIntersectionPoint;
    }

    public final int getNumTests() {
        return this.numTests;
    }

    public final void setNumTests(int n) {
        this.numTests = n;
    }

    public final void setBoundaryNodes(@NotNull Collection<?> bdyNodes0, @NotNull Collection<?> bdyNodes1) {
        Intrinsics.checkNotNullParameter(bdyNodes0, (String)"bdyNodes0");
        Intrinsics.checkNotNullParameter(bdyNodes1, (String)"bdyNodes1");
        Collection[] collectionArray = new Collection[]{bdyNodes0, bdyNodes1};
        this.bdyNodes = collectionArray;
    }

    public final boolean isDone() {
        return false;
    }

    public final boolean hasIntersection() {
        return this.hasIntersection;
    }

    public final boolean hasProperIntersection() {
        return this.hasProper;
    }

    public final boolean hasProperInteriorIntersection() {
        return this.hasProperInterior;
    }

    private final boolean isTrivialIntersection(Edge e0, int segIndex0, Edge e1, int segIndex1) {
        if (e0 == e1 && this.li.getIntersectionNum() == 1) {
            if (Companion.isAdjacentSegments(segIndex0, segIndex1)) {
                return true;
            }
            if (e0.isClosed()) {
                int maxSegIndex = e0.getNumPoints() - 1;
                if (segIndex0 == 0 && segIndex1 == maxSegIndex || segIndex1 == 0 && segIndex0 == maxSegIndex) {
                    return true;
                }
            }
        }
        return false;
    }

    public final void addIntersections(@NotNull Edge e0, int segIndex0, @NotNull Edge e1, int segIndex1) {
        Intrinsics.checkNotNullParameter((Object)e0, (String)"e0");
        Intrinsics.checkNotNullParameter((Object)e1, (String)"e1");
        if (e0 == e1 && segIndex0 == segIndex1) {
            return;
        }
        int n = this.numTests;
        this.numTests = n + 1;
        Coordinate p00 = e0.getCoordinate(segIndex0);
        Coordinate p01 = e0.getCoordinate(segIndex0 + 1);
        Coordinate p10 = e1.getCoordinate(segIndex1);
        Coordinate p11 = e1.getCoordinate(segIndex1 + 1);
        this.li.computeIntersection(p00, p01, p10, p11);
        if (this.li.hasIntersection()) {
            if (this.recordIsolated) {
                e0.setIsolated(false);
                e1.setIsolated(false);
            }
            int n2 = this.numIntersections;
            this.numIntersections = n2 + 1;
            if (!this.isTrivialIntersection(e0, segIndex0, e1, segIndex1)) {
                boolean isNotProper;
                this.hasIntersection = true;
                boolean isBoundaryPt = this.isBoundaryPoint(this.li, this.bdyNodes);
                boolean bl = isNotProper = !this.li.isProper() || isBoundaryPt;
                if (this.includeProper || isNotProper) {
                    e0.addIntersections(this.li, segIndex0, 0);
                    e1.addIntersections(this.li, segIndex1, 1);
                }
                if (this.li.isProper()) {
                    this.properIntersectionPoint = this.li.getIntersection(0).copy();
                    this.hasProper = true;
                    if (!isBoundaryPt) {
                        this.hasProperInterior = true;
                    }
                }
            }
        }
    }

    private final boolean isBoundaryPoint(LineIntersector li, Collection<?>[] bdyNodes) {
        if (bdyNodes == null) {
            return false;
        }
        if (this.isBoundaryPointInternal(li, bdyNodes[0])) {
            return true;
        }
        return this.isBoundaryPointInternal(li, bdyNodes[1]);
    }

    private final boolean isBoundaryPointInternal(LineIntersector li, Collection<?> bdyNodes) {
        for (Object obj : bdyNodes) {
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.Node");
            Node node = (Node)obj;
            Coordinate pt = node.getCoordinate();
            if (!li.isIntersection(pt)) continue;
            return true;
        }
        return false;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lorg/locationtech/jts/geomgraph/index/SegmentIntersector$Companion;", "", "<init>", "()V", "isAdjacentSegments", "", "i1", "", "i2", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isAdjacentSegments(int i1, int i2) {
            return Math.INSTANCE.abs(i1 - i2) == 1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

