/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph.index;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.index.EdgeSetIntersector;
import org.locationtech.jts.geomgraph.index.SegmentIntersector;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J,\u0010\n\u001a\u00020\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lorg/locationtech/jts/geomgraph/index/SimpleEdgeSetIntersector;", "Lorg/locationtech/jts/geomgraph/index/EdgeSetIntersector;", "<init>", "()V", "nOverlaps", "", "getNOverlaps", "()I", "setNOverlaps", "(I)V", "computeIntersections", "", "edges", "", "Lorg/locationtech/jts/geomgraph/Edge;", "si", "Lorg/locationtech/jts/geomgraph/index/SegmentIntersector;", "testAllSegments", "", "edges0", "edges1", "computeIntersects", "e0", "e1", "kts-core"})
public final class SimpleEdgeSetIntersector
extends EdgeSetIntersector {
    private int nOverlaps;

    public final int getNOverlaps() {
        return this.nOverlaps;
    }

    public final void setNOverlaps(int n) {
        this.nOverlaps = n;
    }

    @Override
    public void computeIntersections(@NotNull List<Edge> edges, @NotNull SegmentIntersector si, boolean testAllSegments) {
        Intrinsics.checkNotNullParameter(edges, (String)"edges");
        Intrinsics.checkNotNullParameter((Object)si, (String)"si");
        this.nOverlaps = 0;
        Iterator<Edge> i0 = edges.iterator();
        while (i0.hasNext()) {
            Intrinsics.checkNotNull((Object)i0.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.Edge");
            Iterator<Edge> i1 = edges.iterator();
            while (i1.hasNext()) {
                Edge edge1;
                Edge edge0;
                Intrinsics.checkNotNull((Object)i1.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.Edge");
                if (!testAllSegments && edge0 == edge1) continue;
                this.computeIntersects(edge0, edge1, si);
            }
        }
    }

    @Override
    public void computeIntersections(@NotNull List<Edge> edges0, @NotNull List<Edge> edges1, @NotNull SegmentIntersector si) {
        Intrinsics.checkNotNullParameter(edges0, (String)"edges0");
        Intrinsics.checkNotNullParameter(edges1, (String)"edges1");
        Intrinsics.checkNotNullParameter((Object)si, (String)"si");
        this.nOverlaps = 0;
        Iterator<Edge> i0 = edges0.iterator();
        while (i0.hasNext()) {
            Intrinsics.checkNotNull((Object)i0.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.Edge");
            Iterator<Edge> i1 = edges1.iterator();
            while (i1.hasNext()) {
                Edge edge1;
                Edge edge0;
                Intrinsics.checkNotNull((Object)i1.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.Edge");
                this.computeIntersects(edge0, edge1, si);
            }
        }
    }

    private final void computeIntersects(Edge e0, Edge e1, SegmentIntersector si) {
        Coordinate[] pts0 = e0.getCoordinates();
        Coordinate[] pts1 = e1.getCoordinates();
        int n = pts0.length - 1;
        for (int i0 = 0; i0 < n; ++i0) {
            int n2 = pts1.length - 1;
            for (int i1 = 0; i1 < n2; ++i1) {
                si.addIntersections(e0, i0, e1, i1);
            }
        }
    }
}

