/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.index.EdgeSetIntersector;
import org.locationtech.jts.geomgraph.index.SegmentIntersector;
import org.locationtech.jts.geomgraph.index.SweepLineEvent;
import org.locationtech.jts.geomgraph.index.SweepLineSegment;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J,\u0010\u0011\u001a\u00020\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u00052\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00140\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010\u001b\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0005H\u0002J \u0010\u001b\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00052\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u001a\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u00142\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\b\u0010\u001f\u001a\u00020\u0012H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J(\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006$"}, d2={"Lorg/locationtech/jts/geomgraph/index/SimpleSweepLineIntersector;", "Lorg/locationtech/jts/geomgraph/index/EdgeSetIntersector;", "<init>", "()V", "events", "", "Lorg/locationtech/jts/geomgraph/index/SweepLineEvent;", "getEvents", "()Ljava/util/List;", "setEvents", "(Ljava/util/List;)V", "nOverlaps", "", "getNOverlaps", "()I", "setNOverlaps", "(I)V", "computeIntersections", "", "edges", "Lorg/locationtech/jts/geomgraph/Edge;", "si", "Lorg/locationtech/jts/geomgraph/index/SegmentIntersector;", "testAllSegments", "", "edges0", "edges1", "add", "edgeSet", "", "edge", "prepareEvents", "processOverlaps", "start", "end", "ev0", "kts-core"})
public final class SimpleSweepLineIntersector
extends EdgeSetIntersector {
    @NotNull
    private List<SweepLineEvent> events = new ArrayList();
    private int nOverlaps;

    @NotNull
    public final List<SweepLineEvent> getEvents() {
        return this.events;
    }

    public final void setEvents(@NotNull List<SweepLineEvent> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.events = list;
    }

    public final int getNOverlaps() {
        return this.nOverlaps;
    }

    public final void setNOverlaps(int n) {
        this.nOverlaps = n;
    }

    @Override
    public void computeIntersections(@NotNull List<Edge> edges, @NotNull SegmentIntersector si, boolean testAllSegments) {
        Intrinsics.checkNotNullParameter(edges, (String)"edges");
        Intrinsics.checkNotNullParameter((Object)si, (String)"si");
        if (testAllSegments) {
            this.add(edges, null);
        } else {
            this.add(edges);
        }
        this.computeIntersections(si);
    }

    @Override
    public void computeIntersections(@NotNull List<Edge> edges0, @NotNull List<Edge> edges1, @NotNull SegmentIntersector si) {
        Intrinsics.checkNotNullParameter(edges0, (String)"edges0");
        Intrinsics.checkNotNullParameter(edges1, (String)"edges1");
        Intrinsics.checkNotNullParameter((Object)si, (String)"si");
        this.add(edges0, edges0);
        this.add(edges1, edges1);
        this.computeIntersections(si);
    }

    private final void add(List<Edge> edges) {
        Iterator<Edge> i = edges.iterator();
        while (i.hasNext()) {
            Edge edge;
            Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.Edge");
            this.add(edge, (Object)edge);
        }
    }

    private final void add(List<Edge> edges, Object edgeSet) {
        Iterator<Edge> i = edges.iterator();
        while (i.hasNext()) {
            Edge edge;
            Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.Edge");
            this.add(edge, edgeSet);
        }
    }

    private final void add(Edge edge, Object edgeSet) {
        Coordinate[] pts = edge.getCoordinates();
        int n = pts.length - 1;
        for (int i = 0; i < n; ++i) {
            SweepLineSegment ss = new SweepLineSegment(edge, i);
            SweepLineEvent insertEvent = new SweepLineEvent(edgeSet, ss.getMinX(), null);
            this.events.add(insertEvent);
            this.events.add(new SweepLineEvent(ss.getMaxX(), insertEvent));
        }
    }

    private final void prepareEvents() {
        CollectionsKt.sort(this.events);
        int n = ((Collection)this.events).size();
        for (int i = 0; i < n; ++i) {
            SweepLineEvent ev = this.events.get(i);
            if (!ev.isDelete()) continue;
            SweepLineEvent sweepLineEvent = ev.getInsertEvent();
            Intrinsics.checkNotNull((Object)sweepLineEvent);
            sweepLineEvent.setDeleteEventIndex(i);
        }
    }

    private final void computeIntersections(SegmentIntersector si) {
        this.nOverlaps = 0;
        this.prepareEvents();
        int n = ((Collection)this.events).size();
        for (int i = 0; i < n; ++i) {
            SweepLineEvent ev = this.events.get(i);
            if (!ev.isInsert()) continue;
            this.processOverlaps(i, ev.getDeleteEventIndex(), ev, si);
        }
    }

    private final void processOverlaps(int start, int end, SweepLineEvent ev0, SegmentIntersector si) {
        Object object = ev0.getObject();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.index.SweepLineSegment");
        SweepLineSegment ss0 = (SweepLineSegment)object;
        for (int i = start; i < end; ++i) {
            SweepLineEvent ev1 = this.events.get(i);
            if (!ev1.isInsert()) continue;
            Object object2 = ev1.getObject();
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.index.SweepLineSegment");
            SweepLineSegment ss1 = (SweepLineSegment)object2;
            if (ev0.isSameLabel(ev1)) continue;
            ss0.computeIntersections(ss1, si);
            int n = this.nOverlaps;
            this.nOverlaps = n + 1;
        }
    }
}

