/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph.index;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.index.SegmentIntersector;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u00002\u0006\u0010!\u001a\u00020\"R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\"\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001b\u00a8\u0006#"}, d2={"Lorg/locationtech/jts/geomgraph/index/SweepLineSegment;", "", "edge", "Lorg/locationtech/jts/geomgraph/Edge;", "ptIndex", "", "<init>", "(Lorg/locationtech/jts/geomgraph/Edge;I)V", "getEdge", "()Lorg/locationtech/jts/geomgraph/Edge;", "setEdge", "(Lorg/locationtech/jts/geomgraph/Edge;)V", "pts", "", "Lorg/locationtech/jts/geom/Coordinate;", "getPts", "()[Lorg/locationtech/jts/geom/Coordinate;", "setPts", "([Lorg/locationtech/jts/geom/Coordinate;)V", "[Lorg/locationtech/jts/geom/Coordinate;", "getPtIndex", "()I", "setPtIndex", "(I)V", "minX", "", "getMinX", "()D", "maxX", "getMaxX", "computeIntersections", "", "ss", "si", "Lorg/locationtech/jts/geomgraph/index/SegmentIntersector;", "kts-core"})
public final class SweepLineSegment {
    @NotNull
    private Edge edge;
    @NotNull
    private Coordinate[] pts;
    private int ptIndex;

    public SweepLineSegment(@NotNull Edge edge, int ptIndex) {
        Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
        this.edge = edge;
        this.ptIndex = ptIndex;
        this.pts = edge.getCoordinates();
    }

    @NotNull
    public final Edge getEdge() {
        return this.edge;
    }

    public final void setEdge(@NotNull Edge edge) {
        Intrinsics.checkNotNullParameter((Object)edge, (String)"<set-?>");
        this.edge = edge;
    }

    @NotNull
    public final Coordinate[] getPts() {
        return this.pts;
    }

    public final void setPts(@NotNull Coordinate[] coordinateArray) {
        Intrinsics.checkNotNullParameter((Object)coordinateArray, (String)"<set-?>");
        this.pts = coordinateArray;
    }

    public final int getPtIndex() {
        return this.ptIndex;
    }

    public final void setPtIndex(int n) {
        this.ptIndex = n;
    }

    public final double getMinX() {
        double x1 = this.pts[this.ptIndex].x;
        double x2 = this.pts[this.ptIndex + 1].x;
        return x1 < x2 ? x1 : x2;
    }

    public final double getMaxX() {
        double x1 = this.pts[this.ptIndex].x;
        double x2 = this.pts[this.ptIndex + 1].x;
        return x1 > x2 ? x1 : x2;
    }

    public final void computeIntersections(@Nullable SweepLineSegment ss, @NotNull SegmentIntersector si) {
        Intrinsics.checkNotNullParameter((Object)si, (String)"si");
        SweepLineSegment sweepLineSegment = ss;
        Intrinsics.checkNotNull((Object)sweepLineSegment);
        si.addIntersections(this.edge, this.ptIndex, sweepLineSegment.edge, ss.ptIndex);
    }
}

