/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.math.MathUtil;
import org.locationtech.jts.util.IntArrayList;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0018\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 /2\u00020\u0001:\u0001/B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0011\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u0003\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\tH\u0002J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000bH\u0002J\u0015\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0003H\u0002\u00a2\u0006\u0002\u0010\u0012J%\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0003H\u0002\u00a2\u0006\u0002\u0010\u001bJ\u001d\u0010\u001c\u001a\u00020\u00142\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0003H\u0002\u00a2\u0006\u0002\u0010\u001dJ\u000e\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\rJ(\u0010 \u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020$H\u0002J(\u0010%\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010'\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000bH\u0002J \u0010(\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010)\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020$H\u0002J\u000e\u0010*\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\u000bJ\u0018\u0010,\u001a\u00020-2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u000bH\u0002J\u0010\u0010.\u001a\u00020-2\u0006\u0010\"\u001a\u00020\u000bH\u0002R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0003X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/locationtech/jts/index/VertexSequencePackedRtree;", "", "items", "", "Lorg/locationtech/jts/geom/Coordinate;", "<init>", "([Lorg/locationtech/jts/geom/Coordinate;)V", "[Lorg/locationtech/jts/geom/Coordinate;", "levelOffset", "", "nodeCapacity", "", "bounds", "Lorg/locationtech/jts/geom/Envelope;", "[Lorg/locationtech/jts/geom/Envelope;", "isRemoved", "", "getBounds", "()[Lorg/locationtech/jts/geom/Envelope;", "build", "", "computeLevelOffsets", "levelNodeCount", "numNodes", "createBounds", "fillLevelBounds", "lvl", "(I[Lorg/locationtech/jts/geom/Envelope;)V", "fillItemBounds", "([Lorg/locationtech/jts/geom/Envelope;)V", "query", "queryEnv", "queryNode", "level", "nodeIndex", "resultList", "Lorg/locationtech/jts/util/IntArrayList;", "queryNodeRange", "nodeStartIndex", "levelSize", "queryItemRange", "itemIndex", "remove", "index", "isNodeEmpty", "", "isItemsNodeEmpty", "Companion", "kts-core"})
public final class VertexSequencePackedRtree {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Coordinate[] items;
    private int[] levelOffset;
    private final int nodeCapacity;
    private Envelope[] bounds;
    @NotNull
    private final boolean[] isRemoved;
    private static final int NODE_CAPACITY = 16;

    public VertexSequencePackedRtree(@NotNull Coordinate[] items) {
        Intrinsics.checkNotNullParameter((Object)items, (String)"items");
        this.items = items;
        this.nodeCapacity = 16;
        this.isRemoved = new boolean[this.items.length];
        this.build();
    }

    @NotNull
    public final Envelope[] getBounds() {
        Object[] objectArray = this.bounds;
        if (this.bounds == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bounds");
            objectArray = null;
        }
        Object[] objectArray2 = ArraysKt.requireNoNulls((Object[])objectArray);
        Object[] objectArray3 = Arrays.copyOf(objectArray2, objectArray2.length);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray3, (String)"copyOf(...)");
        return (Envelope[])objectArray3;
    }

    private final void build() {
        this.levelOffset = this.computeLevelOffsets();
        this.bounds = this.createBounds();
    }

    private final int[] computeLevelOffsets() {
        IntArrayList offsets = new IntArrayList(0, 1, null);
        offsets.add(0);
        int levelSize = this.items.length;
        int currOffset = 0;
        do {
            levelSize = this.levelNodeCount(levelSize);
            offsets.add(currOffset += levelSize);
        } while (levelSize > 1);
        return offsets.toArray();
    }

    private final int levelNodeCount(int numNodes) {
        return MathUtil.INSTANCE.ceil(numNodes, this.nodeCapacity);
    }

    private final Envelope[] createBounds() {
        int[] nArray = this.levelOffset;
        if (this.levelOffset == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"levelOffset");
            nArray = null;
        }
        int[] nArray2 = this.levelOffset;
        if (this.levelOffset == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"levelOffset");
            nArray2 = null;
        }
        int boundsSize = nArray[nArray2.length - 1] + 1;
        Envelope[] bounds = new Envelope[boundsSize];
        this.fillItemBounds(bounds);
        int lvl = 1;
        int[] nArray3 = this.levelOffset;
        if (this.levelOffset == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"levelOffset");
            nArray3 = null;
        }
        int n = nArray3.length;
        while (lvl < n) {
            this.fillLevelBounds(lvl, bounds);
            ++lvl;
        }
        return bounds;
    }

    private final void fillLevelBounds(int lvl, Envelope[] bounds) {
        int nodeEnd;
        int[] nArray = this.levelOffset;
        if (this.levelOffset == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"levelOffset");
            nArray = null;
        }
        int levelStart = nArray[lvl - 1];
        int[] nArray2 = this.levelOffset;
        if (this.levelOffset == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"levelOffset");
            nArray2 = null;
        }
        int levelEnd = nArray2[lvl];
        int nodeStart = levelStart;
        int[] nArray3 = this.levelOffset;
        if (this.levelOffset == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"levelOffset");
            nArray3 = null;
        }
        int levelBoundIndex = nArray3[lvl];
        do {
            nodeEnd = MathUtil.INSTANCE.clampMax(nodeStart + this.nodeCapacity, levelEnd);
            bounds[levelBoundIndex++] = VertexSequencePackedRtree.Companion.computeNodeEnvelope(bounds, nodeStart, nodeEnd);
        } while ((nodeStart = nodeEnd) < levelEnd);
    }

    private final void fillItemBounds(Envelope[] bounds) {
        int nodeEnd;
        int nodeStart = 0;
        int boundIndex = 0;
        do {
            nodeEnd = MathUtil.INSTANCE.clampMax(nodeStart + this.nodeCapacity, this.items.length);
            bounds[boundIndex++] = VertexSequencePackedRtree.Companion.computeItemEnvelope(this.items, nodeStart, nodeEnd);
        } while ((nodeStart = nodeEnd) < this.items.length);
    }

    @NotNull
    public final int[] query(@NotNull Envelope queryEnv) {
        Intrinsics.checkNotNullParameter((Object)queryEnv, (String)"queryEnv");
        IntArrayList resultList = new IntArrayList(0, 1, null);
        int[] nArray = this.levelOffset;
        if (this.levelOffset == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"levelOffset");
            nArray = null;
        }
        int level = nArray.length - 1;
        this.queryNode(queryEnv, level, 0, resultList);
        return resultList.toArray();
    }

    private final void queryNode(Envelope queryEnv, int level, int nodeIndex, IntArrayList resultList) {
        int[] nArray = this.levelOffset;
        if (this.levelOffset == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"levelOffset");
            nArray = null;
        }
        int boundsIndex = nArray[level] + nodeIndex;
        Envelope[] envelopeArray = this.bounds;
        if (this.bounds == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bounds");
            envelopeArray = null;
        }
        Envelope envelope = envelopeArray[boundsIndex];
        if (envelope == null) {
            return;
        }
        Envelope nodeEnv = envelope;
        if (!queryEnv.intersects(nodeEnv)) {
            return;
        }
        int childNodeIndex = nodeIndex * this.nodeCapacity;
        if (level == 0) {
            this.queryItemRange(queryEnv, childNodeIndex, resultList);
        } else {
            this.queryNodeRange(queryEnv, level - 1, childNodeIndex, resultList);
        }
    }

    private final void queryNodeRange(Envelope queryEnv, int level, int nodeStartIndex, IntArrayList resultList) {
        int levelMax = this.levelSize(level);
        int n = this.nodeCapacity;
        for (int i = 0; i < n; ++i) {
            int index = nodeStartIndex + i;
            if (index >= levelMax) {
                return;
            }
            this.queryNode(queryEnv, level, index, resultList);
        }
    }

    private final int levelSize(int level) {
        int[] nArray = this.levelOffset;
        if (this.levelOffset == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"levelOffset");
            nArray = null;
        }
        int n = nArray[level + 1];
        int[] nArray2 = this.levelOffset;
        if (this.levelOffset == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"levelOffset");
            nArray2 = null;
        }
        return n - nArray2[level];
    }

    private final void queryItemRange(Envelope queryEnv, int itemIndex, IntArrayList resultList) {
        int n = this.nodeCapacity;
        for (int i = 0; i < n; ++i) {
            int index = itemIndex + i;
            if (index >= this.items.length) {
                return;
            }
            Coordinate p = this.items[index];
            if (this.isRemoved[index] || !queryEnv.contains(p)) continue;
            resultList.add(index);
        }
    }

    public final void remove(int index) {
        this.isRemoved[index] = true;
        int nodeIndex = index / this.nodeCapacity;
        if (!this.isItemsNodeEmpty(nodeIndex)) {
            return;
        }
        Envelope[] envelopeArray = this.bounds;
        if (this.bounds == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bounds");
            envelopeArray = null;
        }
        envelopeArray[nodeIndex] = null;
        int[] nArray = this.levelOffset;
        if (this.levelOffset == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"levelOffset");
            nArray = null;
        }
        if (nArray.length <= 2) {
            return;
        }
        int nodeLevelIndex = nodeIndex / this.nodeCapacity;
        if (!this.isNodeEmpty(1, nodeLevelIndex)) {
            return;
        }
        int[] nArray2 = this.levelOffset;
        if (this.levelOffset == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"levelOffset");
            nArray2 = null;
        }
        int nodeIndex1 = nArray2[1] + nodeLevelIndex;
        Envelope[] envelopeArray2 = this.bounds;
        if (this.bounds == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bounds");
            envelopeArray2 = null;
        }
        envelopeArray2[nodeIndex1] = null;
    }

    private final boolean isNodeEmpty(int level, int index) {
        int start = index * this.nodeCapacity;
        int[] nArray = this.levelOffset;
        if (this.levelOffset == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"levelOffset");
            nArray = null;
        }
        int end = MathUtil.INSTANCE.clampMax(start + this.nodeCapacity, nArray[level]);
        for (int i = start; i < end; ++i) {
            Envelope[] envelopeArray = this.bounds;
            if (this.bounds == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bounds");
                envelopeArray = null;
            }
            if (envelopeArray[i] == null) continue;
            return false;
        }
        return true;
    }

    private final boolean isItemsNodeEmpty(int nodeIndex) {
        int start = nodeIndex * this.nodeCapacity;
        int end = MathUtil.INSTANCE.clampMax(start + this.nodeCapacity, this.items.length);
        for (int i = start; i < end; ++i) {
            if (this.isRemoved[i]) continue;
            return false;
        }
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\fJ+\u0010\r\u001a\u00020\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/locationtech/jts/index/VertexSequencePackedRtree$Companion;", "", "<init>", "()V", "NODE_CAPACITY", "", "computeNodeEnvelope", "Lorg/locationtech/jts/geom/Envelope;", "bounds", "", "start", "end", "([Lorg/locationtech/jts/geom/Envelope;II)Lorg/locationtech/jts/geom/Envelope;", "computeItemEnvelope", "items", "Lorg/locationtech/jts/geom/Coordinate;", "([Lorg/locationtech/jts/geom/Coordinate;II)Lorg/locationtech/jts/geom/Envelope;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        private final Envelope computeNodeEnvelope(Envelope[] bounds, int start, int end) {
            Envelope env = new Envelope();
            for (int i = start; i < end; ++i) {
                Envelope envelope = bounds[i];
                Intrinsics.checkNotNull((Object)envelope);
                env.expandToInclude(envelope);
            }
            return env;
        }

        private final Envelope computeItemEnvelope(Coordinate[] items, int start, int end) {
            Envelope env = new Envelope();
            for (int i = start; i < end; ++i) {
                env.expandToInclude(items[i]);
            }
            return env;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

