/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.bintree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.index.bintree.Interval;
import org.locationtech.jts.index.bintree.Node;
import org.locationtech.jts.index.bintree.Root;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\tJ\u0006\u0010\u000b\u001a\u00020\tJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001J\r\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0086\u0002J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u00172\u0006\u0010\u0018\u001a\u00020\u0007J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u000fJ\u001e\u0010\u0016\u001a\u00020\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u001bJ\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u000fH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/locationtech/jts/index/bintree/Bintree;", "", "<init>", "()V", "root", "Lorg/locationtech/jts/index/bintree/Root;", "minExtent", "", "depth", "", "size", "nodeSize", "insert", "", "itemInterval", "Lorg/locationtech/jts/index/bintree/Interval;", "item", "Lorg/locationtech/jts/index/bintree/Node;", "remove", "", "iterator", "", "query", "", "x", "interval", "foundItems", "", "collectStats", "Companion", "kts-core"})
public final class Bintree {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Root root = new Root();
    private double minExtent = 1.0;

    public final int depth() {
        Root root = this.root;
        return root != null ? root.depth() : 0;
    }

    public final int size() {
        Root root = this.root;
        return root != null ? root.size() : 0;
    }

    public final int nodeSize() {
        Root root = this.root;
        return root != null ? root.nodeSize() : 0;
    }

    public final void insert(@NotNull Interval itemInterval, @NotNull Node item) {
        Intrinsics.checkNotNullParameter((Object)itemInterval, (String)"itemInterval");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.collectStats(itemInterval);
        Interval insertInterval = Companion.ensureExtent(itemInterval, this.minExtent);
        Root root = this.root;
        Intrinsics.checkNotNull((Object)root);
        root.insert(insertInterval, item);
    }

    public final boolean remove(@NotNull Interval itemInterval, @Nullable Object item) {
        Intrinsics.checkNotNullParameter((Object)itemInterval, (String)"itemInterval");
        Interval insertInterval = Companion.ensureExtent(itemInterval, this.minExtent);
        Root root = this.root;
        Intrinsics.checkNotNull((Object)root);
        return root.remove(insertInterval, item);
    }

    @NotNull
    public final Iterator<?> iterator() {
        List foundItems = new ArrayList();
        Root root = this.root;
        Intrinsics.checkNotNull((Object)root);
        root.addAllItems(foundItems);
        return foundItems.iterator();
    }

    @NotNull
    public final List<Node> query(double x) {
        return this.query(new Interval(x, x));
    }

    @NotNull
    public final List<Node> query(@Nullable Interval interval) {
        List foundItems = new ArrayList();
        this.query(interval, foundItems);
        return foundItems;
    }

    public final void query(@Nullable Interval interval, @NotNull Collection<Node> foundItems) {
        Intrinsics.checkNotNullParameter(foundItems, (String)"foundItems");
        Root root = this.root;
        Intrinsics.checkNotNull((Object)root);
        root.addAllItemsFromOverlapping(interval, foundItems);
    }

    private final void collectStats(Interval interval) {
        double del = interval.getWidth();
        if (del < this.minExtent && del > 0.0) {
            this.minExtent = del;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/locationtech/jts/index/bintree/Bintree$Companion;", "", "<init>", "()V", "ensureExtent", "Lorg/locationtech/jts/index/bintree/Interval;", "itemInterval", "minExtent", "", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Interval ensureExtent(@NotNull Interval itemInterval, double minExtent) {
            Intrinsics.checkNotNullParameter((Object)itemInterval, (String)"itemInterval");
            double min = itemInterval.getMin();
            double max = itemInterval.getMax();
            if (!(min == max)) {
                return itemInterval;
            }
            if (min == max) {
                max = (min -= minExtent / 2.0) + minExtent / 2.0;
            }
            return new Interval(min, max);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

