/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.bintree;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.index.bintree.Interval;
import org.locationtech.jts.index.quadtree.DoubleBits;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003J\u0018\u0010\u0013\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0003H\u0002R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/locationtech/jts/index/bintree/Key;", "", "interval", "Lorg/locationtech/jts/index/bintree/Interval;", "<init>", "(Lorg/locationtech/jts/index/bintree/Interval;)V", "value", "", "point", "getPoint", "()D", "", "level", "getLevel", "()I", "getInterval", "computeKey", "", "itemInterval", "computeInterval", "Companion", "kts-core"})
public final class Key {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double point;
    private int level;
    @Nullable
    private Interval interval;

    public Key(@NotNull Interval interval) {
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        this.computeKey(interval);
    }

    public final double getPoint() {
        return this.point;
    }

    public final int getLevel() {
        return this.level;
    }

    @Nullable
    public final Interval getInterval() {
        return this.interval;
    }

    public final void computeKey(@NotNull Interval itemInterval) {
        Intrinsics.checkNotNullParameter((Object)itemInterval, (String)"itemInterval");
        this.level = Companion.computeLevel(itemInterval);
        this.interval = new Interval();
        this.computeInterval(this.level, itemInterval);
        while (true) {
            Interval interval = this.interval;
            Intrinsics.checkNotNull((Object)interval);
            if (interval.contains(itemInterval)) break;
            ++this.level;
            this.computeInterval(this.level, itemInterval);
        }
    }

    private final void computeInterval(int level, Interval itemInterval) {
        double size = DoubleBits.Companion.powerOf2(level);
        this.point = Math.INSTANCE.floor(itemInterval.getMin() / size) * size;
        Interval interval = this.interval;
        Intrinsics.checkNotNull((Object)interval);
        interval.init(this.point, this.point + size);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/locationtech/jts/index/bintree/Key$Companion;", "", "<init>", "()V", "computeLevel", "", "interval", "Lorg/locationtech/jts/index/bintree/Interval;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final int computeLevel(@NotNull Interval interval) {
            Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
            double dx = interval.getWidth();
            return DoubleBits.Companion.exponent(dx) + 1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

