/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.bintree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.index.bintree.Interval;
import org.locationtech.jts.index.bintree.Node;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0004\b&\u0018\u0000 (2\u00020\u0001:\u0001(B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0006J\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH$J\u001e\u0010\u001b\u001a\u00020\u00142\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u001dJ\u001a\u0010\u001e\u001a\u00020\u00182\b\u0010\u001f\u001a\u0004\u0018\u00010\u001a2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001J\u0006\u0010\"\u001a\u00020\u0018J\u0006\u0010#\u001a\u00020\u0018J\u0006\u0010$\u001a\u00020%J\u0006\u0010&\u001a\u00020%J\u0006\u0010'\u001a\u00020%R0\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR$\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\rX\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0012\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010 \u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006)"}, d2={"Lorg/locationtech/jts/index/bintree/NodeBase;", "", "<init>", "()V", "value", "", "Lorg/locationtech/jts/index/bintree/Node;", "items", "getItems", "()Ljava/util/List;", "setItems", "(Ljava/util/List;)V", "subnode", "", "getSubnode", "()[Lorg/locationtech/jts/index/bintree/Node;", "setSubnode", "([Lorg/locationtech/jts/index/bintree/Node;)V", "[Lorg/locationtech/jts/index/bintree/Node;", "add", "", "item", "addAllItems", "isSearchMatch", "", "interval", "Lorg/locationtech/jts/index/bintree/Interval;", "addAllItemsFromOverlapping", "resultItems", "", "remove", "itemInterval", "isPrunable", "()Z", "hasChildren", "hasItems", "depth", "", "size", "nodeSize", "Companion", "kts-core"})
public abstract class NodeBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<Node> items = new ArrayList();
    @NotNull
    private Node[] subnode = new Node[2];

    @NotNull
    public final List<Node> getItems() {
        return this.items;
    }

    protected final void setItems(@NotNull List<Node> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.items = list;
    }

    @NotNull
    protected final Node[] getSubnode() {
        return this.subnode;
    }

    protected final void setSubnode(@NotNull Node[] nodeArray) {
        Intrinsics.checkNotNullParameter((Object)nodeArray, (String)"<set-?>");
        this.subnode = nodeArray;
    }

    public final void add(@NotNull Node item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.items.add(item);
    }

    @NotNull
    public final List<Node> addAllItems(@NotNull List<Node> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        items.addAll((Collection<Node>)this.items);
        for (int i = 0; i < 2; ++i) {
            if (this.subnode[i] == null) continue;
            Node node = this.subnode[i];
            Intrinsics.checkNotNull((Object)node);
            node.addAllItems(items);
        }
        return items;
    }

    protected abstract boolean isSearchMatch(@Nullable Interval var1);

    public final void addAllItemsFromOverlapping(@Nullable Interval interval, @NotNull Collection<Node> resultItems) {
        Intrinsics.checkNotNullParameter(resultItems, (String)"resultItems");
        if (interval != null && !this.isSearchMatch(interval)) {
            return;
        }
        resultItems.addAll((Collection<Node>)this.items);
        if (this.subnode[0] != null) {
            Node node = this.subnode[0];
            Intrinsics.checkNotNull((Object)node);
            node.addAllItemsFromOverlapping(interval, resultItems);
        }
        if (this.subnode[1] != null) {
            Node node = this.subnode[1];
            Intrinsics.checkNotNull((Object)node);
            node.addAllItemsFromOverlapping(interval, resultItems);
        }
    }

    public final boolean remove(@Nullable Interval itemInterval, @Nullable Object item) {
        if (!this.isSearchMatch(itemInterval)) {
            return false;
        }
        boolean found = false;
        for (int i = 0; i < 2; ++i) {
            if (this.subnode[i] == null) continue;
            Node node = this.subnode[i];
            Intrinsics.checkNotNull((Object)node);
            found = node.remove(itemInterval, item);
            if (!found) continue;
            Node node2 = this.subnode[i];
            Intrinsics.checkNotNull((Object)node2);
            if (!node2.isPrunable()) break;
            this.subnode[i] = null;
            break;
        }
        if (found) {
            return found;
        }
        found = TypeIntrinsics.asMutableCollection((Object)this.items).remove(item);
        return found;
    }

    public final boolean isPrunable() {
        return !this.hasChildren() && !this.hasItems();
    }

    public final boolean hasChildren() {
        for (int i = 0; i < 2; ++i) {
            if (this.subnode[i] == null) continue;
            return true;
        }
        return false;
    }

    public final boolean hasItems() {
        return !((Collection)this.items).isEmpty();
    }

    public final int depth() {
        int maxSubDepth = 0;
        for (int i = 0; i < 2; ++i) {
            if (this.subnode[i] == null) continue;
            Node node = this.subnode[i];
            Intrinsics.checkNotNull((Object)node);
            int sqd = node.depth();
            if (sqd <= maxSubDepth) continue;
            maxSubDepth = sqd;
        }
        return maxSubDepth + 1;
    }

    public final int size() {
        int subSize = 0;
        for (int i = 0; i < 2; ++i) {
            if (this.subnode[i] == null) continue;
            Node node = this.subnode[i];
            Intrinsics.checkNotNull((Object)node);
            subSize += node.size();
        }
        return subSize + this.items.size();
    }

    public final int nodeSize() {
        int subSize = 0;
        for (int i = 0; i < 2; ++i) {
            if (this.subnode[i] == null) continue;
            Node node = this.subnode[i];
            Intrinsics.checkNotNull((Object)node);
            subSize += node.nodeSize();
        }
        return subSize + 1;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/locationtech/jts/index/bintree/NodeBase$Companion;", "", "<init>", "()V", "getSubnodeIndex", "", "interval", "Lorg/locationtech/jts/index/bintree/Interval;", "centre", "", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final int getSubnodeIndex(@Nullable Interval interval, double centre) {
            int subnodeIndex = -1;
            Interval interval2 = interval;
            Intrinsics.checkNotNull((Object)interval2);
            if (interval2.getMin() >= centre) {
                subnodeIndex = 1;
            }
            if (interval.getMax() <= centre) {
                subnodeIndex = 0;
            }
            return subnodeIndex;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

