/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.chain;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.index.chain.MonotoneChainOverlapAction;
import org.locationtech.jts.index.chain.MonotoneChainSelectAction;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001aJ\u0016\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"J\u0016\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020)J(\u0010*\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\u00102\u0006\u0010+\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u00062\u0006\u0010(\u001a\u00020)H\u0002J\u0016\u0010-\u001a\u00020\u00182\u0006\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u000200J\u001e\u0010-\u001a\u00020\u00182\u0006\u0010.\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u001a2\u0006\u0010/\u001a\u000200J@\u0010-\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u00062\u0006\u0010.\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u00062\u0006\u00103\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u001a2\u0006\u0010/\u001a\u000200H\u0002J8\u00104\u001a\u0002052\u0006\u0010+\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u00062\u0006\u0010.\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u00062\u0006\u00103\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u001aH\u0002J0\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u00042\u0006\u00109\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u001aH\u0002R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u001b\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0019\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00038F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006:"}, d2={"Lorg/locationtech/jts/index/chain/MonotoneChain;", "", "pts", "", "Lorg/locationtech/jts/geom/Coordinate;", "startIndex", "", "endIndex", "context", "<init>", "([Lorg/locationtech/jts/geom/Coordinate;IILjava/lang/Object;)V", "[Lorg/locationtech/jts/geom/Coordinate;", "getStartIndex", "()I", "getEndIndex", "env", "Lorg/locationtech/jts/geom/Envelope;", "getContext", "()Ljava/lang/Object;", "id", "getId", "setId", "(I)V", "setOverlapDistance", "", "distance", "", "envelope", "getEnvelope", "()Lorg/locationtech/jts/geom/Envelope;", "expansionDistance", "getLineSegment", "index", "ls", "Lorg/locationtech/jts/geom/LineSegment;", "coordinates", "getCoordinates", "()[Lorg/locationtech/jts/geom/Coordinate;", "select", "searchEnv", "mcs", "Lorg/locationtech/jts/index/chain/MonotoneChainSelectAction;", "computeSelect", "start0", "end0", "computeOverlaps", "mc", "mco", "Lorg/locationtech/jts/index/chain/MonotoneChainOverlapAction;", "overlapTolerance", "start1", "end1", "overlaps", "", "p1", "p2", "q1", "q2", "kts-core"})
public final class MonotoneChain {
    @NotNull
    private final Coordinate[] pts;
    private final int startIndex;
    private final int endIndex;
    @Nullable
    private Envelope env;
    @Nullable
    private final Object context;
    private int id;

    public MonotoneChain(@NotNull Coordinate[] pts, int startIndex, int endIndex, @Nullable Object context) {
        Intrinsics.checkNotNullParameter((Object)pts, (String)"pts");
        this.pts = pts;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.context = context;
    }

    public final int getStartIndex() {
        return this.startIndex;
    }

    public final int getEndIndex() {
        return this.endIndex;
    }

    @Nullable
    public final Object getContext() {
        return this.context;
    }

    public final int getId() {
        return this.id;
    }

    public final void setId(int n) {
        this.id = n;
    }

    public final void setOverlapDistance(double distance) {
    }

    @NotNull
    public final Envelope getEnvelope() {
        return this.getEnvelope(0.0);
    }

    @NotNull
    public final Envelope getEnvelope(double expansionDistance) {
        if (this.env == null) {
            Coordinate p0 = this.pts[this.startIndex];
            Coordinate p1 = this.pts[this.endIndex];
            this.env = new Envelope(p0, p1);
            if (expansionDistance > 0.0) {
                Envelope envelope = this.env;
                Intrinsics.checkNotNull((Object)envelope);
                envelope.expandBy(expansionDistance);
            }
        }
        Envelope envelope = this.env;
        Intrinsics.checkNotNull((Object)envelope);
        return envelope;
    }

    public final void getLineSegment(int index, @NotNull LineSegment ls) {
        Intrinsics.checkNotNullParameter((Object)ls, (String)"ls");
        ls.p0 = this.pts[index];
        ls.p1 = this.pts[index + 1];
    }

    @NotNull
    public final Coordinate[] getCoordinates() {
        Coordinate[] coord = new Coordinate[this.endIndex - this.startIndex + 1];
        int index = 0;
        int i = this.startIndex;
        int n = this.endIndex;
        if (i <= n) {
            while (true) {
                coord[index++] = this.pts[i];
                if (i == n) break;
                ++i;
            }
        }
        return coord;
    }

    public final void select(@NotNull Envelope searchEnv, @NotNull MonotoneChainSelectAction mcs) {
        Intrinsics.checkNotNullParameter((Object)searchEnv, (String)"searchEnv");
        Intrinsics.checkNotNullParameter((Object)mcs, (String)"mcs");
        this.computeSelect(searchEnv, this.startIndex, this.endIndex, mcs);
    }

    private final void computeSelect(Envelope searchEnv, int start0, int end0, MonotoneChainSelectAction mcs) {
        Coordinate p0 = this.pts[start0];
        Coordinate p1 = this.pts[end0];
        if (end0 - start0 == 1) {
            mcs.select(this, start0);
            return;
        }
        if (!searchEnv.intersects(p0, p1)) {
            return;
        }
        int mid = (start0 + end0) / 2;
        if (start0 < mid) {
            this.computeSelect(searchEnv, start0, mid, mcs);
        }
        if (mid < end0) {
            this.computeSelect(searchEnv, mid, end0, mcs);
        }
    }

    public final void computeOverlaps(@NotNull MonotoneChain mc, @NotNull MonotoneChainOverlapAction mco) {
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        Intrinsics.checkNotNullParameter((Object)mco, (String)"mco");
        this.computeOverlaps(this.startIndex, this.endIndex, mc, mc.startIndex, mc.endIndex, 0.0, mco);
    }

    public final void computeOverlaps(@NotNull MonotoneChain mc, double overlapTolerance, @NotNull MonotoneChainOverlapAction mco) {
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        Intrinsics.checkNotNullParameter((Object)mco, (String)"mco");
        this.computeOverlaps(this.startIndex, this.endIndex, mc, mc.startIndex, mc.endIndex, overlapTolerance, mco);
    }

    private final void computeOverlaps(int start0, int end0, MonotoneChain mc, int start1, int end1, double overlapTolerance, MonotoneChainOverlapAction mco) {
        if (end0 - start0 == 1 && end1 - start1 == 1) {
            mco.overlap(this, start0, mc, start1);
            return;
        }
        if (!this.overlaps(start0, end0, mc, start1, end1, overlapTolerance)) {
            return;
        }
        int mid0 = (start0 + end0) / 2;
        int mid1 = (start1 + end1) / 2;
        if (start0 < mid0) {
            if (start1 < mid1) {
                this.computeOverlaps(start0, mid0, mc, start1, mid1, overlapTolerance, mco);
            }
            if (mid1 < end1) {
                this.computeOverlaps(start0, mid0, mc, mid1, end1, overlapTolerance, mco);
            }
        }
        if (mid0 < end0) {
            if (start1 < mid1) {
                this.computeOverlaps(mid0, end0, mc, start1, mid1, overlapTolerance, mco);
            }
            if (mid1 < end1) {
                this.computeOverlaps(mid0, end0, mc, mid1, end1, overlapTolerance, mco);
            }
        }
    }

    private final boolean overlaps(int start0, int end0, MonotoneChain mc, int start1, int end1, double overlapTolerance) {
        return overlapTolerance > 0.0 ? this.overlaps(this.pts[start0], this.pts[end0], mc.pts[start1], mc.pts[end1], overlapTolerance) : Envelope.Companion.intersects(this.pts[start0], this.pts[end0], mc.pts[start1], mc.pts[end1]);
    }

    private final boolean overlaps(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2, double overlapTolerance) {
        double minq = Math.INSTANCE.min(q1.x, q2.x);
        double maxq = Math.INSTANCE.max(q1.x, q2.x);
        double minp = Math.INSTANCE.min(p1.x, p2.x);
        double maxp = Math.INSTANCE.max(p1.x, p2.x);
        if (minp > maxq + overlapTolerance) {
            return false;
        }
        if (maxp < minq - overlapTolerance) {
            return false;
        }
        minq = Math.INSTANCE.min(q1.y, q2.y);
        maxq = Math.INSTANCE.max(q1.y, q2.y);
        minp = Math.INSTANCE.min(p1.y, p2.y);
        maxp = Math.INSTANCE.max(p1.y, p2.y);
        if (minp > maxq + overlapTolerance) {
            return false;
        }
        return maxp >= minq - overlapTolerance;
    }
}

