/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.hprtree;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.ArrayListVisitor;
import org.locationtech.jts.index.ItemVisitor;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.hprtree.HilbertEncoder;
import org.locationtech.jts.index.hprtree.Item;
import org.locationtech.jts.legacy.Synchronized;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0006\u0018\u0000 ?2\u00020\u0001:\u0002>?B\u0013\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0013\u001a\u00020\u0003J\u001c\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0016\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\fH\u0016J\u001c\u0010\u0019\u001a\u00020\u00152\b\u0010\u001b\u001a\u0004\u0018\u00010\f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J(\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\fH\u0002J(\u0010%\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J \u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010)\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0003H\u0002J\u001c\u0010*\u001a\u00020\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010+\u001a\u00020\u0015H\u0007J\u0010\u0010,\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u0003H\u0002J \u0010-\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u0003H\u0002J\u0010\u0010/\u001a\u00020\u00152\u0006\u0010)\u001a\u00020\u0003H\u0002J\u0018\u00100\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u0003H\u0002J0\u00101\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u00032\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002032\u0006\u00105\u001a\u0002032\u0006\u00106\u001a\u000203H\u0002J\u0010\u00107\u001a\u00020\f2\u0006\u00108\u001a\u00020\u0003H\u0002J\b\u0010=\u001a\u00020\u0015H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u00109\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0:8F\u00a2\u0006\u0006\u001a\u0004\b;\u0010<\u00a8\u0006@"}, d2={"Lorg/locationtech/jts/index/hprtree/HPRtree;", "Lorg/locationtech/jts/index/SpatialIndex;", "nodeCapacity", "", "<init>", "(I)V", "getNodeCapacity", "()I", "items", "", "Lorg/locationtech/jts/index/hprtree/Item;", "totalExtent", "Lorg/locationtech/jts/geom/Envelope;", "layerStartIndex", "", "nodeBounds", "", "isBuilt", "", "size", "insert", "", "itemEnv", "item", "", "query", "", "searchEnv", "visitor", "Lorg/locationtech/jts/index/ItemVisitor;", "queryTopLayer", "queryNode", "layerIndex", "nodeOffset", "intersects", "nodeIndex", "env", "queryNodeChildren", "blockOffset", "queryItems", "blockStart", "layerSize", "remove", "build", "computeLayerNodes", "computeNodeBounds", "nodeMaxIndex", "computeLeafNodes", "computeLeafNodeBounds", "updateNodeBounds", "minX", "", "minY", "maxX", "maxY", "getNodeEnvelope", "i", "bounds", "", "getBounds", "()[Lorg/locationtech/jts/geom/Envelope;", "sortItems", "ItemComparator", "Companion", "kts-core"})
public final class HPRtree
implements SpatialIndex {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int nodeCapacity;
    @NotNull
    private final List<Item> items;
    @NotNull
    private final Envelope totalExtent;
    @Nullable
    private int[] layerStartIndex;
    @Nullable
    private double[] nodeBounds;
    private boolean isBuilt;
    private static final int ENV_SIZE = 4;
    private static final int HILBERT_LEVEL = 12;
    private static final int DEFAULT_NODE_CAPACITY = 16;

    @JvmOverloads
    public HPRtree(int nodeCapacity) {
        this.nodeCapacity = nodeCapacity;
        this.items = new ArrayList();
        this.totalExtent = new Envelope();
    }

    public /* synthetic */ HPRtree(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 16;
        }
        this(n);
    }

    public final int getNodeCapacity() {
        return this.nodeCapacity;
    }

    public final int size() {
        return this.items.size();
    }

    @Override
    public void insert(@Nullable Envelope itemEnv, @Nullable Object item) {
        if (this.isBuilt) {
            throw new IllegalStateException("Cannot insert items after tree is built.");
        }
        Envelope envelope = itemEnv;
        Intrinsics.checkNotNull((Object)envelope);
        Object object = item;
        Intrinsics.checkNotNull((Object)object);
        this.items.add(new Item(envelope, object));
        this.totalExtent.expandToInclude(itemEnv);
    }

    @Override
    @NotNull
    public List<?> query(@Nullable Envelope searchEnv) {
        this.build();
        Envelope envelope = searchEnv;
        Intrinsics.checkNotNull((Object)envelope);
        if (!this.totalExtent.intersects(envelope)) {
            return new ArrayList();
        }
        ArrayListVisitor visitor = new ArrayListVisitor();
        this.query(searchEnv, visitor);
        return visitor.getItems();
    }

    @Override
    public void query(@Nullable Envelope searchEnv, @Nullable ItemVisitor visitor) {
        this.build();
        Envelope envelope = searchEnv;
        Intrinsics.checkNotNull((Object)envelope);
        if (!this.totalExtent.intersects(envelope)) {
            return;
        }
        if (this.layerStartIndex == null) {
            ItemVisitor itemVisitor = visitor;
            Intrinsics.checkNotNull((Object)itemVisitor);
            this.queryItems(0, searchEnv, itemVisitor);
        } else {
            ItemVisitor itemVisitor = visitor;
            Intrinsics.checkNotNull((Object)itemVisitor);
            this.queryTopLayer(searchEnv, itemVisitor);
        }
    }

    private final void queryTopLayer(Envelope searchEnv, ItemVisitor visitor) {
        Intrinsics.checkNotNull((Object)this.layerStartIndex);
        int layerIndex = this.layerStartIndex.length - 2;
        int layerSize = this.layerSize(layerIndex);
        for (int i = 0; i < layerSize; i += 4) {
            this.queryNode(layerIndex, i, searchEnv, visitor);
        }
    }

    private final void queryNode(int layerIndex, int nodeOffset, Envelope searchEnv, ItemVisitor visitor) {
        Intrinsics.checkNotNull((Object)this.layerStartIndex);
        int layerStart = this.layerStartIndex[layerIndex];
        int nodeIndex = layerStart + nodeOffset;
        if (!this.intersects(nodeIndex, searchEnv)) {
            return;
        }
        if (layerIndex == 0) {
            int childNodesOffset = nodeOffset / 4 * this.nodeCapacity;
            this.queryItems(childNodesOffset, searchEnv, visitor);
        } else {
            int childNodesOffset = nodeOffset * this.nodeCapacity;
            this.queryNodeChildren(layerIndex - 1, childNodesOffset, searchEnv, visitor);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean intersects(int nodeIndex, Envelope env) {
        double d = env.getMaxX();
        Intrinsics.checkNotNull((Object)this.nodeBounds);
        if (d < this.nodeBounds[nodeIndex]) return false;
        double d2 = env.getMaxY();
        Intrinsics.checkNotNull((Object)this.nodeBounds);
        if (d2 < this.nodeBounds[nodeIndex + 1]) return false;
        double d3 = env.getMinX();
        Intrinsics.checkNotNull((Object)this.nodeBounds);
        if (d3 > this.nodeBounds[nodeIndex + 2]) return false;
        double d4 = env.getMinY();
        Intrinsics.checkNotNull((Object)this.nodeBounds);
        if (!(d4 > this.nodeBounds[nodeIndex + 3])) return true;
        return false;
    }

    private final void queryNodeChildren(int layerIndex, int blockOffset, Envelope searchEnv, ItemVisitor visitor) {
        int nodeOffset;
        Intrinsics.checkNotNull((Object)this.layerStartIndex);
        int layerStart = this.layerStartIndex[layerIndex];
        Intrinsics.checkNotNull((Object)this.layerStartIndex);
        int layerEnd = this.layerStartIndex[layerIndex + 1];
        int n = this.nodeCapacity;
        for (int i = 0; i < n && layerStart + (nodeOffset = blockOffset + 4 * i) < layerEnd; ++i) {
            this.queryNode(layerIndex, nodeOffset, searchEnv, visitor);
        }
    }

    private final void queryItems(int blockStart, Envelope searchEnv, ItemVisitor visitor) {
        int itemIndex;
        int n = this.nodeCapacity;
        for (int i = 0; i < n && (itemIndex = blockStart + i) < this.items.size(); ++i) {
            Item item = this.items.get(itemIndex);
            if (!HPRtree.Companion.intersects(item.getEnvelope(), searchEnv)) continue;
            visitor.visitItem(item.getItem());
        }
    }

    private final int layerSize(int layerIndex) {
        Intrinsics.checkNotNull((Object)this.layerStartIndex);
        int layerStart = this.layerStartIndex[layerIndex];
        Intrinsics.checkNotNull((Object)this.layerStartIndex);
        int layerEnd = this.layerStartIndex[layerIndex + 1];
        return layerEnd - layerStart;
    }

    @Override
    public boolean remove(@Nullable Envelope itemEnv, @Nullable Object item) {
        return false;
    }

    @Synchronized
    public final void build() {
        if (this.isBuilt) {
            return;
        }
        this.isBuilt = true;
        if (this.items.size() <= this.nodeCapacity) {
            return;
        }
        this.sortItems();
        this.layerStartIndex = HPRtree.Companion.computeLayerIndices(this.items.size(), this.nodeCapacity);
        Intrinsics.checkNotNull((Object)this.layerStartIndex);
        Intrinsics.checkNotNull((Object)this.layerStartIndex);
        int nodeCount = this.layerStartIndex[this.layerStartIndex.length - 1] / 4;
        this.nodeBounds = HPRtree.Companion.createBoundsArray(nodeCount);
        Intrinsics.checkNotNull((Object)this.layerStartIndex);
        this.computeLeafNodes(this.layerStartIndex[1]);
        Intrinsics.checkNotNull((Object)this.layerStartIndex);
        int n = this.layerStartIndex.length - 1;
        for (int i = 1; i < n; ++i) {
            this.computeLayerNodes(i);
        }
    }

    private final void computeLayerNodes(int layerIndex) {
        Intrinsics.checkNotNull((Object)this.layerStartIndex);
        int layerStart = this.layerStartIndex[layerIndex];
        Intrinsics.checkNotNull((Object)this.layerStartIndex);
        int childLayerStart = this.layerStartIndex[layerIndex - 1];
        int layerSize = this.layerSize(layerIndex);
        for (int i = 0; i < layerSize; i += 4) {
            int childStart = childLayerStart + this.nodeCapacity * i;
            this.computeNodeBounds(layerStart + i, childStart, layerStart);
        }
    }

    private final void computeNodeBounds(int nodeIndex, int blockStart, int nodeMaxIndex) {
        int i = 0;
        int n = this.nodeCapacity;
        if (i <= n) {
            int index;
            while ((index = blockStart + 4 * i) < nodeMaxIndex) {
                Intrinsics.checkNotNull((Object)this.nodeBounds);
                double d = this.nodeBounds[index];
                Intrinsics.checkNotNull((Object)this.nodeBounds);
                double d2 = this.nodeBounds[index + 1];
                Intrinsics.checkNotNull((Object)this.nodeBounds);
                double d3 = this.nodeBounds[index + 2];
                Intrinsics.checkNotNull((Object)this.nodeBounds);
                this.updateNodeBounds(nodeIndex, d, d2, d3, this.nodeBounds[index + 3]);
                if (i == n) break;
                ++i;
            }
        }
    }

    private final void computeLeafNodes(int layerSize) {
        for (int i = 0; i < layerSize; i += 4) {
            this.computeLeafNodeBounds(i, this.nodeCapacity * i / 4);
        }
    }

    private final void computeLeafNodeBounds(int nodeIndex, int blockStart) {
        int i = 0;
        int n = this.nodeCapacity;
        if (i <= n) {
            int itemIndex;
            while ((itemIndex = blockStart + i) < this.items.size()) {
                Envelope env = this.items.get(itemIndex).getEnvelope();
                this.updateNodeBounds(nodeIndex, env.getMinX(), env.getMinY(), env.getMaxX(), env.getMaxY());
                if (i == n) break;
                ++i;
            }
        }
    }

    private final void updateNodeBounds(int nodeIndex, double minX, double minY, double maxX, double maxY) {
        Intrinsics.checkNotNull((Object)this.nodeBounds);
        if (minX < this.nodeBounds[nodeIndex]) {
            Intrinsics.checkNotNull((Object)this.nodeBounds);
            this.nodeBounds[nodeIndex] = minX;
        }
        Intrinsics.checkNotNull((Object)this.nodeBounds);
        if (minY < this.nodeBounds[nodeIndex + 1]) {
            Intrinsics.checkNotNull((Object)this.nodeBounds);
            this.nodeBounds[nodeIndex + 1] = minY;
        }
        Intrinsics.checkNotNull((Object)this.nodeBounds);
        if (maxX > this.nodeBounds[nodeIndex + 2]) {
            Intrinsics.checkNotNull((Object)this.nodeBounds);
            this.nodeBounds[nodeIndex + 2] = maxX;
        }
        Intrinsics.checkNotNull((Object)this.nodeBounds);
        if (maxY > this.nodeBounds[nodeIndex + 3]) {
            Intrinsics.checkNotNull((Object)this.nodeBounds);
            this.nodeBounds[nodeIndex + 3] = maxY;
        }
    }

    private final Envelope getNodeEnvelope(int i) {
        Intrinsics.checkNotNull((Object)this.nodeBounds);
        double d = this.nodeBounds[i];
        Intrinsics.checkNotNull((Object)this.nodeBounds);
        double d2 = this.nodeBounds[i + 1];
        Intrinsics.checkNotNull((Object)this.nodeBounds);
        double d3 = this.nodeBounds[i + 2];
        Intrinsics.checkNotNull((Object)this.nodeBounds);
        return new Envelope(d, d2, d3, this.nodeBounds[i + 3]);
    }

    @NotNull
    public final Envelope[] getBounds() {
        Intrinsics.checkNotNull((Object)this.nodeBounds);
        int numNodes = this.nodeBounds.length / 4;
        Envelope[] bounds = new Envelope[numNodes];
        for (int i = numNodes - 1; -1 < i; --i) {
            int boundIndex = 4 * i;
            Intrinsics.checkNotNull((Object)this.nodeBounds);
            double d = this.nodeBounds[boundIndex];
            Intrinsics.checkNotNull((Object)this.nodeBounds);
            double d2 = this.nodeBounds[boundIndex + 2];
            Intrinsics.checkNotNull((Object)this.nodeBounds);
            double d3 = this.nodeBounds[boundIndex + 1];
            Intrinsics.checkNotNull((Object)this.nodeBounds);
            bounds[i] = new Envelope(d, d2, d3, this.nodeBounds[boundIndex + 3]);
        }
        return bounds;
    }

    private final void sortItems() {
        ItemComparator comp = new ItemComparator(new HilbertEncoder(12, this.totalExtent));
        CollectionsKt.sortWith(this.items, (Comparator)comp);
    }

    @JvmOverloads
    public HPRtree() {
        this(0, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u0016\u0010\u0016\u001a\u00020\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/locationtech/jts/index/hprtree/HPRtree$Companion;", "", "<init>", "()V", "ENV_SIZE", "", "HILBERT_LEVEL", "DEFAULT_NODE_CAPACITY", "intersects", "", "env1", "Lorg/locationtech/jts/geom/Envelope;", "env2", "createBoundsArray", "", "size", "computeLayerIndices", "", "itemSize", "nodeCapacity", "numNodesToCover", "nChild", "toIntArray", "list", "", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean intersects(Envelope env1, Envelope env2) {
            return env2.getMinX() > env1.getMaxX() || env2.getMaxX() < env1.getMinX() || env2.getMinY() > env1.getMaxY() || env2.getMaxY() >= env1.getMinY();
        }

        private final double[] createBoundsArray(int size) {
            double[] a = new double[4 * size];
            for (int i = 0; i < size; ++i) {
                int index = 4 * i;
                a[index] = Double.MAX_VALUE;
                a[index + 1] = Double.MAX_VALUE;
                a[index + 2] = -1.7976931348623157E308;
                a[index + 3] = -1.7976931348623157E308;
            }
            return a;
        }

        private final int[] computeLayerIndices(int itemSize, int nodeCapacity) {
            List layerIndexList = new ArrayList();
            int layerSize = itemSize;
            int index = 0;
            do {
                layerIndexList.add(index);
                layerSize = this.numNodesToCover(layerSize, nodeCapacity);
                index += 4 * layerSize;
            } while (layerSize > 1);
            return this.toIntArray(layerIndexList);
        }

        private final int numNodesToCover(int nChild, int nodeCapacity) {
            int mult = nChild / nodeCapacity;
            int total = mult * nodeCapacity;
            return total == nChild ? mult : mult + 1;
        }

        private final int[] toIntArray(List<Integer> list) {
            int[] array = new int[list.size()];
            int n = array.length;
            for (int i = 0; i < n; ++i) {
                array[i] = ((Number)list.get(i)).intValue();
            }
            return array;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/locationtech/jts/index/hprtree/HPRtree$ItemComparator;", "Ljava/util/Comparator;", "Lorg/locationtech/jts/index/hprtree/Item;", "Lkotlin/Comparator;", "encoder", "Lorg/locationtech/jts/index/hprtree/HilbertEncoder;", "<init>", "(Lorg/locationtech/jts/index/hprtree/HilbertEncoder;)V", "compare", "", "item1", "item2", "kts-core"})
    public static final class ItemComparator
    implements Comparator<Item> {
        @NotNull
        private final HilbertEncoder encoder;

        public ItemComparator(@NotNull HilbertEncoder encoder) {
            Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
            this.encoder = encoder;
        }

        @Override
        public int compare(@NotNull Item item1, @NotNull Item item2) {
            Intrinsics.checkNotNullParameter((Object)item1, (String)"item1");
            Intrinsics.checkNotNullParameter((Object)item2, (String)"item2");
            int hcode1 = this.encoder.encode(item1.getEnvelope());
            int hcode2 = this.encoder.encode(item2.getEnvelope());
            return Intrinsics.compare((int)hcode1, (int)hcode2);
        }
    }
}

