/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.hprtree;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.shape.fractal.HilbertCode;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/locationtech/jts/index/hprtree/HilbertEncoder;", "", "level", "", "extent", "Lorg/locationtech/jts/geom/Envelope;", "<init>", "(ILorg/locationtech/jts/geom/Envelope;)V", "minx", "", "miny", "strideX", "strideY", "encode", "env", "kts-core"})
public final class HilbertEncoder {
    private final int level;
    private final double minx;
    private final double miny;
    private final double strideX;
    private final double strideY;

    public HilbertEncoder(int level, @NotNull Envelope extent) {
        Intrinsics.checkNotNullParameter((Object)extent, (String)"extent");
        this.level = level;
        int hside = (int)Math.INSTANCE.pow(2.0, this.level) - 1;
        this.minx = extent.getMinX();
        double extentX = extent.getWidth();
        this.strideX = extentX / (double)hside;
        this.miny = extent.getMinX();
        double extentY = extent.getHeight();
        this.strideY = extentY / (double)hside;
    }

    public final int encode(@NotNull Envelope env) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        double midx = env.getWidth() / (double)2 + env.getMinX();
        int x = (int)((midx - this.minx) / this.strideX);
        double midy = env.getHeight() / (double)2 + env.getMinY();
        int y = (int)((midy - this.miny) / this.strideY);
        return HilbertCode.encode(this.level, x, y);
    }
}

