/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.intervalrtree;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.index.ItemVisitor;
import org.locationtech.jts.index.intervalrtree.IntervalRTreeNode;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00012\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u0002J \u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/locationtech/jts/index/intervalrtree/IntervalRTreeBranchNode;", "Lorg/locationtech/jts/index/intervalrtree/IntervalRTreeNode;", "node1", "node2", "<init>", "(Lorg/locationtech/jts/index/intervalrtree/IntervalRTreeNode;Lorg/locationtech/jts/index/intervalrtree/IntervalRTreeNode;)V", "buildExtent", "", "n1", "n2", "query", "queryMin", "", "queryMax", "visitor", "Lorg/locationtech/jts/index/ItemVisitor;", "kts-core"})
public final class IntervalRTreeBranchNode
extends IntervalRTreeNode {
    @Nullable
    private final IntervalRTreeNode node1;
    @Nullable
    private final IntervalRTreeNode node2;

    public IntervalRTreeBranchNode(@Nullable IntervalRTreeNode node1, @Nullable IntervalRTreeNode node2) {
        this.node1 = node1;
        this.node2 = node2;
        this.buildExtent(this.node1, this.node2);
    }

    private final void buildExtent(IntervalRTreeNode n1, IntervalRTreeNode n2) {
        IntervalRTreeNode intervalRTreeNode = n1;
        Intrinsics.checkNotNull((Object)intervalRTreeNode);
        double d = intervalRTreeNode.getMin();
        IntervalRTreeNode intervalRTreeNode2 = n2;
        Intrinsics.checkNotNull((Object)intervalRTreeNode2);
        this.setMin(Math.INSTANCE.min(d, intervalRTreeNode2.getMin()));
        this.setMax(Math.INSTANCE.max(n1.getMax(), n2.getMax()));
    }

    @Override
    public void query(double queryMin, double queryMax, @NotNull ItemVisitor visitor) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
            if (!this.intersects(queryMin, queryMax)) {
                return;
            }
            IntervalRTreeNode intervalRTreeNode = this.node1;
            if (intervalRTreeNode != null) {
                intervalRTreeNode.query(queryMin, queryMax, visitor);
            }
            IntervalRTreeNode intervalRTreeNode2 = this.node2;
            if (intervalRTreeNode2 == null) break block2;
            intervalRTreeNode2.query(queryMin, queryMax, visitor);
        }
    }
}

