/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.intervalrtree;

import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.index.ItemVisitor;
import org.locationtech.jts.io.WKTWriter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H&J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0004J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\u00a8\u0006\u0018"}, d2={"Lorg/locationtech/jts/index/intervalrtree/IntervalRTreeNode;", "", "<init>", "()V", "min", "", "getMin", "()D", "setMin", "(D)V", "max", "getMax", "setMax", "query", "", "queryMin", "queryMax", "visitor", "Lorg/locationtech/jts/index/ItemVisitor;", "intersects", "", "toString", "", "NodeComparator", "kts-core"})
public abstract class IntervalRTreeNode {
    private double min = Double.POSITIVE_INFINITY;
    private double max = Double.NEGATIVE_INFINITY;

    public final double getMin() {
        return this.min;
    }

    public final void setMin(double d) {
        this.min = d;
    }

    public final double getMax() {
        return this.max;
    }

    public final void setMax(double d) {
        this.max = d;
    }

    public abstract void query(double var1, double var3, @NotNull ItemVisitor var5);

    protected final boolean intersects(double queryMin, double queryMax) {
        return !(this.min > queryMax) && !(this.max < queryMin);
    }

    @NotNull
    public String toString() {
        return WKTWriter.Companion.toLineString(new Coordinate(this.min, 0.0), new Coordinate(this.max, 0.0));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00022\b\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\n"}, d2={"Lorg/locationtech/jts/index/intervalrtree/IntervalRTreeNode$NodeComparator;", "Ljava/util/Comparator;", "", "Lkotlin/Comparator;", "<init>", "()V", "compare", "", "o1", "o2", "kts-core"})
    public static final class NodeComparator
    implements Comparator<Object> {
        @Override
        public int compare(@Nullable Object o1, @Nullable Object o2) {
            IntervalRTreeNode n1 = (IntervalRTreeNode)o1;
            IntervalRTreeNode n2 = (IntervalRTreeNode)o2;
            IntervalRTreeNode intervalRTreeNode = n1;
            Intrinsics.checkNotNull((Object)intervalRTreeNode);
            double mid1 = (intervalRTreeNode.getMin() + n1.getMax()) / (double)2;
            IntervalRTreeNode intervalRTreeNode2 = n2;
            Intrinsics.checkNotNull((Object)intervalRTreeNode2);
            double mid2 = (intervalRTreeNode2.getMin() + n2.getMax()) / (double)2;
            if (mid1 < mid2) {
                return -1;
            }
            return mid1 > mid2 ? 1 : 0;
        }
    }
}

