/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.intervalrtree;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.index.ItemVisitor;
import org.locationtech.jts.index.intervalrtree.IntervalRTreeBranchNode;
import org.locationtech.jts.index.intervalrtree.IntervalRTreeLeafNode;
import org.locationtech.jts.index.intervalrtree.IntervalRTreeNode;
import org.locationtech.jts.legacy.Synchronized;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u0001J\b\u0010\u000e\u001a\u00020\tH\u0003J\b\u0010\u000f\u001a\u00020\tH\u0002J\b\u0010\u0010\u001a\u00020\u0007H\u0002J$\u0010\u0011\u001a\u00020\t2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00052\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0005H\u0002J \u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/locationtech/jts/index/intervalrtree/SortedPackedIntervalRTree;", "", "<init>", "()V", "leaves", "", "root", "Lorg/locationtech/jts/index/intervalrtree/IntervalRTreeNode;", "insert", "", "min", "", "max", "item", "init", "buildRoot", "buildTree", "buildLevel", "src", "dest", "query", "visitor", "Lorg/locationtech/jts/index/ItemVisitor;", "kts-core"})
public final class SortedPackedIntervalRTree {
    @NotNull
    private final List<Object> leaves = new ArrayList();
    @Nullable
    private IntervalRTreeNode root;

    public final void insert(double min, double max, @Nullable Object item) {
        if (this.root != null) {
            throw new IllegalStateException("Index cannot be added to once it has been queried");
        }
        Object object = item;
        Intrinsics.checkNotNull((Object)object);
        this.leaves.add(new IntervalRTreeLeafNode(min, max, object));
    }

    @Synchronized
    private final void init() {
        if (this.root != null) {
            return;
        }
        if (this.leaves.size() == 0) {
            return;
        }
        this.buildRoot();
    }

    private final void buildRoot() {
        if (this.root != null) {
            return;
        }
        this.root = this.buildTree();
    }

    private final IntervalRTreeNode buildTree() {
        CollectionsKt.sortWith(this.leaves, (Comparator)new IntervalRTreeNode.NodeComparator());
        List src = this.leaves;
        List temp = null;
        List dest = new ArrayList();
        while (true) {
            this.buildLevel(src, dest);
            if (dest.size() == 1) {
                Object e = dest.get(0);
                Intrinsics.checkNotNull(e);
                return (IntervalRTreeNode)e;
            }
            temp = src;
            src = dest;
            dest = temp;
        }
    }

    private final void buildLevel(List<?> src, List<Object> dest) {
        dest.clear();
        for (int i = 0; i < src.size(); i += 2) {
            boolean bl;
            Object n2;
            Object obj = src.get(i);
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.index.intervalrtree.IntervalRTreeNode");
            IntervalRTreeNode n1 = (IntervalRTreeNode)obj;
            Object v1 = n2 = i + 1 < src.size() ? src.get(i) : null;
            if (n2 == null) {
                bl = dest.add(n1);
                continue;
            }
            Object obj2 = src.get(i);
            Intrinsics.checkNotNull(obj2, (String)"null cannot be cast to non-null type org.locationtech.jts.index.intervalrtree.IntervalRTreeNode");
            IntervalRTreeNode intervalRTreeNode = (IntervalRTreeNode)obj2;
            Object obj3 = src.get(i + 1);
            Intrinsics.checkNotNull(obj3, (String)"null cannot be cast to non-null type org.locationtech.jts.index.intervalrtree.IntervalRTreeNode");
            IntervalRTreeNode node = new IntervalRTreeBranchNode(intervalRTreeNode, (IntervalRTreeNode)obj3);
            bl = dest.add(node);
        }
    }

    public final void query(double min, double max, @Nullable ItemVisitor visitor) {
        this.init();
        if (this.root == null) {
            return;
        }
        IntervalRTreeNode intervalRTreeNode = this.root;
        Intrinsics.checkNotNull((Object)intervalRTreeNode);
        ItemVisitor itemVisitor = visitor;
        Intrinsics.checkNotNull((Object)itemVisitor);
        intervalRTreeNode.query(min, max, itemVisitor);
    }
}

