/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.kdtree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.kdtree.KdNode;
import org.locationtech.jts.index.kdtree.KdNodeVisitor;
import org.locationtech.jts.legacy.StackKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\u0018\u0000 %2\u00020\u0001:\u0003#$%B\u0013\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u0004\u0018\u00010\u0007J\u001c\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0007J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001a\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0002J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u001a2\u0006\u0010\u0016\u001a\u00020\u0017J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u000e\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u001aJ\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001c\u001a\u00020\u0010J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0012\u0010\u001f\u001a\u00020\u001e2\b\u0010 \u001a\u0004\u0018\u00010\u0007H\u0002J\u0006\u0010!\u001a\u00020\u001eJ\u0012\u0010\"\u001a\u00020\u001e2\b\u0010 \u001a\u0004\u0018\u00010\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\r\u00a8\u0006&"}, d2={"Lorg/locationtech/jts/index/kdtree/KdTree;", "", "tolerance", "", "<init>", "(D)V", "root", "Lorg/locationtech/jts/index/kdtree/KdNode;", "numberOfNodes", "", "getRoot", "isEmpty", "", "()Z", "insert", "p", "Lorg/locationtech/jts/geom/Coordinate;", "data", "findBestMatchNode", "insertExact", "query", "", "queryEnv", "Lorg/locationtech/jts/geom/Envelope;", "visitor", "Lorg/locationtech/jts/index/kdtree/KdNodeVisitor;", "", "result", "queryPt", "depth", "", "depthNode", "currentNode", "size", "sizeNode", "BestMatchVisitor", "QueryStackFrame", "Companion", "kts-core"})
@SourceDebugExtension(value={"SMAP\nKdTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KdTree.kt\norg/locationtech/jts/index/kdtree/KdTree\n+ 2 Stack.kt\norg/locationtech/jts/legacy/StackKt\n*L\n1#1,398:1\n21#2:399\n*S KotlinDebug\n*F\n+ 1 KdTree.kt\norg/locationtech/jts/index/kdtree/KdTree\n*L\n238#1:399\n*E\n"})
public final class KdTree {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double tolerance;
    @Nullable
    private KdNode root;
    private long numberOfNodes;

    @JvmOverloads
    public KdTree(double tolerance) {
        this.tolerance = tolerance;
    }

    public /* synthetic */ KdTree(double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 0.0;
        }
        this(d);
    }

    @Nullable
    public final KdNode getRoot() {
        return this.root;
    }

    public final boolean isEmpty() {
        return this.root == null;
    }

    @JvmOverloads
    @NotNull
    public final KdNode insert(@NotNull Coordinate p, @Nullable Object data) {
        KdNode matchNode;
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        if (this.root == null) {
            KdNode kdNode = this.root = new KdNode(p, data);
            Intrinsics.checkNotNull((Object)kdNode);
            return kdNode;
        }
        if (this.tolerance > 0.0 && (matchNode = this.findBestMatchNode(p)) != null) {
            matchNode.increment();
            return matchNode;
        }
        return this.insertExact(p, data);
    }

    public static /* synthetic */ KdNode insert$default(KdTree kdTree, Coordinate coordinate, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        return kdTree.insert(coordinate, object);
    }

    private final KdNode findBestMatchNode(Coordinate p) {
        BestMatchVisitor visitor = new BestMatchVisitor(p, this.tolerance);
        this.query(visitor.queryEnvelope(), visitor);
        return visitor.getNode();
    }

    private final KdNode insertExact(Coordinate p, Object data) {
        KdNode currentNode = this.root;
        KdNode leafNode = this.root;
        boolean isXLevel = true;
        boolean isLessThan = true;
        while (currentNode != null) {
            boolean isInTolerance;
            Coordinate coordinate = currentNode.getCoordinate();
            Intrinsics.checkNotNull((Object)coordinate);
            boolean bl = isInTolerance = p.distance(coordinate) <= this.tolerance;
            if (isInTolerance) {
                currentNode.increment();
                return currentNode;
            }
            double splitValue = currentNode.splitValue(isXLevel);
            isLessThan = isXLevel ? p.x < splitValue : p.y < splitValue;
            leafNode = currentNode;
            currentNode = isLessThan ? currentNode.getLeft() : currentNode.getRight();
            isXLevel = !isXLevel;
        }
        ++this.numberOfNodes;
        KdNode node = new KdNode(p, data);
        if (isLessThan) {
            KdNode kdNode = leafNode;
            Intrinsics.checkNotNull((Object)kdNode);
            kdNode.setLeft(node);
        } else {
            KdNode kdNode = leafNode;
            Intrinsics.checkNotNull((Object)kdNode);
            kdNode.setRight(node);
        }
        return node;
    }

    /*
     * WARNING - void declaration
     */
    public final void query(@NotNull Envelope queryEnv, @NotNull KdNodeVisitor visitor) {
        Intrinsics.checkNotNullParameter((Object)queryEnv, (String)"queryEnv");
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        ArrayDeque queryStack = new ArrayDeque();
        KdNode currentNode = this.root;
        boolean isXLevel = true;
        while (true) {
            boolean searchRight;
            if (currentNode != null) {
                void $this$push$iv;
                List list = (List)queryStack;
                QueryStackFrame item$iv = new QueryStackFrame(currentNode, isXLevel);
                boolean $i$f$push = false;
                $this$push$iv.add(item$iv);
                boolean searchLeft = currentNode.isRangeOverLeft(isXLevel, queryEnv);
                if (searchLeft) {
                    if ((currentNode = currentNode.getLeft()) == null) continue;
                    isXLevel = !isXLevel;
                    continue;
                }
                currentNode = null;
                continue;
            }
            if (queryStack.isEmpty()) break;
            Object t = StackKt.pop((List)queryStack);
            Intrinsics.checkNotNull(t);
            QueryStackFrame frame = (QueryStackFrame)t;
            currentNode = frame.getNode();
            isXLevel = frame.isXLevel();
            Coordinate coordinate = currentNode.getCoordinate();
            Intrinsics.checkNotNull((Object)coordinate);
            if (queryEnv.contains(coordinate)) {
                visitor.visit(currentNode);
            }
            if (searchRight = currentNode.isRangeOverRight(isXLevel, queryEnv)) {
                if ((currentNode = currentNode.getRight()) == null) continue;
                isXLevel = !isXLevel;
                continue;
            }
            currentNode = null;
        }
    }

    @NotNull
    public final List<KdNode> query(@NotNull Envelope queryEnv) {
        Intrinsics.checkNotNullParameter((Object)queryEnv, (String)"queryEnv");
        List result2 = new ArrayList();
        this.query(queryEnv, result2);
        return result2;
    }

    public final void query(@NotNull Envelope queryEnv, @NotNull List<KdNode> result2) {
        Intrinsics.checkNotNullParameter((Object)queryEnv, (String)"queryEnv");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        this.query(queryEnv, new KdNodeVisitor(result2){
            final /* synthetic */ List<KdNode> $result;
            {
                this.$result = $result;
            }

            public void visit(KdNode node) {
                this.$result.add(node);
            }
        });
    }

    @Nullable
    public final KdNode query(@NotNull Coordinate queryPt) {
        Intrinsics.checkNotNullParameter((Object)queryPt, (String)"queryPt");
        KdNode currentNode = this.root;
        boolean isXLevel = true;
        while (currentNode != null) {
            Coordinate coordinate = currentNode.getCoordinate();
            Intrinsics.checkNotNull((Object)coordinate);
            if (coordinate.equals2D(queryPt)) {
                return currentNode;
            }
            boolean searchLeft = currentNode.isPointOnLeft(isXLevel, queryPt);
            currentNode = searchLeft ? currentNode.getLeft() : currentNode.getRight();
            isXLevel = !isXLevel;
        }
        return null;
    }

    public final int depth() {
        return this.depthNode(this.root);
    }

    private final int depthNode(KdNode currentNode) {
        int dR;
        if (currentNode == null) {
            return 0;
        }
        int dL = this.depthNode(currentNode.getLeft());
        return 1 + (dL > (dR = this.depthNode(currentNode.getRight())) ? dL : dR);
    }

    public final int size() {
        return this.sizeNode(this.root);
    }

    private final int sizeNode(KdNode currentNode) {
        if (currentNode == null) {
            return 0;
        }
        int sizeL = this.sizeNode(currentNode.getLeft());
        int sizeR = this.sizeNode(currentNode.getRight());
        return 1 + sizeL + sizeR;
    }

    @JvmOverloads
    public KdTree() {
        this(0.0, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final KdNode insert(@NotNull Coordinate p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return KdTree.insert$default(this, p, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Coordinate[] toCoordinates(@NotNull Collection<?> kdnodes, boolean includeRepeated) {
        return Companion.toCoordinates(kdnodes, includeRepeated);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Coordinate[] toCoordinates(@NotNull Collection<?> kdnodes) {
        return Companion.toCoordinates(kdnodes);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\r\u001a\u0004\u0018\u00010\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lorg/locationtech/jts/index/kdtree/KdTree$BestMatchVisitor;", "Lorg/locationtech/jts/index/kdtree/KdNodeVisitor;", "p", "Lorg/locationtech/jts/geom/Coordinate;", "tolerance", "", "<init>", "(Lorg/locationtech/jts/geom/Coordinate;D)V", "matchNode", "Lorg/locationtech/jts/index/kdtree/KdNode;", "matchDist", "queryEnvelope", "Lorg/locationtech/jts/geom/Envelope;", "node", "getNode", "()Lorg/locationtech/jts/index/kdtree/KdNode;", "visit", "", "kts-core"})
    private static final class BestMatchVisitor
    implements KdNodeVisitor {
        @NotNull
        private final Coordinate p;
        private final double tolerance;
        @Nullable
        private KdNode matchNode;
        private double matchDist;

        public BestMatchVisitor(@NotNull Coordinate p, double tolerance) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            this.p = p;
            this.tolerance = tolerance;
        }

        @NotNull
        public final Envelope queryEnvelope() {
            Envelope queryEnv = new Envelope(this.p);
            queryEnv.expandBy(this.tolerance);
            return queryEnv;
        }

        @Nullable
        public final KdNode getNode() {
            return this.matchNode;
        }

        @Override
        public void visit(@Nullable KdNode node) {
            boolean update;
            double dist;
            block6: {
                block5: {
                    boolean isInTolerance;
                    KdNode kdNode = node;
                    Intrinsics.checkNotNull((Object)kdNode);
                    Coordinate coordinate = kdNode.getCoordinate();
                    Intrinsics.checkNotNull((Object)coordinate);
                    dist = this.p.distance(coordinate);
                    boolean bl = isInTolerance = dist <= this.tolerance;
                    if (!isInTolerance) {
                        return;
                    }
                    update = false;
                    if (this.matchNode == null || dist < this.matchDist) break block5;
                    if (this.matchNode == null || !(dist == this.matchDist)) break block6;
                    Coordinate coordinate2 = node.getCoordinate();
                    Intrinsics.checkNotNull((Object)coordinate2);
                    KdNode kdNode2 = this.matchNode;
                    Intrinsics.checkNotNull((Object)kdNode2);
                    if (coordinate2.compareTo(kdNode2.getCoordinate()) >= 1) break block6;
                }
                update = true;
            }
            if (update) {
                this.matchNode = node;
                this.matchDist = dist;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0007\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/locationtech/jts/index/kdtree/KdTree$Companion;", "", "<init>", "()V", "toCoordinates", "", "Lorg/locationtech/jts/geom/Coordinate;", "kdnodes", "", "includeRepeated", "", "(Ljava/util/Collection;Z)[Lorg/locationtech/jts/geom/Coordinate;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Coordinate[] toCoordinates(@NotNull Collection<?> kdnodes, boolean includeRepeated) {
            Intrinsics.checkNotNullParameter(kdnodes, (String)"kdnodes");
            CoordinateList coord = new CoordinateList();
            for (Object obj : kdnodes) {
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.index.kdtree.KdNode");
                KdNode node = (KdNode)obj;
                int count = includeRepeated ? node.getCount() : 1;
                for (int i = 0; i < count; ++i) {
                    coord.add((Object)node.getCoordinate(), true);
                }
            }
            return coord.toCoordinateArray();
        }

        public static /* synthetic */ Coordinate[] toCoordinates$default(Companion companion, Collection collection, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.toCoordinates(collection, bl);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Coordinate[] toCoordinates(@NotNull Collection<?> kdnodes) {
            Intrinsics.checkNotNullParameter(kdnodes, (String)"kdnodes");
            return org.locationtech.jts.index.kdtree.KdTree$Companion.toCoordinates$default(this, kdnodes, false, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\t\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\b\u00a8\u0006\n"}, d2={"Lorg/locationtech/jts/index/kdtree/KdTree$QueryStackFrame;", "", "node", "Lorg/locationtech/jts/index/kdtree/KdNode;", "isXLevel", "", "<init>", "(Lorg/locationtech/jts/index/kdtree/KdNode;Z)V", "()Z", "getNode", "kts-core"})
    private static final class QueryStackFrame {
        @NotNull
        private final KdNode node;
        private final boolean isXLevel;

        public QueryStackFrame(@NotNull KdNode node, boolean isXLevel) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.node = node;
            this.isXLevel = isXLevel;
        }

        public /* synthetic */ QueryStackFrame(KdNode kdNode, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            this(kdNode, bl);
        }

        public final boolean isXLevel() {
            return this.isXLevel;
        }

        @NotNull
        public final KdNode getNode() {
            return this.node;
        }
    }
}

