/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.strtree;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0007J(\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0007JH\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/locationtech/jts/index/strtree/EnvelopeDistance;", "", "<init>", "()V", "maximumDistance", "", "env1", "Lorg/locationtech/jts/geom/Envelope;", "env2", "distance", "x1", "y1", "x2", "y2", "minMaxDistance", "a", "b", "maxDistance", "ax1", "ay1", "ax2", "ay2", "bx1", "by1", "bx2", "by2", "kts-core"})
public final class EnvelopeDistance {
    @NotNull
    public static final EnvelopeDistance INSTANCE = new EnvelopeDistance();

    private EnvelopeDistance() {
    }

    @JvmStatic
    public static final double maximumDistance(@NotNull Envelope env1, @NotNull Envelope env2) {
        Intrinsics.checkNotNullParameter((Object)env1, (String)"env1");
        Intrinsics.checkNotNullParameter((Object)env2, (String)"env2");
        double minx = Math.INSTANCE.min(env1.getMinX(), env2.getMinX());
        double miny = Math.INSTANCE.min(env1.getMinY(), env2.getMinY());
        double maxx = Math.INSTANCE.max(env1.getMaxX(), env2.getMaxX());
        double maxy = Math.INSTANCE.max(env1.getMaxY(), env2.getMaxY());
        return INSTANCE.distance(minx, miny, maxx, maxy);
    }

    private final double distance(double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        return Math.INSTANCE.sqrt(dx * dx + dy * dy);
    }

    @JvmStatic
    public static final double minMaxDistance(@NotNull Envelope a, @NotNull Envelope b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        double aminx = a.getMinX();
        double aminy = a.getMinY();
        double amaxx = a.getMaxX();
        double amaxy = a.getMaxY();
        double bminx = b.getMinX();
        double bminy = b.getMinY();
        double bmaxx = b.getMaxX();
        double bmaxy = b.getMaxY();
        double dist = INSTANCE.maxDistance(aminx, aminy, aminx, amaxy, bminx, bminy, bminx, bmaxy);
        dist = Math.INSTANCE.min(dist, INSTANCE.maxDistance(aminx, aminy, aminx, amaxy, bminx, bminy, bmaxx, bminy));
        dist = Math.INSTANCE.min(dist, INSTANCE.maxDistance(aminx, aminy, aminx, amaxy, bmaxx, bmaxy, bminx, bmaxy));
        dist = Math.INSTANCE.min(dist, INSTANCE.maxDistance(aminx, aminy, aminx, amaxy, bmaxx, bmaxy, bmaxx, bminy));
        dist = Math.INSTANCE.min(dist, INSTANCE.maxDistance(aminx, aminy, amaxx, aminy, bminx, bminy, bminx, bmaxy));
        dist = Math.INSTANCE.min(dist, INSTANCE.maxDistance(aminx, aminy, amaxx, aminy, bminx, bminy, bmaxx, bminy));
        dist = Math.INSTANCE.min(dist, INSTANCE.maxDistance(aminx, aminy, amaxx, aminy, bmaxx, bmaxy, bminx, bmaxy));
        dist = Math.INSTANCE.min(dist, INSTANCE.maxDistance(aminx, aminy, amaxx, aminy, bmaxx, bmaxy, bmaxx, bminy));
        dist = Math.INSTANCE.min(dist, INSTANCE.maxDistance(amaxx, amaxy, aminx, amaxy, bminx, bminy, bminx, bmaxy));
        dist = Math.INSTANCE.min(dist, INSTANCE.maxDistance(amaxx, amaxy, aminx, amaxy, bminx, bminy, bmaxx, bminy));
        dist = Math.INSTANCE.min(dist, INSTANCE.maxDistance(amaxx, amaxy, aminx, amaxy, bmaxx, bmaxy, bminx, bmaxy));
        dist = Math.INSTANCE.min(dist, INSTANCE.maxDistance(amaxx, amaxy, aminx, amaxy, bmaxx, bmaxy, bmaxx, bminy));
        dist = Math.INSTANCE.min(dist, INSTANCE.maxDistance(amaxx, amaxy, amaxx, aminy, bminx, bminy, bminx, bmaxy));
        dist = Math.INSTANCE.min(dist, INSTANCE.maxDistance(amaxx, amaxy, amaxx, aminy, bminx, bminy, bmaxx, bminy));
        dist = Math.INSTANCE.min(dist, INSTANCE.maxDistance(amaxx, amaxy, amaxx, aminy, bmaxx, bmaxy, bminx, bmaxy));
        dist = Math.INSTANCE.min(dist, INSTANCE.maxDistance(amaxx, amaxy, amaxx, aminy, bmaxx, bmaxy, bmaxx, bminy));
        return dist;
    }

    private final double maxDistance(double ax1, double ay1, double ax2, double ay2, double bx1, double by1, double bx2, double by2) {
        double dist = this.distance(ax1, ay1, bx1, by1);
        dist = Math.INSTANCE.max(dist, this.distance(ax1, ay1, bx2, by2));
        dist = Math.INSTANCE.max(dist, this.distance(ax2, ay2, bx1, by1));
        dist = Math.INSTANCE.max(dist, this.distance(ax2, ay2, bx2, by2));
        return dist;
    }
}

