/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.strtree;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.index.strtree.AbstractNode;
import org.locationtech.jts.index.strtree.AbstractSTRtree;
import org.locationtech.jts.index.strtree.Boundable;
import org.locationtech.jts.index.strtree.Interval;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0014J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\bJ\u0016\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u001a2\u0006\u0010\u001b\u001a\u00020\u0016J\u001e\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016R(\u0010\u0006\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007j\n\u0012\u0006\u0012\u0004\u0018\u00010\b`\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lorg/locationtech/jts/index/strtree/SIRtree;", "Lorg/locationtech/jts/index/strtree/AbstractSTRtree;", "nodeCapacity", "", "<init>", "(I)V", "comparator", "Ljava/util/Comparator;", "", "Lkotlin/Comparator;", "getComparator", "()Ljava/util/Comparator;", "intersectsOp", "Lorg/locationtech/jts/index/strtree/AbstractSTRtree$IntersectsOp;", "getIntersectsOp", "()Lorg/locationtech/jts/index/strtree/AbstractSTRtree$IntersectsOp;", "createNode", "Lorg/locationtech/jts/index/strtree/AbstractNode;", "level", "insert", "", "x1", "", "x2", "item", "query", "", "x", "kts-core"})
public final class SIRtree
extends AbstractSTRtree {
    @NotNull
    private final Comparator<Object> comparator;
    @NotNull
    private final AbstractSTRtree.IntersectsOp intersectsOp;

    @JvmOverloads
    public SIRtree(int nodeCapacity) {
        super(nodeCapacity);
        this.comparator = SIRtree::comparator$lambda$0;
        this.intersectsOp = new AbstractSTRtree.IntersectsOp(){

            public boolean intersects(Object aBounds, Object bBounds) {
                Interval interval = (Interval)aBounds;
                Intrinsics.checkNotNull((Object)interval);
                Interval interval2 = (Interval)bBounds;
                Intrinsics.checkNotNull((Object)interval2);
                return interval.intersects(interval2);
            }
        };
    }

    public /* synthetic */ SIRtree(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        this(n);
    }

    @Override
    @NotNull
    protected Comparator<Object> getComparator() {
        return this.comparator;
    }

    @Override
    @NotNull
    protected AbstractSTRtree.IntersectsOp getIntersectsOp() {
        return this.intersectsOp;
    }

    @Override
    @NotNull
    protected AbstractNode createNode(int level) {
        return new AbstractNode(level){

            protected Object computeBounds() {
                Interval bounds = null;
                Iterator<Boundable> i = this.getChildBoundables().iterator();
                while (i.hasNext()) {
                    Boundable childBoundable;
                    Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.index.strtree.Boundable");
                    if (bounds == null) {
                        Interval interval = (Interval)childBoundable.getBounds();
                        Intrinsics.checkNotNull((Object)interval);
                        bounds = new Interval(interval);
                        continue;
                    }
                    Interval interval = (Interval)childBoundable.getBounds();
                    Intrinsics.checkNotNull((Object)interval);
                    bounds.expandToInclude(interval);
                }
                return bounds;
            }
        };
    }

    public final void insert(double x1, double x2, @Nullable Object item) {
        Interval interval = new Interval(Math.INSTANCE.min(x1, x2), Math.INSTANCE.max(x1, x2));
        Object object = item;
        Intrinsics.checkNotNull((Object)object);
        super.insert(interval, object);
    }

    @NotNull
    public final List<Object> query(double x) {
        return this.query(x, x);
    }

    @NotNull
    public final List<Object> query(double x1, double x2) {
        return super.query(new Interval(Math.INSTANCE.min(x1, x2), Math.INSTANCE.max(x1, x2)));
    }

    @JvmOverloads
    public SIRtree() {
        this(0, 1, null);
    }

    private static final int comparator$lambda$0(Object o1, Object o2) {
        Intrinsics.checkNotNull((Object)o1, (String)"null cannot be cast to non-null type org.locationtech.jts.index.strtree.Boundable");
        Interval interval = (Interval)((Boundable)o1).getBounds();
        Intrinsics.checkNotNull((Object)interval);
        double d = interval.getCentre();
        Intrinsics.checkNotNull((Object)o2, (String)"null cannot be cast to non-null type org.locationtech.jts.index.strtree.Boundable");
        Interval interval2 = (Interval)((Boundable)o2).getBounds();
        Intrinsics.checkNotNull((Object)interval2);
        return AbstractSTRtree.compareDoubles(d, interval2.getCentre());
    }
}

