/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.strtree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.ItemVisitor;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.strtree.AbstractNode;
import org.locationtech.jts.index.strtree.AbstractSTRtree;
import org.locationtech.jts.index.strtree.Boundable;
import org.locationtech.jts.index.strtree.BoundablePair;
import org.locationtech.jts.index.strtree.ItemBoundable;
import org.locationtech.jts.index.strtree.ItemDistance;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.legacy.queue.PriorityQueue;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\b\b\u0016\u0018\u0000 I2\u00020\u00012\u00020\u00022\u00060\u0003j\u0002`\u0004:\u0002HIB\t\b\u0017\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tB\u001b\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0005\u0010\fB!\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e\u00a2\u0006\u0004\b\u0005\u0010\u0010J(\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00122\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00122\u0006\u0010\u0015\u001a\u00020\bH\u0014J1\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00122\u0016\u0010\u0017\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0018\u00010\u000e0\u00182\u0006\u0010\u0015\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u0019J(\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00122\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00122\u0006\u0010\u0015\u001a\u00020\bH\u0014J1\u0010\u0017\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0018\u00010\u000e0\u00182\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u001b\u001a\u00020\bH\u0014\u00a2\u0006\u0002\u0010\u001cJ\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\bH\u0014J\u001c\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010\u0013H\u0016J\u0018\u0010)\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e2\b\u0010*\u001a\u0004\u0018\u00010'H\u0016J\u001c\u0010)\u001a\u00020%2\b\u0010*\u001a\u0004\u0018\u00010'2\b\u0010+\u001a\u0004\u0018\u00010,H\u0016J\u001c\u0010-\u001a\u00020.2\b\u0010&\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010/\u001a\u00020\bH\u0016J\b\u00100\u001a\u00020\bH\u0016J\u001d\u00106\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00182\b\u00107\u001a\u0004\u0018\u000108\u00a2\u0006\u0002\u00109J&\u00106\u001a\u0004\u0018\u00010\u00132\b\u0010:\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010\u00132\b\u00107\u001a\u0004\u0018\u000108J%\u00106\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00182\u0006\u0010;\u001a\u00020\u00002\b\u00107\u001a\u0004\u0018\u000108\u00a2\u0006\u0002\u0010<J\u001d\u00106\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00182\u0006\u0010=\u001a\u00020>H\u0002\u00a2\u0006\u0002\u0010?J \u0010@\u001a\u00020.2\u0006\u0010;\u001a\u00020\u00002\b\u00107\u001a\u0004\u0018\u0001082\u0006\u0010A\u001a\u00020BJ\u0018\u0010@\u001a\u00020.2\u0006\u0010=\u001a\u00020>2\u0006\u0010A\u001a\u00020BH\u0002J9\u00106\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00182\b\u0010:\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010\u00132\b\u00107\u001a\u0004\u0018\u0001082\u0006\u0010C\u001a\u00020\b\u00a2\u0006\u0002\u0010DJ%\u0010E\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00182\u0006\u0010=\u001a\u00020>2\u0006\u0010C\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010FJ-\u0010E\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00182\u0006\u0010=\u001a\u00020>2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010GR\u0014\u0010 \u001a\u00020!8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R(\u00101\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u001302j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0013`38TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105\u00a8\u0006J"}, d2={"Lorg/locationtech/jts/index/strtree/STRtree;", "Lorg/locationtech/jts/index/strtree/AbstractSTRtree;", "Lorg/locationtech/jts/index/SpatialIndex;", "Ljava/io/Serializable;", "Lorg/locationtech/jts/legacy/Serializable;", "<init>", "()V", "nodeCapacity", "", "(I)V", "root", "Lorg/locationtech/jts/index/strtree/STRtree$STRtreeNode;", "(ILorg/locationtech/jts/index/strtree/STRtree$STRtreeNode;)V", "itemBoundables", "", "Lorg/locationtech/jts/index/strtree/ItemBoundable;", "(ILjava/util/List;)V", "createParentBoundables", "", "", "childBoundables", "newLevel", "createParentBoundablesFromVerticalSlices", "verticalSlices", "", "([Ljava/util/List;I)Ljava/util/List;", "createParentBoundablesFromVerticalSlice", "sliceCount", "(Ljava/util/List;I)[Ljava/util/List;", "createNode", "Lorg/locationtech/jts/index/strtree/AbstractNode;", "level", "intersectsOp", "Lorg/locationtech/jts/index/strtree/AbstractSTRtree$IntersectsOp;", "getIntersectsOp", "()Lorg/locationtech/jts/index/strtree/AbstractSTRtree$IntersectsOp;", "insert", "", "itemEnv", "Lorg/locationtech/jts/geom/Envelope;", "item", "query", "searchEnv", "visitor", "Lorg/locationtech/jts/index/ItemVisitor;", "remove", "", "size", "depth", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "getComparator", "()Ljava/util/Comparator;", "nearestNeighbour", "itemDist", "Lorg/locationtech/jts/index/strtree/ItemDistance;", "(Lorg/locationtech/jts/index/strtree/ItemDistance;)[Ljava/lang/Object;", "env", "tree", "(Lorg/locationtech/jts/index/strtree/STRtree;Lorg/locationtech/jts/index/strtree/ItemDistance;)[Ljava/lang/Object;", "initBndPair", "Lorg/locationtech/jts/index/strtree/BoundablePair;", "(Lorg/locationtech/jts/index/strtree/BoundablePair;)[Ljava/lang/Object;", "isWithinDistance", "maxDistance", "", "k", "(Lorg/locationtech/jts/geom/Envelope;Ljava/lang/Object;Lorg/locationtech/jts/index/strtree/ItemDistance;I)[Ljava/lang/Object;", "nearestNeighbourK", "(Lorg/locationtech/jts/index/strtree/BoundablePair;I)[Ljava/lang/Object;", "(Lorg/locationtech/jts/index/strtree/BoundablePair;DI)[Ljava/lang/Object;", "STRtreeNode", "Companion", "kts-core"})
public class STRtree
extends AbstractSTRtree
implements SpatialIndex,
Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final long serialVersionUID = 259274702368956900L;
    @NotNull
    private static final Comparator<Object> xComparator = STRtree::xComparator$lambda$0;
    @NotNull
    private static final Comparator<Object> yComparator = STRtree::yComparator$lambda$0;
    @NotNull
    private static final AbstractSTRtree.IntersectsOp intersectsOp = new AbstractSTRtree.IntersectsOp(){

        public boolean intersects(Object aBounds, Object bBounds) {
            Envelope envelope = (Envelope)aBounds;
            Intrinsics.checkNotNull((Object)envelope);
            Envelope envelope2 = (Envelope)bBounds;
            Intrinsics.checkNotNull((Object)envelope2);
            return envelope.intersects(envelope2);
        }
    };
    private static final int DEFAULT_NODE_CAPACITY = 10;

    @Override
    @NotNull
    protected List<Object> createParentBoundables(@NotNull List<? extends Object> childBoundables, int newLevel) {
        Intrinsics.checkNotNullParameter(childBoundables, (String)"childBoundables");
        Assert.isTrue(!((Collection)childBoundables).isEmpty());
        int minLeafCount = (int)Math.INSTANCE.ceil((double)childBoundables.size() / (double)this.getNodeCapacity());
        ArrayList sortedChildBoundables = new ArrayList(childBoundables);
        CollectionsKt.sortWith((List)sortedChildBoundables, xComparator);
        List<Object>[] verticalSlices = this.verticalSlices(sortedChildBoundables, (int)Math.INSTANCE.ceil(Math.INSTANCE.sqrt(minLeafCount)));
        return this.createParentBoundablesFromVerticalSlices(verticalSlices, newLevel);
    }

    private final List<?> createParentBoundablesFromVerticalSlices(List<Object>[] verticalSlices, int newLevel) {
        Assert.isTrue(!(verticalSlices.length == 0));
        List parentBoundables = new ArrayList();
        for (List<Object> list : verticalSlices) {
            Intrinsics.checkNotNull(list);
            parentBoundables.addAll((Collection)this.createParentBoundablesFromVerticalSlice(list, newLevel));
        }
        return parentBoundables;
    }

    @NotNull
    protected List<Object> createParentBoundablesFromVerticalSlice(@NotNull List<? extends Object> childBoundables, int newLevel) {
        Intrinsics.checkNotNullParameter(childBoundables, (String)"childBoundables");
        return super.createParentBoundables(childBoundables, newLevel);
    }

    @NotNull
    protected List<Object>[] verticalSlices(@NotNull List<?> childBoundables, int sliceCount) {
        Intrinsics.checkNotNullParameter(childBoundables, (String)"childBoundables");
        int sliceCapacity = (int)Math.INSTANCE.ceil((double)childBoundables.size() / (double)sliceCount);
        List[] slices = new List[sliceCount];
        Iterator<?> i = childBoundables.iterator();
        for (int j = 0; j < sliceCount; ++j) {
            slices[j] = new ArrayList();
            for (int boundablesAddedToSlice = 0; i.hasNext() && boundablesAddedToSlice < sliceCapacity; ++boundablesAddedToSlice) {
                Object obj = i.next();
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.index.strtree.Boundable");
                Boundable childBoundable = (Boundable)obj;
                List list = slices[j];
                Intrinsics.checkNotNull((Object)list);
                list.add(childBoundable);
            }
        }
        return slices;
    }

    @JvmOverloads
    public STRtree() {
        super(10);
    }

    public STRtree(int nodeCapacity) {
        super(nodeCapacity);
    }

    public STRtree(int nodeCapacity, @Nullable STRtreeNode root) {
        super(nodeCapacity, root);
    }

    public STRtree(int nodeCapacity, @Nullable List<ItemBoundable> itemBoundables) {
        super(nodeCapacity, itemBoundables);
    }

    @Override
    @Nullable
    protected AbstractNode createNode(int level) {
        return new STRtreeNode(level);
    }

    @Override
    @NotNull
    protected AbstractSTRtree.IntersectsOp getIntersectsOp() {
        return intersectsOp;
    }

    @Override
    public void insert(@Nullable Envelope itemEnv, @Nullable Object item) {
        Envelope envelope = itemEnv;
        Intrinsics.checkNotNull((Object)envelope);
        if (envelope.isNull()) {
            return;
        }
        Object object = item;
        Intrinsics.checkNotNull((Object)object);
        super.insert(itemEnv, object);
    }

    @Override
    @Nullable
    public List<?> query(@Nullable Envelope searchEnv) {
        return super.query(searchEnv);
    }

    @Override
    public void query(@Nullable Envelope searchEnv, @Nullable ItemVisitor visitor) {
        super.query(searchEnv, visitor);
    }

    @Override
    public boolean remove(@Nullable Envelope itemEnv, @Nullable Object item) {
        Object object = item;
        Intrinsics.checkNotNull((Object)object);
        return super.remove(itemEnv, object);
    }

    @Override
    public int size() {
        return super.size();
    }

    @Override
    public int depth() {
        return super.depth();
    }

    @Override
    @NotNull
    protected Comparator<Object> getComparator() {
        return yComparator;
    }

    @Nullable
    public final Object[] nearestNeighbour(@Nullable ItemDistance itemDist) {
        if (this.isEmpty()) {
            return null;
        }
        AbstractNode abstractNode = this.getRoot();
        Intrinsics.checkNotNull((Object)abstractNode);
        Boundable boundable = abstractNode;
        AbstractNode abstractNode2 = this.getRoot();
        Intrinsics.checkNotNull((Object)abstractNode2);
        Boundable boundable2 = abstractNode2;
        ItemDistance itemDistance = itemDist;
        Intrinsics.checkNotNull((Object)itemDistance);
        BoundablePair bp = new BoundablePair(boundable, boundable2, itemDistance);
        return this.nearestNeighbour(bp);
    }

    @Nullable
    public final Object nearestNeighbour(@Nullable Envelope env, @Nullable Object item, @Nullable ItemDistance itemDist) {
        if (this.isEmpty()) {
            return null;
        }
        Envelope envelope = env;
        Intrinsics.checkNotNull((Object)envelope);
        Object object = item;
        Intrinsics.checkNotNull((Object)object);
        Boundable bnd = new ItemBoundable(envelope, object);
        AbstractNode abstractNode = this.getRoot();
        Intrinsics.checkNotNull((Object)abstractNode);
        Boundable boundable = abstractNode;
        ItemDistance itemDistance = itemDist;
        Intrinsics.checkNotNull((Object)itemDistance);
        BoundablePair bp = new BoundablePair(boundable, bnd, itemDistance);
        Object[] objectArray = this.nearestNeighbour(bp);
        Intrinsics.checkNotNull((Object)objectArray);
        return objectArray[0];
    }

    @Nullable
    public final Object[] nearestNeighbour(@NotNull STRtree tree, @Nullable ItemDistance itemDist) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        if (this.isEmpty() || tree.isEmpty()) {
            return null;
        }
        AbstractNode abstractNode = this.getRoot();
        Intrinsics.checkNotNull((Object)abstractNode);
        Boundable boundable = abstractNode;
        AbstractNode abstractNode2 = tree.getRoot();
        Intrinsics.checkNotNull((Object)abstractNode2);
        Boundable boundable2 = abstractNode2;
        ItemDistance itemDistance = itemDist;
        Intrinsics.checkNotNull((Object)itemDistance);
        BoundablePair bp = new BoundablePair(boundable, boundable2, itemDistance);
        return this.nearestNeighbour(bp);
    }

    private final Object[] nearestNeighbour(BoundablePair initBndPair) {
        Object[] objectArray;
        double distanceLowerBound = Double.POSITIVE_INFINITY;
        BoundablePair minPair = null;
        PriorityQueue<BoundablePair> priQ = new PriorityQueue<BoundablePair>(0, null, 3, null);
        priQ.add(initBndPair);
        while (!priQ.isEmpty() && distanceLowerBound > 0.0) {
            Object object = priQ.poll();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.locationtech.jts.index.strtree.BoundablePair");
            BoundablePair bndPair = (BoundablePair)object;
            double pairDistance = bndPair.getDistance();
            if (pairDistance >= distanceLowerBound) break;
            if (bndPair.isLeaves()) {
                distanceLowerBound = pairDistance;
                minPair = bndPair;
                continue;
            }
            bndPair.expandToQueue(priQ, distanceLowerBound);
        }
        if (minPair == null) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[2];
            Boundable boundable = minPair.getBoundable(0);
            Intrinsics.checkNotNull((Object)boundable, (String)"null cannot be cast to non-null type org.locationtech.jts.index.strtree.ItemBoundable");
            objectArray2[0] = ((ItemBoundable)boundable).getItem();
            Boundable boundable2 = minPair.getBoundable(1);
            Intrinsics.checkNotNull((Object)boundable2, (String)"null cannot be cast to non-null type org.locationtech.jts.index.strtree.ItemBoundable");
            objectArray2[1] = ((ItemBoundable)boundable2).getItem();
            objectArray = objectArray2;
        }
        return objectArray;
    }

    public final boolean isWithinDistance(@NotNull STRtree tree, @Nullable ItemDistance itemDist, double maxDistance) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        AbstractNode abstractNode = this.getRoot();
        Intrinsics.checkNotNull((Object)abstractNode);
        Boundable boundable = abstractNode;
        AbstractNode abstractNode2 = tree.getRoot();
        Intrinsics.checkNotNull((Object)abstractNode2);
        Boundable boundable2 = abstractNode2;
        ItemDistance itemDistance = itemDist;
        Intrinsics.checkNotNull((Object)itemDistance);
        BoundablePair bp = new BoundablePair(boundable, boundable2, itemDistance);
        return this.isWithinDistance(bp, maxDistance);
    }

    private final boolean isWithinDistance(BoundablePair initBndPair, double maxDistance) {
        double distanceUpperBound = Double.POSITIVE_INFINITY;
        PriorityQueue<BoundablePair> priQ = new PriorityQueue<BoundablePair>(0, null, 3, null);
        priQ.add(initBndPair);
        while (!priQ.isEmpty()) {
            Object object = priQ.poll();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.locationtech.jts.index.strtree.BoundablePair");
            BoundablePair bndPair = (BoundablePair)object;
            double pairDistance = bndPair.getDistance();
            if (pairDistance > maxDistance) {
                return false;
            }
            if (bndPair.maximumDistance() <= maxDistance) {
                return true;
            }
            if (bndPair.isLeaves()) {
                distanceUpperBound = pairDistance;
                if (!(distanceUpperBound <= maxDistance)) continue;
                return true;
            }
            bndPair.expandToQueue(priQ, distanceUpperBound);
        }
        return false;
    }

    @NotNull
    public final Object[] nearestNeighbour(@Nullable Envelope env, @Nullable Object item, @Nullable ItemDistance itemDist, int k) {
        if (this.isEmpty()) {
            return new Object[0];
        }
        Envelope envelope = env;
        Intrinsics.checkNotNull((Object)envelope);
        Object object = item;
        Intrinsics.checkNotNull((Object)object);
        Boundable bnd = new ItemBoundable(envelope, object);
        AbstractNode abstractNode = this.getRoot();
        Intrinsics.checkNotNull((Object)abstractNode);
        Boundable boundable = abstractNode;
        ItemDistance itemDistance = itemDist;
        Intrinsics.checkNotNull((Object)itemDistance);
        BoundablePair bp = new BoundablePair(boundable, bnd, itemDistance);
        return this.nearestNeighbourK(bp, k);
    }

    private final Object[] nearestNeighbourK(BoundablePair initBndPair, int k) {
        return this.nearestNeighbourK(initBndPair, Double.POSITIVE_INFINITY, k);
    }

    private final Object[] nearestNeighbourK(BoundablePair initBndPair, double maxDistance, int k) {
        double distanceLowerBound = maxDistance;
        PriorityQueue<BoundablePair> priQ = new PriorityQueue<BoundablePair>(0, null, 3, null);
        priQ.add(initBndPair);
        PriorityQueue kNearestNeighbors = new PriorityQueue(0, null, 3, null);
        while (!priQ.isEmpty() && distanceLowerBound >= 0.0) {
            Object object = priQ.poll();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.locationtech.jts.index.strtree.BoundablePair");
            BoundablePair bndPair = (BoundablePair)object;
            double pairDistance = bndPair.getDistance();
            if (pairDistance >= distanceLowerBound) break;
            if (bndPair.isLeaves()) {
                if (kNearestNeighbors.size() < k) {
                    kNearestNeighbors.add(bndPair);
                    continue;
                }
                Object object2 = kNearestNeighbors.peek();
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.locationtech.jts.index.strtree.BoundablePair");
                BoundablePair bp1 = (BoundablePair)object2;
                if (bp1.getDistance() > pairDistance) {
                    kNearestNeighbors.poll();
                    kNearestNeighbors.add(bndPair);
                }
                Object object3 = kNearestNeighbors.peek();
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type org.locationtech.jts.index.strtree.BoundablePair");
                BoundablePair bp2 = (BoundablePair)object3;
                distanceLowerBound = bp2.getDistance();
                continue;
            }
            bndPair.expandToQueue(priQ, distanceLowerBound);
        }
        return STRtree.Companion.getItems(kNearestNeighbors);
    }

    private static final int xComparator$lambda$0(Object o1, Object o2) {
        Intrinsics.checkNotNull((Object)o1, (String)"null cannot be cast to non-null type org.locationtech.jts.index.strtree.Boundable");
        double d = STRtree.Companion.centreX((Envelope)((Boundable)o1).getBounds());
        Intrinsics.checkNotNull((Object)o2, (String)"null cannot be cast to non-null type org.locationtech.jts.index.strtree.Boundable");
        return AbstractSTRtree.compareDoubles(d, STRtree.Companion.centreX((Envelope)((Boundable)o2).getBounds()));
    }

    private static final int yComparator$lambda$0(Object o1, Object o2) {
        Intrinsics.checkNotNull((Object)o1, (String)"null cannot be cast to non-null type org.locationtech.jts.index.strtree.Boundable");
        double d = STRtree.Companion.centreY((Envelope)((Boundable)o1).getBounds());
        Intrinsics.checkNotNull((Object)o2, (String)"null cannot be cast to non-null type org.locationtech.jts.index.strtree.Boundable");
        return AbstractSTRtree.compareDoubles(d, STRtree.Companion.centreY((Envelope)((Boundable)o2).getBounds()));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0012\u0010\u000e\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J!\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0002\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\"\u0010\u0006\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0001`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\t\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0001`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/locationtech/jts/index/strtree/STRtree$Companion;", "", "<init>", "()V", "serialVersionUID", "", "xComparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "yComparator", "centreX", "", "e", "Lorg/locationtech/jts/geom/Envelope;", "centreY", "avg", "a", "b", "intersectsOp", "Lorg/locationtech/jts/index/strtree/AbstractSTRtree$IntersectsOp;", "DEFAULT_NODE_CAPACITY", "", "getItems", "", "kNearestNeighbors", "Lorg/locationtech/jts/legacy/queue/PriorityQueue;", "(Lorg/locationtech/jts/legacy/queue/PriorityQueue;)[Ljava/lang/Object;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        private final double centreX(Envelope e) {
            Envelope envelope = e;
            Intrinsics.checkNotNull((Object)envelope);
            return this.avg(envelope.getMinX(), e.getMaxX());
        }

        private final double centreY(Envelope e) {
            Envelope envelope = e;
            Intrinsics.checkNotNull((Object)envelope);
            return this.avg(envelope.getMinY(), e.getMaxY());
        }

        private final double avg(double a, double b) {
            return (a + b) / 2.0;
        }

        private final Object[] getItems(PriorityQueue<?> kNearestNeighbors) {
            Object[] items = new Object[kNearestNeighbors.size()];
            int count = 0;
            while (!kNearestNeighbors.isEmpty()) {
                Object object = kNearestNeighbors.poll();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.locationtech.jts.index.strtree.BoundablePair");
                BoundablePair bp = (BoundablePair)object;
                Boundable boundable = bp.getBoundable(0);
                Intrinsics.checkNotNull((Object)boundable, (String)"null cannot be cast to non-null type org.locationtech.jts.index.strtree.ItemBoundable");
                items[count] = ((ItemBoundable)boundable).getItem();
                ++count;
            }
            return items;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/locationtech/jts/index/strtree/STRtree$STRtreeNode;", "Lorg/locationtech/jts/index/strtree/AbstractNode;", "level", "", "<init>", "(I)V", "computeBounds", "", "kts-core"})
    public static final class STRtreeNode
    extends AbstractNode {
        public STRtreeNode(int level) {
            super(level);
        }

        @Override
        @Nullable
        protected Object computeBounds() {
            Envelope bounds = null;
            Iterator<Boundable> i = this.getChildBoundables().iterator();
            while (i.hasNext()) {
                Boundable childBoundable;
                Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.index.strtree.Boundable");
                if (bounds == null) {
                    Envelope envelope = (Envelope)childBoundable.getBounds();
                    Intrinsics.checkNotNull((Object)envelope);
                    bounds = new Envelope(envelope);
                    continue;
                }
                Envelope envelope = (Envelope)childBoundable.getBounds();
                Intrinsics.checkNotNull((Object)envelope);
                bounds.expandToInclude(envelope);
            }
            return bounds;
        }
    }
}

