/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.sweepline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.index.sweepline.SweepLineEvent;
import org.locationtech.jts.index.sweepline.SweepLineInterval;
import org.locationtech.jts.index.sweepline.SweepLineOverlapAction;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0010H\u0002J\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016J(\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/locationtech/jts/index/sweepline/SweepLineIndex;", "", "<init>", "()V", "events", "", "Lorg/locationtech/jts/index/sweepline/SweepLineEvent;", "getEvents", "()Ljava/util/List;", "setEvents", "(Ljava/util/List;)V", "indexBuilt", "", "nOverlaps", "", "add", "", "sweepInt", "Lorg/locationtech/jts/index/sweepline/SweepLineInterval;", "buildIndex", "computeOverlaps", "action", "Lorg/locationtech/jts/index/sweepline/SweepLineOverlapAction;", "processOverlaps", "start", "end", "s0", "kts-core"})
public final class SweepLineIndex {
    @NotNull
    private List<SweepLineEvent> events = new ArrayList();
    private boolean indexBuilt;
    private int nOverlaps;

    @NotNull
    public final List<SweepLineEvent> getEvents() {
        return this.events;
    }

    public final void setEvents(@NotNull List<SweepLineEvent> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.events = list;
    }

    public final void add(@NotNull SweepLineInterval sweepInt) {
        Intrinsics.checkNotNullParameter((Object)sweepInt, (String)"sweepInt");
        SweepLineEvent insertEvent = new SweepLineEvent(sweepInt.getMin(), null, sweepInt);
        this.events.add(insertEvent);
        this.events.add(new SweepLineEvent(sweepInt.getMax(), insertEvent, sweepInt));
    }

    private final void buildIndex() {
        if (this.indexBuilt) {
            return;
        }
        CollectionsKt.sort(this.events);
        int n = ((Collection)this.events).size();
        for (int i = 0; i < n; ++i) {
            SweepLineEvent ev = this.events.get(i);
            if (!ev.isDelete()) continue;
            SweepLineEvent sweepLineEvent = ev.getInsertEvent();
            Intrinsics.checkNotNull((Object)sweepLineEvent);
            sweepLineEvent.setDeleteEventIndex(i);
        }
        this.indexBuilt = true;
    }

    public final void computeOverlaps(@NotNull SweepLineOverlapAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        this.nOverlaps = 0;
        this.buildIndex();
        int n = ((Collection)this.events).size();
        for (int i = 0; i < n; ++i) {
            SweepLineEvent ev = this.events.get(i);
            if (!ev.isInsert()) continue;
            this.processOverlaps(i, ev.getDeleteEventIndex(), ev.getInterval(), action);
        }
    }

    private final void processOverlaps(int start, int end, SweepLineInterval s0, SweepLineOverlapAction action) {
        for (int i = start; i < end; ++i) {
            SweepLineEvent ev = this.events.get(i);
            if (!ev.isInsert()) continue;
            SweepLineInterval s1 = ev.getInterval();
            action.overlap(s0, s1);
            int n = this.nOverlaps;
            this.nOverlaps = n + 1;
        }
    }
}

