/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.io.ByteOrderValues;
import org.locationtech.jts.io.InStream;
import org.locationtech.jts.io.ParseException;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0013\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006J\u0010\u0010\u0015\u001a\u00020\u00162\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005J\u000e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\bJ\u0006\u0010\u001b\u001a\u00020\u0011J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\nH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000e\u001a\u0004\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006 "}, d2={"Lorg/locationtech/jts/io/ByteOrderDataInStream;", "", "<init>", "()V", "stream", "Lorg/locationtech/jts/io/InStream;", "(Lorg/locationtech/jts/io/InStream;)V", "byteOrder", "", "buf1", "", "buf4", "buf8", "value", "data", "getData", "()[B", "", "count", "getCount", "()J", "setInStream", "", "setOrder", "readByte", "", "readInt", "readLong", "readDouble", "", "read", "buf", "kts-core"})
public final class ByteOrderDataInStream {
    private int byteOrder = 1;
    @Nullable
    private InStream stream;
    @NotNull
    private final byte[] buf1 = new byte[1];
    @NotNull
    private final byte[] buf4 = new byte[4];
    @NotNull
    private final byte[] buf8 = new byte[8];
    @Nullable
    private byte[] data;
    private long count;

    @Nullable
    public final byte[] getData() {
        return this.data;
    }

    public final long getCount() {
        return this.count;
    }

    public ByteOrderDataInStream() {
        this.stream = null;
    }

    public ByteOrderDataInStream(@Nullable InStream stream) {
        this.stream = stream;
    }

    public final void setInStream(@Nullable InStream stream) {
        this.stream = stream;
    }

    public final void setOrder(int byteOrder) {
        this.byteOrder = byteOrder;
    }

    public final byte readByte() throws IOException, ParseException {
        this.read(this.buf1);
        return this.buf1[0];
    }

    public final int readInt() throws IOException, ParseException {
        this.read(this.buf4);
        return ByteOrderValues.INSTANCE.getInt(this.buf4, this.byteOrder);
    }

    public final long readLong() throws IOException, ParseException {
        this.read(this.buf8);
        return ByteOrderValues.INSTANCE.getLong(this.buf8, this.byteOrder);
    }

    public final double readDouble() throws IOException, ParseException {
        this.read(this.buf8);
        return ByteOrderValues.INSTANCE.getDouble(this.buf8, this.byteOrder);
    }

    private final void read(byte[] buf) throws IOException, ParseException {
        InStream inStream = this.stream;
        Intrinsics.checkNotNull((Object)inStream);
        int num = inStream.read(buf);
        if (num < buf.length) {
            throw new ParseException("Attempt to read past end of input");
        }
        this.data = buf;
        this.count += (long)num;
    }
}

