/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io;

import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.legacy.Synchronized;
import org.locationtech.jts.legacy.format.DecimalFormat;
import org.locationtech.jts.legacy.format.DecimalFormatSymbols;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/locationtech/jts/io/OrdinateFormat;", "", "<init>", "()V", "maximumFractionDigits", "", "(I)V", "format", "Lorg/locationtech/jts/legacy/format/DecimalFormat;", "", "ord", "", "Companion", "kts-core"})
public final class OrdinateFormat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private DecimalFormat format;
    @NotNull
    private static final String DECIMAL_PATTERN = "0";
    @NotNull
    public static final String REP_POS_INF = "Inf";
    @NotNull
    public static final String REP_NEG_INF = "-Inf";
    @NotNull
    public static final String REP_NAN = "NaN";
    public static final int MAX_FRACTION_DIGITS = 325;
    @JvmField
    @NotNull
    public static final OrdinateFormat DEFAULT = new OrdinateFormat();

    public OrdinateFormat() {
        this.format = OrdinateFormat.Companion.createFormat(325);
    }

    public OrdinateFormat(int maximumFractionDigits) {
        this.format = OrdinateFormat.Companion.createFormat(maximumFractionDigits);
    }

    @Synchronized
    @NotNull
    public final String format(double ord) {
        if (Math.INSTANCE.isNaN(ord)) {
            return REP_NAN;
        }
        return Math.INSTANCE.isInfinite(ord) ? (ord > 0.0 ? REP_POS_INF : REP_NEG_INF) : this.format.format(ord);
    }

    @JvmStatic
    @NotNull
    public static final OrdinateFormat create(int maximumFractionDigits) {
        return Companion.create(maximumFractionDigits);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\nH\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/locationtech/jts/io/OrdinateFormat$Companion;", "", "<init>", "()V", "DECIMAL_PATTERN", "", "REP_POS_INF", "REP_NEG_INF", "REP_NAN", "MAX_FRACTION_DIGITS", "", "DEFAULT", "Lorg/locationtech/jts/io/OrdinateFormat;", "create", "maximumFractionDigits", "createFormat", "Lorg/locationtech/jts/legacy/format/DecimalFormat;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final OrdinateFormat create(int maximumFractionDigits) {
            return new OrdinateFormat(maximumFractionDigits);
        }

        private final DecimalFormat createFormat(int maximumFractionDigits) {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols();
            symbols.setDecimalSeparator('.');
            DecimalFormat format = new DecimalFormat(OrdinateFormat.DECIMAL_PATTERN, symbols);
            format.setMaximumFractionDigits(maximumFractionDigits);
            return format;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

