/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ByteOrderValues;
import org.locationtech.jts.io.OutStream;
import org.locationtech.jts.io.OutputStreamOutStream;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 12\u00020\u0001:\u00011B'\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0018\u0010\u0012\u001a\u00020\u00152\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u000fJ\u0018\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J\u0018\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J\u0018\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J \u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J\u0010\u0010$\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J \u0010%\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J\u0018\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J\"\u0010)\u001a\u00020\u00152\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J\"\u0010-\u001a\u00020\u00152\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010.\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J\u0018\u0010/\u001a\u00020\u00152\u0006\u00100\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u000fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/locationtech/jts/io/WKBWriter;", "", "outputDimension", "", "byteOrder", "includeSRID", "", "<init>", "(IIZ)V", "(IZ)V", "getOutputDimension", "()I", "byteArrayOS", "Ljava/io/ByteArrayOutputStream;", "byteArrayOutStream", "Lorg/locationtech/jts/io/OutStream;", "buf", "", "write", "geom", "Lorg/locationtech/jts/geom/Geometry;", "", "os", "writePoint", "pt", "Lorg/locationtech/jts/geom/Point;", "writeLineString", "line", "Lorg/locationtech/jts/geom/LineString;", "writePolygon", "poly", "Lorg/locationtech/jts/geom/Polygon;", "writeGeometryCollection", "geometryType", "gc", "Lorg/locationtech/jts/geom/GeometryCollection;", "writeByteOrder", "writeGeometryType", "g", "writeInt", "intValue", "writeCoordinateSequence", "seq", "Lorg/locationtech/jts/geom/CoordinateSequence;", "writeSize", "writeCoordinate", "index", "writeNaNs", "numNaNs", "Companion", "kts-core"})
public final class WKBWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int outputDimension;
    private final int byteOrder;
    private boolean includeSRID;
    @NotNull
    private final ByteArrayOutputStream byteArrayOS;
    @NotNull
    private final OutStream byteArrayOutStream;
    @NotNull
    private final byte[] buf;

    @JvmOverloads
    public WKBWriter(int outputDimension, int byteOrder, boolean includeSRID) {
        this.outputDimension = outputDimension;
        this.byteArrayOS = new ByteArrayOutputStream();
        this.byteArrayOutStream = new OutputStreamOutStream(this.byteArrayOS);
        this.buf = new byte[8];
        this.byteOrder = byteOrder;
        this.includeSRID = includeSRID;
        if (this.outputDimension < 2 || this.outputDimension > 3) {
            throw new IllegalArgumentException("Output dimension must be 2 or 3");
        }
    }

    public /* synthetic */ WKBWriter(int n, int n2, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 2;
        }
        if ((n3 & 2) != 0) {
            n2 = 1;
        }
        if ((n3 & 4) != 0) {
            bl = false;
        }
        this(n, n2, bl);
    }

    public final int getOutputDimension() {
        return this.outputDimension;
    }

    public WKBWriter(int outputDimension, boolean includeSRID) {
        this(outputDimension, 1, includeSRID);
    }

    @NotNull
    public final byte[] write(@Nullable Geometry geom) {
        try {
            this.byteArrayOS.reset();
            this.write(geom, this.byteArrayOutStream);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unexpected IO exception: " + ex.getMessage());
        }
        byte[] byArray = this.byteArrayOS.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    public final void write(@Nullable Geometry geom, @NotNull OutStream os) throws IOException {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        if (geom instanceof Point) {
            this.writePoint((Point)geom, os);
        } else if (geom instanceof LineString) {
            this.writeLineString((LineString)geom, os);
        } else if (geom instanceof Polygon) {
            this.writePolygon((Polygon)geom, os);
        } else if (geom instanceof MultiPoint) {
            this.writeGeometryCollection(4, (GeometryCollection)geom, os);
        } else if (geom instanceof MultiLineString) {
            this.writeGeometryCollection(5, (GeometryCollection)geom, os);
        } else if (geom instanceof MultiPolygon) {
            this.writeGeometryCollection(6, (GeometryCollection)geom, os);
        } else if (geom instanceof GeometryCollection) {
            this.writeGeometryCollection(7, (GeometryCollection)geom, os);
        } else {
            Assert.shouldNeverReachHere("Unknown Geometry type");
        }
    }

    private final void writePoint(Point pt, OutStream os) throws IOException {
        this.writeByteOrder(os);
        this.writeGeometryType(1, pt, os);
        CoordinateSequence coordinateSequence = pt.getCoordinateSequence();
        Intrinsics.checkNotNull((Object)coordinateSequence);
        if (coordinateSequence.size() == 0) {
            this.writeNaNs(this.outputDimension, os);
        } else {
            this.writeCoordinateSequence(pt.getCoordinateSequence(), false, os);
        }
    }

    private final void writeLineString(LineString line, OutStream os) throws IOException {
        this.writeByteOrder(os);
        this.writeGeometryType(2, line, os);
        this.writeCoordinateSequence(line.getCoordinateSequence(), true, os);
    }

    private final void writePolygon(Polygon poly, OutStream os) throws IOException {
        this.writeByteOrder(os);
        this.writeGeometryType(3, poly, os);
        if (poly.isEmpty()) {
            this.writeInt(0, os);
            return;
        }
        this.writeInt(poly.getNumInteriorRing() + 1, os);
        LinearRing linearRing = poly.getExteriorRing();
        Intrinsics.checkNotNull((Object)linearRing);
        this.writeCoordinateSequence(linearRing.getCoordinateSequence(), true, os);
        int n = poly.getNumInteriorRing();
        for (int i = 0; i < n; ++i) {
            this.writeCoordinateSequence(poly.getInteriorRingN(i).getCoordinateSequence(), true, os);
        }
    }

    private final void writeGeometryCollection(int geometryType, GeometryCollection gc, OutStream os) throws IOException {
        this.writeByteOrder(os);
        this.writeGeometryType(geometryType, gc, os);
        this.writeInt(gc.getNumGeometries(), os);
        boolean originalIncludeSRID = this.includeSRID;
        this.includeSRID = false;
        int n = gc.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            this.write(gc.getGeometryN(i), os);
        }
        this.includeSRID = originalIncludeSRID;
    }

    private final void writeByteOrder(OutStream os) throws IOException {
        this.buf[0] = this.byteOrder == 2 ? (byte)1 : 0;
        os.write(this.buf, 1);
    }

    private final void writeGeometryType(int geometryType, Geometry g, OutStream os) throws IOException {
        int flag3D = this.outputDimension == 3 ? Integer.MIN_VALUE : 0;
        int typeInt = geometryType | flag3D;
        this.writeInt(typeInt |= this.includeSRID ? 0x20000000 : 0, os);
        if (this.includeSRID) {
            this.writeInt(g.getSRID(), os);
        }
    }

    private final void writeInt(int intValue, OutStream os) throws IOException {
        ByteOrderValues.putInt(intValue, this.buf, this.byteOrder);
        os.write(this.buf, 4);
    }

    private final void writeCoordinateSequence(CoordinateSequence seq, boolean writeSize, OutStream os) throws IOException {
        if (writeSize) {
            CoordinateSequence coordinateSequence = seq;
            Intrinsics.checkNotNull((Object)coordinateSequence);
            this.writeInt(coordinateSequence.size(), os);
        }
        CoordinateSequence coordinateSequence = seq;
        Intrinsics.checkNotNull((Object)coordinateSequence);
        int n = coordinateSequence.size();
        for (int i = 0; i < n; ++i) {
            this.writeCoordinate(seq, i, os);
        }
    }

    private final void writeCoordinate(CoordinateSequence seq, int index, OutStream os) throws IOException {
        CoordinateSequence coordinateSequence = seq;
        Intrinsics.checkNotNull((Object)coordinateSequence);
        ByteOrderValues.putDouble(coordinateSequence.getX(index), this.buf, this.byteOrder);
        os.write(this.buf, 8);
        ByteOrderValues.putDouble(seq.getY(index), this.buf, this.byteOrder);
        os.write(this.buf, 8);
        if (this.outputDimension >= 3) {
            double ordVal = Double.NaN;
            if (seq.getDimension() >= 3) {
                ordVal = seq.getOrdinate(index, 2);
            }
            ByteOrderValues.putDouble(ordVal, this.buf, this.byteOrder);
            os.write(this.buf, 8);
        }
    }

    private final void writeNaNs(int numNaNs, OutStream os) throws IOException {
        for (int i = 0; i < numNaNs; ++i) {
            ByteOrderValues.putDouble(Double.NaN, this.buf, this.byteOrder);
            os.write(this.buf, 8);
        }
    }

    @JvmOverloads
    public WKBWriter(int outputDimension, int byteOrder) {
        this(outputDimension, byteOrder, false, 4, null);
    }

    @JvmOverloads
    public WKBWriter(int outputDimension) {
        this(outputDimension, 0, false, 6, null);
    }

    @JvmOverloads
    public WKBWriter() {
        this(0, 0, false, 7, null);
    }

    @JvmStatic
    @NotNull
    public static final String toHex(@NotNull byte[] bytes) {
        return Companion.toHex(bytes);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lorg/locationtech/jts/io/WKBWriter$Companion;", "", "<init>", "()V", "bytesToHex", "", "bytes", "", "toHex", "toHexDigit", "", "n", "", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @Deprecated(message="")
        @NotNull
        public final String bytesToHex(@NotNull byte[] bytes) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            return this.toHex(bytes);
        }

        @JvmStatic
        @NotNull
        public final String toHex(@NotNull byte[] bytes) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            StringBuilder buf = new StringBuilder();
            for (byte b : bytes) {
                buf.append(this.toHexDigit(b >> 4 & 0xF));
                buf.append(this.toHexDigit(b & 0xF));
            }
            String string = buf.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final char toHexDigit(int n) {
            if (n < 0 || n > 15) {
                throw new IllegalArgumentException("Nibble value out of range: " + n);
            }
            return n <= 9 ? (char)(48 + n) : (char)(65 + (n - 10));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

