/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io.gml2;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 B2\u00020\u0001:\u0001BB\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006J\u0010\u0010\u0012\u001a\u00020\u00132\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0010\u0010\u0014\u001a\u00020\u00132\b\u0010\u000e\u001a\u0004\u0018\u00010\fJ\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u0005J\u001b\u0010\u0016\u001a\u00020\u00132\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0017J\u000e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\bJ\u000e\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\bJ\u000e\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J \u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\bH\u0002J \u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\bH\u0002J \u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\bH\u0002J \u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020*2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\bH\u0002J \u0010+\u001a\u00020\u00132\u0006\u0010#\u001a\u00020,2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\bH\u0002J \u0010-\u001a\u00020\u00132\u0006\u0010.\u001a\u00020/2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\bH\u0002J \u00100\u001a\u00020\u00132\u0006\u00101\u001a\u0002022\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\bH\u0002J \u00103\u001a\u00020\u00132\u0006\u0010.\u001a\u0002042\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\bH\u0002J \u00105\u001a\u00020\u00132\u0006\u00106\u001a\u0002072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\bH\u0002J+\u0010\u001c\u001a\u00020\u00132\f\u00108\u001a\b\u0012\u0004\u0012\u0002090\u00102\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010:J\u0018\u0010;\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020 H\u0002J\"\u0010<\u001a\u00020\u00132\u0006\u0010=\u001a\u00020\f2\b\u0010>\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001a\u0010?\u001a\u00020\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001a\u0010@\u001a\u00020\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010A\u001a\u00020\u00132\u0006\u0010=\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006C"}, d2={"Lorg/locationtech/jts/io/gml2/GMLWriter;", "", "<init>", "()V", "emitNamespace", "", "(Z)V", "startingIndentIndex", "", "maxCoordinatesPerLine", "isRootTag", "prefix", "", "namespace", "srsName", "customElements", "", "[Ljava/lang/String;", "setPrefix", "", "setSrsName", "setNamespace", "setCustomElements", "([Ljava/lang/String;)V", "setStartingIndentIndex", "indent", "setMaxCoordinatesPerLine", "num", "write", "geom", "Lorg/locationtech/jts/geom/Geometry;", "writer", "Ljava/io/Writer;", "level", "writePoint", "p", "Lorg/locationtech/jts/geom/Point;", "writeLineString", "ls", "Lorg/locationtech/jts/geom/LineString;", "writeLinearRing", "lr", "Lorg/locationtech/jts/geom/LinearRing;", "writePolygon", "Lorg/locationtech/jts/geom/Polygon;", "writeMultiPoint", "mp", "Lorg/locationtech/jts/geom/MultiPoint;", "writeMultiLineString", "mls", "Lorg/locationtech/jts/geom/MultiLineString;", "writeMultiPolygon", "Lorg/locationtech/jts/geom/MultiPolygon;", "writeGeometryCollection", "gc", "Lorg/locationtech/jts/geom/GeometryCollection;", "coords", "Lorg/locationtech/jts/geom/Coordinate;", "([Lorg/locationtech/jts/geom/Coordinate;Ljava/io/Writer;I)V", "startLine", "startGeomTag", "geometryName", "g", "writeAttributes", "writeCustomElements", "endGeomTag", "Companion", "kts-core"})
public final class GMLWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int startingIndentIndex;
    private int maxCoordinatesPerLine = 10;
    private boolean emitNamespace;
    private boolean isRootTag;
    @Nullable
    private String prefix = "gml";
    @NotNull
    private final String namespace;
    @Nullable
    private String srsName;
    @Nullable
    private String[] customElements;
    @NotNull
    private static final String INDENT = "  ";
    @NotNull
    private static final String coordinateSeparator = ",";
    @NotNull
    private static final String tupleSeparator = " ";

    public GMLWriter() {
        this.namespace = "http://www.opengis.net/gml";
    }

    public GMLWriter(boolean emitNamespace) {
        this.namespace = "http://www.opengis.net/gml";
        this.setNamespace(emitNamespace);
    }

    public final void setPrefix(@Nullable String prefix) {
        this.prefix = prefix;
    }

    public final void setSrsName(@Nullable String srsName) {
        this.srsName = srsName;
    }

    public final void setNamespace(boolean emitNamespace) {
        this.emitNamespace = emitNamespace;
    }

    public final void setCustomElements(@Nullable String[] customElements) {
        this.customElements = customElements;
    }

    public final void setStartingIndentIndex(int indent) {
        int indent2 = indent;
        if (indent2 < 0) {
            indent2 = 0;
        }
        this.startingIndentIndex = indent2;
    }

    public final void setMaxCoordinatesPerLine(int num) {
        if (num < 1) {
            throw new IndexOutOfBoundsException("Invalid coordinate count per line, must be > 0");
        }
        this.maxCoordinatesPerLine = num;
    }

    @NotNull
    public final String write(@NotNull Geometry geom) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        StringWriter writer = new StringWriter();
        try {
            this.write(geom, writer);
        }
        catch (IOException ex) {
            Assert.shouldNeverReachHere$default(null, 1, null);
        }
        String string = writer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final void write(@NotNull Geometry geom, @NotNull Writer writer) throws IOException {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        this.write(geom, writer, this.startingIndentIndex);
    }

    private final void write(Geometry geom, Writer writer, int level) throws IOException {
        this.isRootTag = true;
        if (geom instanceof Point) {
            this.writePoint((Point)geom, writer, level);
        } else if (geom instanceof LineString) {
            this.writeLineString((LineString)geom, writer, level);
        } else if (geom instanceof Polygon) {
            this.writePolygon((Polygon)geom, writer, level);
        } else if (geom instanceof MultiPoint) {
            this.writeMultiPoint((MultiPoint)geom, writer, level);
        } else if (geom instanceof MultiLineString) {
            this.writeMultiLineString((MultiLineString)geom, writer, level);
        } else if (geom instanceof MultiPolygon) {
            this.writeMultiPolygon((MultiPolygon)geom, writer, level);
        } else if (geom instanceof GeometryCollection) {
            this.writeGeometryCollection((GeometryCollection)geom, writer, this.startingIndentIndex);
        } else {
            throw new IllegalArgumentException("Unhandled geometry type: " + geom.getGeometryType());
        }
        writer.flush();
    }

    private final void writePoint(Point p, Writer writer, int level) throws IOException {
        this.startLine(level, writer);
        this.startGeomTag("Point", p, writer);
        Coordinate[] coordinateArray = new Coordinate[1];
        Intrinsics.checkNotNull((Object)p.getCoordinate());
        this.write(coordinateArray, writer, level + 1);
        this.startLine(level, writer);
        this.endGeomTag("Point", writer);
    }

    private final void writeLineString(LineString ls, Writer writer, int level) throws IOException {
        this.startLine(level, writer);
        this.startGeomTag("LineString", ls, writer);
        this.write(ls.getCoordinates(), writer, level + 1);
        this.startLine(level, writer);
        this.endGeomTag("LineString", writer);
    }

    private final void writeLinearRing(LinearRing lr, Writer writer, int level) throws IOException {
        this.startLine(level, writer);
        this.startGeomTag("LinearRing", lr, writer);
        this.write(lr.getCoordinates(), writer, level + 1);
        this.startLine(level, writer);
        this.endGeomTag("LinearRing", writer);
    }

    private final void writePolygon(Polygon p, Writer writer, int level) throws IOException {
        this.startLine(level, writer);
        this.startGeomTag("Polygon", p, writer);
        this.startLine(level + 1, writer);
        this.startGeomTag("outerBoundaryIs", null, writer);
        LinearRing linearRing = p.getExteriorRing();
        Intrinsics.checkNotNull((Object)linearRing);
        this.writeLinearRing(linearRing, writer, level + 2);
        this.startLine(level + 1, writer);
        this.endGeomTag("outerBoundaryIs", writer);
        int n = p.getNumInteriorRing();
        for (int t = 0; t < n; ++t) {
            this.startLine(level + 1, writer);
            this.startGeomTag("innerBoundaryIs", null, writer);
            this.writeLinearRing(p.getInteriorRingN(t), writer, level + 2);
            this.startLine(level + 1, writer);
            this.endGeomTag("innerBoundaryIs", writer);
        }
        this.startLine(level, writer);
        this.endGeomTag("Polygon", writer);
    }

    private final void writeMultiPoint(MultiPoint mp, Writer writer, int level) throws IOException {
        this.startLine(level, writer);
        this.startGeomTag("MultiPoint", mp, writer);
        int n = mp.getNumGeometries();
        for (int t = 0; t < n; ++t) {
            this.startLine(level + 1, writer);
            this.startGeomTag("pointMember", null, writer);
            Geometry geometry = mp.getGeometryN(t);
            Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Point");
            this.writePoint((Point)geometry, writer, level + 2);
            this.startLine(level + 1, writer);
            this.endGeomTag("pointMember", writer);
        }
        this.startLine(level, writer);
        this.endGeomTag("MultiPoint", writer);
    }

    private final void writeMultiLineString(MultiLineString mls, Writer writer, int level) throws IOException {
        this.startLine(level, writer);
        this.startGeomTag("MultiLineString", mls, writer);
        int n = mls.getNumGeometries();
        for (int t = 0; t < n; ++t) {
            this.startLine(level + 1, writer);
            this.startGeomTag("lineStringMember", null, writer);
            Geometry geometry = mls.getGeometryN(t);
            Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
            this.writeLineString((LineString)geometry, writer, level + 2);
            this.startLine(level + 1, writer);
            this.endGeomTag("lineStringMember", writer);
        }
        this.startLine(level, writer);
        this.endGeomTag("MultiLineString", writer);
    }

    private final void writeMultiPolygon(MultiPolygon mp, Writer writer, int level) throws IOException {
        this.startLine(level, writer);
        this.startGeomTag("MultiPolygon", mp, writer);
        int n = mp.getNumGeometries();
        for (int t = 0; t < n; ++t) {
            this.startLine(level + 1, writer);
            this.startGeomTag("polygonMember", null, writer);
            Geometry geometry = mp.getGeometryN(t);
            Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
            this.writePolygon((Polygon)geometry, writer, level + 2);
            this.startLine(level + 1, writer);
            this.endGeomTag("polygonMember", writer);
        }
        this.startLine(level, writer);
        this.endGeomTag("MultiPolygon", writer);
    }

    private final void writeGeometryCollection(GeometryCollection gc, Writer writer, int level) throws IOException {
        this.startLine(level, writer);
        this.startGeomTag("MultiGeometry", gc, writer);
        int n = gc.getNumGeometries();
        for (int t = 0; t < n; ++t) {
            this.startLine(level + 1, writer);
            this.startGeomTag("geometryMember", null, writer);
            this.write(gc.getGeometryN(t), writer, level + 2);
            this.startLine(level + 1, writer);
            this.endGeomTag("geometryMember", writer);
        }
        this.startLine(level, writer);
        this.endGeomTag("MultiGeometry", writer);
    }

    private final void write(Coordinate[] coords, Writer writer, int level) throws IOException {
        this.startLine(level, writer);
        this.startGeomTag("coordinates", null, writer);
        int dim = 2;
        if (coords.length > 0 && !Math.INSTANCE.isNaN(coords[0].getZ())) {
            dim = 3;
        }
        boolean isNewLine = true;
        int n = coords.length;
        for (int i = 0; i < n; ++i) {
            if (isNewLine) {
                this.startLine(level + 1, writer);
                isNewLine = false;
            }
            switch (dim) {
                case 2: {
                    writer.write("" + coords[i].x);
                    writer.write(coordinateSeparator);
                    writer.write("" + coords[i].y);
                    break;
                }
                case 3: {
                    writer.write("" + coords[i].x);
                    writer.write(coordinateSeparator);
                    writer.write("" + coords[i].y);
                    writer.write(coordinateSeparator);
                    writer.write("" + coords[i].getZ());
                }
            }
            writer.write(tupleSeparator);
            if ((i + 1) % this.maxCoordinatesPerLine != 0 || i >= coords.length - 1) continue;
            writer.write("\n");
            isNewLine = true;
        }
        if (!isNewLine) {
            writer.write("\n");
        }
        this.startLine(level, writer);
        this.endGeomTag("coordinates", writer);
    }

    private final void startLine(int level, Writer writer) throws IOException {
        for (int i = 0; i < level; ++i) {
            writer.write(INDENT);
        }
    }

    private final void startGeomTag(String geometryName, Geometry g, Writer writer) throws IOException {
        writer.write("<" + (String)(this.prefix == null || Intrinsics.areEqual((Object)"", (Object)this.prefix) ? "" : this.prefix + ":"));
        writer.write(geometryName);
        this.writeAttributes(g, writer);
        writer.write(">\n");
        this.writeCustomElements(g, writer);
        this.isRootTag = false;
    }

    private final void writeAttributes(Geometry geom, Writer writer) throws IOException {
        if (geom == null) {
            return;
        }
        if (!this.isRootTag) {
            return;
        }
        if (this.emitNamespace) {
            writer.write(" xmlns" + (String)(this.prefix == null || Intrinsics.areEqual((Object)"", (Object)this.prefix) ? "" : ":" + this.prefix) + "='" + this.namespace + "'");
        }
        if (this.srsName != null) {
            String string = this.srsName;
            Intrinsics.checkNotNull((Object)string);
            if (string.length() > 0) {
                writer.write(" srsName='" + this.srsName + "'");
            }
        }
    }

    private final void writeCustomElements(Geometry geom, Writer writer) throws IOException {
        if (geom == null) {
            return;
        }
        if (!this.isRootTag) {
            return;
        }
        if (this.customElements == null) {
            return;
        }
        Intrinsics.checkNotNull((Object)this.customElements);
        int n = this.customElements.length;
        for (int i = 0; i < n; ++i) {
            Intrinsics.checkNotNull((Object)this.customElements);
            writer.write(this.customElements[i]);
            writer.write("\n");
        }
    }

    private final void endGeomTag(String geometryName, Writer writer) throws IOException {
        writer.write("</" + this.prefix());
        writer.write(geometryName);
        writer.write(">\n");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String prefix() {
        if (this.prefix == null) return "";
        String string = this.prefix;
        Intrinsics.checkNotNull((Object)string);
        if (string.length() == 0) {
            return "";
        }
        String string2 = this.prefix + ":";
        return string2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/locationtech/jts/io/gml2/GMLWriter$Companion;", "", "<init>", "()V", "INDENT", "", "coordinateSeparator", "tupleSeparator", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

