/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io.gml2;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.gml2.GMLHandler;
import org.locationtech.jts.legacy.Cloneable;
import org.locationtech.jts.util.StringUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bH\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bJ\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00062\b\u0010\u0016\u001a\u0004\u0018\u00010\u0006J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u00062\b\u0010\u0019\u001a\u0004\u0018\u00010\u0006R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001b"}, d2={"Lorg/locationtech/jts/io/gml2/GeometryStrategies;", "", "<init>", "()V", "strategies", "Ljava/util/HashMap;", "", "Lorg/locationtech/jts/io/gml2/GeometryStrategies$ParseStrategy;", "Lkotlin/collections/HashMap;", "loadStrategies", "getSrid", "", "attrs", "Lorg/xml/sax/Attributes;", "defaultValue", "PATT_SUFFIX_INT", "Ljava/util/regex/Pattern;", "getPATT_SUFFIX_INT", "()Ljava/util/regex/Pattern;", "setPATT_SUFFIX_INT", "(Ljava/util/regex/Pattern;)V", "extractIntSuffix", "s", "findStrategy", "uri", "localName", "ParseStrategy", "kts-core"})
@SourceDebugExtension(value={"SMAP\nGeometryStrategies.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeometryStrategies.kt\norg/locationtech/jts/io/gml2/GeometryStrategies\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,454:1\n106#2:455\n78#2,22:456\n*S KotlinDebug\n*F\n+ 1 GeometryStrategies.kt\norg/locationtech/jts/io/gml2/GeometryStrategies\n*L\n397#1:455\n397#1:456,22\n*E\n"})
public final class GeometryStrategies {
    @NotNull
    public static final GeometryStrategies INSTANCE = new GeometryStrategies();
    @NotNull
    private static final HashMap<String, ParseStrategy> strategies = INSTANCE.loadStrategies();
    @NotNull
    private static Pattern PATT_SUFFIX_INT;

    private GeometryStrategies() {
    }

    private final HashMap<String, ParseStrategy> loadStrategies() {
        HashMap<String, ParseStrategy> strats = new HashMap<String, ParseStrategy>();
        String string = "Point".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        strats.put(string, new ParseStrategy(){

            public Object parse(GMLHandler.Handler arg, GeometryFactory gf) throws SAXException {
                Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
                Intrinsics.checkNotNullParameter((Object)gf, (String)"gf");
                List<Object> list = arg.getChildren();
                Intrinsics.checkNotNull(list);
                if (list.size() != 1) {
                    throw new SAXException("Cannot create a point without exactly one coordinate");
                }
                Attributes attributes = arg.getAttrs();
                Intrinsics.checkNotNull((Object)attributes);
                int srid = GeometryStrategies.INSTANCE.getSrid(attributes, gf.getSRID());
                List<Object> list2 = arg.getChildren();
                Intrinsics.checkNotNull(list2);
                Object c = list2.get(0);
                Point p = null;
                if (c instanceof Coordinate) {
                    v3 = gf.createPoint((Coordinate)c);
                } else {
                    Intrinsics.checkNotNull((Object)c, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.CoordinateSequence");
                    v3 = p = gf.createPoint((CoordinateSequence)c);
                }
                if (p.getSRID() != srid) {
                    p.setSRID(srid);
                }
                return p;
            }
        });
        String string2 = "LineString".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        strats.put(string2, new ParseStrategy(){

            public Object parse(GMLHandler.Handler arg, GeometryFactory gf) throws SAXException {
                Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
                Intrinsics.checkNotNullParameter((Object)gf, (String)"gf");
                List<Object> list = arg.getChildren();
                Intrinsics.checkNotNull(list);
                if (list.size() < 1) {
                    throw new SAXException("Cannot create a linestring without atleast two coordinates or one coordinate sequence");
                }
                Attributes attributes = arg.getAttrs();
                Intrinsics.checkNotNull((Object)attributes);
                int srid = GeometryStrategies.INSTANCE.getSrid(attributes, gf.getSRID());
                Cloneable ls = null;
                List<Object> list2 = arg.getChildren();
                Intrinsics.checkNotNull(list2);
                if (list2.size() == 1) {
                    Cloneable cs;
                    try {
                        List<Object> list3 = arg.getChildren();
                        Intrinsics.checkNotNull(list3);
                        Object object = list3.get(0);
                        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.CoordinateSequence");
                        cs = (CoordinateSequence)object;
                        cs = gf.createLineString((CoordinateSequence)cs);
                    }
                    catch (ClassCastException e) {
                        throw new SAXException("Cannot create a linestring without atleast two coordinates or one coordinate sequence", e);
                    }
                    v5 = cs;
                } else {
                    LineString lineString;
                    try {
                        List<Object> list4 = arg.getChildren();
                        Intrinsics.checkNotNull(list4);
                        Collection $this$toTypedArray$iv = list4;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
                        Intrinsics.checkNotNull((Object)objectArray, (String)"null cannot be cast to non-null type kotlin.Array<org.locationtech.jts.geom.Coordinate>");
                        Coordinate[] coords = (Coordinate[])objectArray;
                        lineString = gf.createLineString(coords);
                    }
                    catch (ClassCastException e) {
                        throw new SAXException("Cannot create a linestring without atleast two coordinates or one coordinate sequence", e);
                    }
                    v5 = ls = lineString;
                }
                if (((Geometry)ls).getSRID() != srid) {
                    ((Geometry)ls).setSRID(srid);
                }
                return ls;
            }
        });
        String string3 = "LinearRing".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        strats.put(string3, new ParseStrategy(){

            public Object parse(GMLHandler.Handler arg, GeometryFactory gf) throws SAXException {
                Cloneable cloneable;
                Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
                Intrinsics.checkNotNullParameter((Object)gf, (String)"gf");
                List<Object> list = arg.getChildren();
                Intrinsics.checkNotNull(list);
                if (list.size() != 1) {
                    List<Object> list2 = arg.getChildren();
                    Intrinsics.checkNotNull(list2);
                    if (list2.size() < 4) {
                        throw new SAXException("Cannot create a linear ring without atleast four coordinates or one coordinate sequence");
                    }
                }
                Attributes attributes = arg.getAttrs();
                Intrinsics.checkNotNull((Object)attributes);
                int srid = GeometryStrategies.INSTANCE.getSrid(attributes, gf.getSRID());
                Cloneable ls = null;
                List<Object> list3 = arg.getChildren();
                Intrinsics.checkNotNull(list3);
                if (list3.size() == 1) {
                    Cloneable cs;
                    try {
                        List<Object> list4 = arg.getChildren();
                        Intrinsics.checkNotNull(list4);
                        Object object = list4.get(0);
                        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.CoordinateSequence");
                        cs = (CoordinateSequence)object;
                        cs = gf.createLinearRing((CoordinateSequence)cs);
                    }
                    catch (ClassCastException e) {
                        throw new SAXException("Cannot create a linear ring without atleast four coordinates or one coordinate sequence", e);
                    }
                    cloneable = cs;
                } else {
                    LinearRing linearRing;
                    try {
                        List<Object> list5 = arg.getChildren();
                        Intrinsics.checkNotNull(list5);
                        Collection $this$toTypedArray$iv = list5;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
                        Intrinsics.checkNotNull((Object)objectArray, (String)"null cannot be cast to non-null type kotlin.Array<org.locationtech.jts.geom.Coordinate>");
                        Coordinate[] coords = (Coordinate[])objectArray;
                        linearRing = gf.createLinearRing(coords);
                    }
                    catch (ClassCastException e) {
                        throw new SAXException("Cannot create a linear ring without atleast four coordinates or one coordinate sequence", e);
                    }
                    cloneable = linearRing;
                }
                Cloneable cloneable2 = ls = cloneable;
                Intrinsics.checkNotNull((Object)cloneable2);
                if (((Geometry)cloneable2).getSRID() != srid) {
                    ((Geometry)ls).setSRID(srid);
                }
                return ls;
            }
        });
        String string4 = "Polygon".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        strats.put(string4, new ParseStrategy(){

            public Object parse(GMLHandler.Handler arg, GeometryFactory gf) throws SAXException {
                Object[] objectArray;
                List<Object> t;
                List<Object> list;
                Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
                Intrinsics.checkNotNullParameter((Object)gf, (String)"gf");
                List<Object> list2 = arg.getChildren();
                Intrinsics.checkNotNull(list2);
                if (list2.size() < 1) {
                    throw new SAXException("Cannot create a polygon without atleast one linear ring");
                }
                Attributes attributes = arg.getAttrs();
                Intrinsics.checkNotNull((Object)attributes);
                int srid = GeometryStrategies.INSTANCE.getSrid(attributes, gf.getSRID());
                List<Object> list3 = arg.getChildren();
                Intrinsics.checkNotNull(list3);
                Object object = list3.get(0);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LinearRing");
                LinearRing outer = (LinearRing)object;
                List<Object> list4 = arg.getChildren();
                Intrinsics.checkNotNull(list4);
                if (list4.size() > 1) {
                    List<Object> list5 = arg.getChildren();
                    Intrinsics.checkNotNull(list5);
                    List<Object> list6 = arg.getChildren();
                    Intrinsics.checkNotNull(list6);
                    list = list5.subList(1, list6.size());
                } else {
                    list = null;
                }
                List<Object> list7 = t = list;
                if (list7 == null) {
                    objectArray = null;
                } else {
                    Collection $this$toTypedArray$iv = list7;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    objectArray = thisCollection$iv.toArray(new Object[0]);
                }
                Object[] inner = objectArray;
                Intrinsics.checkNotNull(inner, (String)"null cannot be cast to non-null type kotlin.Array<org.locationtech.jts.geom.LinearRing>");
                Polygon p = gf.createPolygon(outer, (LinearRing[])inner);
                if (p.getSRID() != srid) {
                    p.setSRID(srid);
                }
                return p;
            }
        });
        String string5 = "Box".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
        strats.put(string5, new ParseStrategy(){

            public Object parse(GMLHandler.Handler arg, GeometryFactory gf) throws SAXException {
                Envelope envelope;
                block6: {
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
                        Intrinsics.checkNotNullParameter((Object)gf, (String)"gf");
                        List<Object> list = arg.getChildren();
                        Intrinsics.checkNotNull(list);
                        if (list.size() < 1) break block5;
                        List<Object> list2 = arg.getChildren();
                        Intrinsics.checkNotNull(list2);
                        if (list2.size() <= 2) break block6;
                    }
                    throw new SAXException("Cannot create a box without either two coords or one coordinate sequence");
                }
                Envelope box = null;
                List<Object> list = arg.getChildren();
                Intrinsics.checkNotNull(list);
                if (list.size() == 1) {
                    List<Object> list3 = arg.getChildren();
                    Intrinsics.checkNotNull(list3);
                    Object object = list3.get(0);
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.CoordinateSequence");
                    CoordinateSequence cs = (CoordinateSequence)object;
                    envelope = cs.expandEnvelope(new Envelope());
                } else {
                    List<Object> list4 = arg.getChildren();
                    Intrinsics.checkNotNull(list4);
                    Object object = list4.get(0);
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Coordinate");
                    Coordinate coordinate = (Coordinate)object;
                    List<Object> list5 = arg.getChildren();
                    Intrinsics.checkNotNull(list5);
                    Object object2 = list5.get(1);
                    Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Coordinate");
                    envelope = new Envelope(coordinate, (Coordinate)object2);
                }
                box = envelope;
                return box;
            }
        });
        String string6 = "MultiPoint".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toLowerCase(...)");
        strats.put(string6, new ParseStrategy(){

            public Object parse(GMLHandler.Handler arg, GeometryFactory gf) throws SAXException {
                Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
                Intrinsics.checkNotNullParameter((Object)gf, (String)"gf");
                List<Object> list = arg.getChildren();
                Intrinsics.checkNotNull(list);
                if (list.size() < 1) {
                    throw new SAXException("Cannot create a multi-point without atleast one point");
                }
                Attributes attributes = arg.getAttrs();
                Intrinsics.checkNotNull((Object)attributes);
                int srid = GeometryStrategies.INSTANCE.getSrid(attributes, gf.getSRID());
                List<Object> list2 = arg.getChildren();
                Intrinsics.checkNotNull(list2);
                Collection $this$toTypedArray$iv = list2;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
                Intrinsics.checkNotNull((Object)objectArray, (String)"null cannot be cast to non-null type kotlin.Array<org.locationtech.jts.geom.Point>");
                Point[] pts = (Point[])objectArray;
                MultiPoint mp = gf.createMultiPoint(pts);
                if (mp.getSRID() != srid) {
                    mp.setSRID(srid);
                }
                return mp;
            }
        });
        String string7 = "MultiLineString".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toLowerCase(...)");
        strats.put(string7, new ParseStrategy(){

            public Object parse(GMLHandler.Handler arg, GeometryFactory gf) throws SAXException {
                Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
                Intrinsics.checkNotNullParameter((Object)gf, (String)"gf");
                List<Object> list = arg.getChildren();
                Intrinsics.checkNotNull(list);
                if (list.size() < 1) {
                    throw new SAXException("Cannot create a multi-linestring without atleast one linestring");
                }
                Attributes attributes = arg.getAttrs();
                Intrinsics.checkNotNull((Object)attributes);
                int srid = GeometryStrategies.INSTANCE.getSrid(attributes, gf.getSRID());
                List<Object> list2 = arg.getChildren();
                Intrinsics.checkNotNull(list2);
                Collection $this$toTypedArray$iv = list2;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
                Intrinsics.checkNotNull((Object)objectArray, (String)"null cannot be cast to non-null type kotlin.Array<org.locationtech.jts.geom.LineString>");
                LineString[] lns = (LineString[])objectArray;
                MultiLineString mp = gf.createMultiLineString(lns);
                if (mp.getSRID() != srid) {
                    mp.setSRID(srid);
                }
                return mp;
            }
        });
        String string8 = "MultiPolygon".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toLowerCase(...)");
        strats.put(string8, new ParseStrategy(){

            public Object parse(GMLHandler.Handler arg, GeometryFactory gf) throws SAXException {
                Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
                Intrinsics.checkNotNullParameter((Object)gf, (String)"gf");
                List<Object> list = arg.getChildren();
                Intrinsics.checkNotNull(list);
                if (list.size() < 1) {
                    throw new SAXException("Cannot create a multi-polygon without atleast one polygon");
                }
                Attributes attributes = arg.getAttrs();
                Intrinsics.checkNotNull((Object)attributes);
                int srid = GeometryStrategies.INSTANCE.getSrid(attributes, gf.getSRID());
                List<Object> list2 = arg.getChildren();
                Intrinsics.checkNotNull(list2);
                Collection $this$toTypedArray$iv = list2;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
                Intrinsics.checkNotNull((Object)objectArray, (String)"null cannot be cast to non-null type kotlin.Array<org.locationtech.jts.geom.Polygon>");
                Polygon[] plys = (Polygon[])objectArray;
                MultiPolygon mp = gf.createMultiPolygon(plys);
                if (mp.getSRID() != srid) {
                    mp.setSRID(srid);
                }
                return mp;
            }
        });
        String string9 = "MultiGeometry".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"toLowerCase(...)");
        strats.put(string9, new ParseStrategy(){

            public Object parse(GMLHandler.Handler arg, GeometryFactory gf) throws SAXException {
                Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
                Intrinsics.checkNotNullParameter((Object)gf, (String)"gf");
                List<Object> list = arg.getChildren();
                Intrinsics.checkNotNull(list);
                if (list.size() < 1) {
                    throw new SAXException("Cannot create a multi-polygon without atleast one geometry");
                }
                List<Object> list2 = arg.getChildren();
                Intrinsics.checkNotNull(list2);
                Collection $this$toTypedArray$iv = list2;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
                Intrinsics.checkNotNull((Object)objectArray, (String)"null cannot be cast to non-null type kotlin.Array<org.locationtech.jts.geom.Geometry>");
                Geometry[] geoms = (Geometry[])objectArray;
                return gf.createGeometryCollection(geoms);
            }
        });
        String string10 = "coordinates".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"toLowerCase(...)");
        strats.put(string10, new ParseStrategy(){
            private final WeakHashMap<String, Pattern> patterns;
            {
                this.patterns = new WeakHashMap<K, V>();
            }

            /*
             * WARNING - void declaration
             */
            public Object parse(GMLHandler.Handler arg, GeometryFactory gf) throws SAXException {
                int i;
                void $this$trim$iv;
                block32: {
                    block31: {
                        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
                        Intrinsics.checkNotNullParameter((Object)gf, (String)"gf");
                        if (arg.getText() == null) break block31;
                        StringBuilder stringBuilder = arg.getText();
                        Intrinsics.checkNotNull((Object)stringBuilder);
                        if (stringBuilder.length() != 0) break block32;
                    }
                    throw new SAXException("Cannot create a coordinate sequence without text to parse");
                }
                String decimal = ".";
                String coordSeperator = ",";
                String toupleSeperator = " ";
                Attributes attributes = arg.getAttrs();
                Intrinsics.checkNotNull((Object)attributes);
                if (attributes.getIndex("decimal") >= 0) {
                    Attributes attributes2 = arg.getAttrs();
                    Intrinsics.checkNotNull((Object)attributes2);
                    String string = attributes2.getValue("decimal");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                    decimal = string;
                } else {
                    Attributes attributes3 = arg.getAttrs();
                    Intrinsics.checkNotNull((Object)attributes3);
                    if (attributes3.getIndex("http://www.opengis.net/gml", "decimal") >= 0) {
                        Attributes attributes4 = arg.getAttrs();
                        Intrinsics.checkNotNull((Object)attributes4);
                        String string = attributes4.getValue("http://www.opengis.net/gml", "decimal");
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                        decimal = string;
                    }
                }
                Attributes attributes5 = arg.getAttrs();
                Intrinsics.checkNotNull((Object)attributes5);
                if (attributes5.getIndex("cs") >= 0) {
                    Attributes attributes6 = arg.getAttrs();
                    Intrinsics.checkNotNull((Object)attributes6);
                    String string = attributes6.getValue("cs");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                    coordSeperator = string;
                } else {
                    Attributes attributes7 = arg.getAttrs();
                    Intrinsics.checkNotNull((Object)attributes7);
                    if (attributes7.getIndex("http://www.opengis.net/gml", "cs") >= 0) {
                        Attributes attributes8 = arg.getAttrs();
                        Intrinsics.checkNotNull((Object)attributes8);
                        String string = attributes8.getValue("http://www.opengis.net/gml", "cs");
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                        coordSeperator = string;
                    }
                }
                Attributes attributes9 = arg.getAttrs();
                Intrinsics.checkNotNull((Object)attributes9);
                if (attributes9.getIndex("ts") >= 0) {
                    Attributes attributes10 = arg.getAttrs();
                    Intrinsics.checkNotNull((Object)attributes10);
                    String string = attributes10.getValue("ts");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                    toupleSeperator = string;
                } else {
                    Attributes attributes11 = arg.getAttrs();
                    Intrinsics.checkNotNull((Object)attributes11);
                    if (attributes11.getIndex("http://www.opengis.net/gml", "ts") >= 0) {
                        Attributes attributes12 = arg.getAttrs();
                        Intrinsics.checkNotNull((Object)attributes12);
                        String string = attributes12.getValue("http://www.opengis.net/gml", "ts");
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                        toupleSeperator = string;
                    }
                }
                String t = String.valueOf(arg.getText());
                CharSequence charSequence = t;
                Regex regex = new Regex("\\s");
                String string = " ";
                t = regex.replace(charSequence, string);
                charSequence = t;
                regex = new Regex("\\s*,\\s*");
                string = ",";
                t = regex.replace(charSequence, string);
                Pattern pattern = this.patterns.get(toupleSeperator);
                Intrinsics.checkNotNull((Object)pattern, (String)"null cannot be cast to non-null type java.util.regex.Pattern");
                Pattern ptn = pattern;
                String string2 = t;
                Object object = ptn;
                int $i$f$trim = 0;
                CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                String[] stringArray = ((Pattern)object).split(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"split(...)");
                String[] touples = stringArray;
                if (touples.length == 0) {
                    throw new SAXException("Cannot create a coordinate sequence without a touple to parse");
                }
                int numNonNullTouples = 0;
                $i$f$trim = touples.length;
                for (i = 0; i < $i$f$trim; ++i) {
                    void $this$trim$iv2;
                    if (touples[i] == null) continue;
                    Intrinsics.checkNotNull((Object)touples[i]);
                    object = "";
                    $i$f$trim2 = false;
                    CharSequence $this$trim$iv$iv2 = (CharSequence)$this$trim$iv2;
                    boolean $i$f$trim3 = false;
                    int startIndex$iv$iv2 = 0;
                    int endIndex$iv$iv2 = $this$trim$iv$iv2.length() - 1;
                    boolean startFound$iv$iv2 = false;
                    while (startIndex$iv$iv2 <= endIndex$iv$iv2) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv2 ? startIndex$iv$iv2 : endIndex$iv$iv2;
                        char it = $this$trim$iv$iv2.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv2) {
                            if (!match$iv$iv) {
                                startFound$iv$iv2 = true;
                                continue;
                            }
                            ++startIndex$iv$iv2;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv2;
                    }
                    if (Intrinsics.areEqual((Object)object, (Object)((Object)$this$trim$iv$iv2.subSequence(startIndex$iv$iv2, endIndex$iv$iv2 + 1)).toString())) continue;
                    if (i != numNonNullTouples) {
                        touples[numNonNullTouples] = touples[i];
                    }
                    ++numNonNullTouples;
                }
                $i$f$trim = touples.length;
                for (i = numNonNullTouples; i < $i$f$trim; ++i) {
                    touples[i] = null;
                }
                if (numNonNullTouples == 0) {
                    throw new SAXException("Cannot create a coordinate sequence without a non-null touple to parse");
                }
                String string3 = touples[0];
                Intrinsics.checkNotNull((Object)string3);
                int dim = StringUtil.INSTANCE.split(string3, coordSeperator).length;
                CoordinateSequence cs = gf.getCoordinateSequenceFactory().create(numNonNullTouples, dim);
                dim = cs.getDimension();
                boolean replaceDec = !Intrinsics.areEqual((Object)".", (Object)decimal);
                int n = numNonNullTouples;
                for (int i2 = 0; i2 < n; ++i2) {
                    String[] coords;
                    Intrinsics.checkNotNull((Object)this.patterns.get(coordSeperator), (String)"null cannot be cast to non-null type java.util.regex.Pattern");
                    Intrinsics.checkNotNullExpressionValue((Object)ptn.split(touples[i2]), (String)"split(...)");
                    int dimIndex = 0;
                    for (int j = 0; j < coords.length && j < dim; ++j) {
                        String string4;
                        void $this$trim$iv3;
                        if (coords[j] == null) continue;
                        Intrinsics.checkNotNull((Object)coords[j]);
                        object = "";
                        boolean $i$f$trim4 = false;
                        CharSequence $this$trim$iv$iv3 = (CharSequence)$this$trim$iv3;
                        boolean $i$f$trim5 = false;
                        int startIndex$iv$iv3 = 0;
                        int endIndex$iv$iv3 = $this$trim$iv$iv3.length() - 1;
                        boolean startFound$iv$iv3 = false;
                        while (startIndex$iv$iv3 <= endIndex$iv$iv3) {
                            boolean match$iv$iv;
                            int index$iv$iv = !startFound$iv$iv3 ? startIndex$iv$iv3 : endIndex$iv$iv3;
                            char it = $this$trim$iv$iv3.charAt(index$iv$iv);
                            boolean bl = false;
                            boolean bl4 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                            if (!startFound$iv$iv3) {
                                if (!match$iv$iv) {
                                    startFound$iv$iv3 = true;
                                    continue;
                                }
                                ++startIndex$iv$iv3;
                                continue;
                            }
                            if (!match$iv$iv) break;
                            --endIndex$iv$iv3;
                        }
                        if (Intrinsics.areEqual((Object)object, (Object)((Object)$this$trim$iv$iv3.subSequence(startIndex$iv$iv3, endIndex$iv$iv3 + 1)).toString())) continue;
                        if (replaceDec) {
                            String string5 = coords[j];
                            Intrinsics.checkNotNull((Object)string5);
                            CharSequence charSequence2 = string5;
                            Regex regex2 = new Regex(decimal);
                            String string6 = ".";
                            string4 = regex2.replace(charSequence2, string6);
                        } else {
                            string4 = coords[j];
                        }
                        Intrinsics.checkNotNull((Object)string4);
                        double ordinate = Double.parseDouble(string4);
                        cs.setOrdinate(i2, dimIndex++, ordinate);
                    }
                    while (dimIndex < dim) {
                        cs.setOrdinate(i2, dimIndex++, Double.NaN);
                    }
                }
                return cs;
            }
        });
        String string11 = "coord".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"toLowerCase(...)");
        strats.put(string11, new ParseStrategy(){

            public Object parse(GMLHandler.Handler arg, GeometryFactory gf) throws SAXException {
                Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
                Intrinsics.checkNotNullParameter((Object)gf, (String)"gf");
                List<Object> list = arg.getChildren();
                Intrinsics.checkNotNull(list);
                if (list.size() < 1) {
                    throw new SAXException("Cannot create a coordinate without atleast one axis");
                }
                List<Object> list2 = arg.getChildren();
                Intrinsics.checkNotNull(list2);
                if (list2.size() > 3) {
                    throw new SAXException("Cannot create a coordinate with more than 3 axis");
                }
                List<Object> list3 = arg.getChildren();
                Intrinsics.checkNotNull(list3);
                Collection $this$toTypedArray$iv = list3;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
                Intrinsics.checkNotNull((Object)objectArray, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Double>");
                Double[] axis = (Double[])objectArray;
                Coordinate c = new Coordinate();
                c.x = axis[0];
                if (axis.length > 1) {
                    c.y = axis[1];
                }
                if (axis.length > 2) {
                    c.setZ(axis[2]);
                }
                return c;
            }
        });
        ParseStrategy coord_child2 = new ParseStrategy(){

            public Object parse(GMLHandler.Handler arg, GeometryFactory gf) throws SAXException {
                Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
                Intrinsics.checkNotNullParameter((Object)gf, (String)"gf");
                return arg.getText() == null ? null : Double.valueOf(String.valueOf(arg.getText()));
            }
        };
        String string12 = "X".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"toLowerCase(...)");
        strats.put(string12, coord_child2);
        String string13 = "Y".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"toLowerCase(...)");
        strats.put(string13, coord_child2);
        String string14 = "Z".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"toLowerCase(...)");
        strats.put(string14, coord_child2);
        ParseStrategy member2 = new ParseStrategy(){

            public Object parse(GMLHandler.Handler arg, GeometryFactory gf) throws SAXException {
                Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
                Intrinsics.checkNotNullParameter((Object)gf, (String)"gf");
                List<Object> list = arg.getChildren();
                Intrinsics.checkNotNull(list);
                if (list.size() != 1) {
                    throw new SAXException("Geometry Members may only contain one geometry.");
                }
                List<Object> list2 = arg.getChildren();
                Intrinsics.checkNotNull(list2);
                return list2.get(0);
            }
        };
        String string15 = "outerBoundaryIs".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"toLowerCase(...)");
        strats.put(string15, member2);
        String string16 = "innerBoundaryIs".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string16, (String)"toLowerCase(...)");
        strats.put(string16, member2);
        String string17 = "pointMember".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string17, (String)"toLowerCase(...)");
        strats.put(string17, member2);
        String string18 = "lineStringMember".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string18, (String)"toLowerCase(...)");
        strats.put(string18, member2);
        String string19 = "polygonMember".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string19, (String)"toLowerCase(...)");
        strats.put(string19, member2);
        return strats;
    }

    public final int getSrid(@NotNull Attributes attrs, int defaultValue) {
        block12: {
            Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
            String srs = null;
            if (attrs.getIndex("srsName") >= 0) {
                srs = attrs.getValue("srsName");
            } else if (attrs.getIndex("http://www.opengis.net/gml", "srsName") >= 0) {
                srs = attrs.getValue("http://www.opengis.net/gml", "srsName");
            }
            if (srs != null) {
                String $this$trim$iv = srs;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if ((srs = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()) != null && !Intrinsics.areEqual((Object)"", (Object)srs)) {
                    try {
                        return Integer.parseInt(srs);
                    }
                    catch (NumberFormatException e) {
                        String srsNum = this.extractIntSuffix(srs);
                        if (srsNum == null) break block12;
                        try {
                            return Integer.parseInt(srsNum);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return defaultValue;
    }

    @NotNull
    public final Pattern getPATT_SUFFIX_INT() {
        return PATT_SUFFIX_INT;
    }

    public final void setPATT_SUFFIX_INT(@NotNull Pattern pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"<set-?>");
        PATT_SUFFIX_INT = pattern;
    }

    @Nullable
    public final String extractIntSuffix(@Nullable String s) {
        Matcher matcher = PATT_SUFFIX_INT.matcher(s);
        Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher(...)");
        Matcher matcher2 = matcher;
        return matcher2.find() ? matcher2.group(1) : null;
    }

    @Nullable
    public final ParseStrategy findStrategy(@Nullable String uri, @Nullable String localName) {
        ParseStrategy parseStrategy;
        String string = localName;
        if (string == null) {
            parseStrategy = null;
        } else {
            String string2 = string;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string3 = string2.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            parseStrategy = strategies.get(string3);
        }
        return parseStrategy;
    }

    static {
        Pattern pattern = Pattern.compile("(\\d+)$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        PATT_SUFFIX_INT = pattern;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a8\u0006\u0007\u00c0\u0006\u0003"}, d2={"Lorg/locationtech/jts/io/gml2/GeometryStrategies$ParseStrategy;", "", "parse", "arg", "Lorg/locationtech/jts/io/gml2/GMLHandler$Handler;", "gf", "Lorg/locationtech/jts/geom/GeometryFactory;", "kts-core"})
    public static interface ParseStrategy {
        @Nullable
        public Object parse(@NotNull GMLHandler.Handler var1, @NotNull GeometryFactory var2) throws SAXException;
    }
}

