/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io.kml;

import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.util.StringUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 >2\u00020\u0001:\u0001>B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005J\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u000bJ\u0010\u0010\u0016\u001a\u00020\u00112\b\u0010\r\u001a\u0004\u0018\u00010\u0005J\u000e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0007J\u000e\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eJ\u001a\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001b2\n\u0010\u001f\u001a\u00060 j\u0002`!J$\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u00072\n\u0010\u001f\u001a\u00060 j\u0002`!H\u0002J$\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u00072\n\u0010\u001f\u001a\u00060 j\u0002`!H\u0002J\u001a\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u00052\b\u0010)\u001a\u0004\u0018\u00010\u0005H\u0002J\u001c\u0010*\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u00072\n\u0010\u001f\u001a\u00060 j\u0002`!H\u0002J,\u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020-2\u0006\u0010)\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u00072\n\u0010\u001f\u001a\u00060 j\u0002`!H\u0002J,\u0010.\u001a\u00020\u00112\u0006\u0010/\u001a\u0002002\u0006\u0010)\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u00072\n\u0010\u001f\u001a\u00060 j\u0002`!H\u0002J8\u00101\u001a\u00020\u00112\b\u00102\u001a\u0004\u0018\u0001032\b\u0010)\u001a\u0004\u0018\u00010\u00052\u0006\u0010*\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u00072\n\u0010\u001f\u001a\u00060 j\u0002`!H\u0002J,\u00104\u001a\u00020\u00112\u0006\u0010,\u001a\u0002052\u0006\u0010)\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u00072\n\u0010\u001f\u001a\u00060 j\u0002`!H\u0002J,\u00106\u001a\u00020\u00112\u0006\u00107\u001a\u0002082\u0006\u0010)\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u00072\n\u0010\u001f\u001a\u00060 j\u0002`!H\u0002J/\u0010\u0019\u001a\u00020\u00112\f\u00109\u001a\b\u0012\u0004\u0012\u00020;0:2\u0006\u0010$\u001a\u00020\u00072\n\u0010\u001f\u001a\u00060 j\u0002`!H\u0002\u00a2\u0006\u0002\u0010<J\u001c\u0010\u0019\u001a\u00020\u00112\u0006\u0010,\u001a\u00020;2\n\u0010\u001f\u001a\u00060 j\u0002`!H\u0002J\u001c\u0010\u0019\u001a\u00020\u00112\u0006\u0010=\u001a\u00020\t2\n\u0010\u001f\u001a\u00060 j\u0002`!H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lorg/locationtech/jts/io/kml/KMLWriter;", "", "<init>", "()V", "linePrefix", "", "maxCoordinatesPerLine", "", "zVal", "", "extrude", "", "tesselate", "altitudeMode", "numberFormatter", "Ljava/text/DecimalFormat;", "setLinePrefix", "", "setMaximumCoordinatesPerLine", "setZ", "setExtrude", "setTesselate", "setAltitudeMode", "setPrecision", "precision", "write", "geom", "Lorg/locationtech/jts/geom/Geometry;", "geometry", "writer", "Ljava/io/Writer;", "buf", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "writeGeometry", "g", "level", "startLine", "text", "geometryTag", "geometryName", "attributes", "writeModifiers", "writePoint", "p", "Lorg/locationtech/jts/geom/Point;", "writeLineString", "ls", "Lorg/locationtech/jts/geom/LineString;", "writeLinearRing", "lr", "Lorg/locationtech/jts/geom/LinearRing;", "writePolygon", "Lorg/locationtech/jts/geom/Polygon;", "writeGeometryCollection", "gc", "Lorg/locationtech/jts/geom/GeometryCollection;", "coords", "", "Lorg/locationtech/jts/geom/Coordinate;", "([Lorg/locationtech/jts/geom/Coordinate;ILjava/lang/StringBuilder;)V", "num", "Companion", "kts-core"})
public final class KMLWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String linePrefix;
    private int maxCoordinatesPerLine = 5;
    private double zVal = Double.NaN;
    private boolean extrude;
    private boolean tesselate;
    @Nullable
    private String altitudeMode;
    @Nullable
    private DecimalFormat numberFormatter;
    @NotNull
    private static String ALTITUDE_MODE_CLAMPTOGROUND = "clampToGround ";
    @NotNull
    private static String ALTITUDE_MODE_RELATIVETOGROUND = "relativeToGround  ";
    @JvmField
    @NotNull
    public static String ALTITUDE_MODE_ABSOLUTE = "absolute";
    private static final int INDENT_SIZE = 2;
    @NotNull
    private static final String COORDINATE_SEPARATOR = ",";
    @NotNull
    private static final String TUPLE_SEPARATOR = " ";

    public final void setLinePrefix(@Nullable String linePrefix) {
        this.linePrefix = linePrefix;
    }

    public final void setMaximumCoordinatesPerLine(int maxCoordinatesPerLine) {
        int maxCoordinatesPerLine2 = maxCoordinatesPerLine;
        if (maxCoordinatesPerLine2 <= 0) {
            maxCoordinatesPerLine2 = 1;
            return;
        }
        this.maxCoordinatesPerLine = maxCoordinatesPerLine2;
    }

    public final void setZ(double zVal) {
        this.zVal = zVal;
    }

    public final void setExtrude(boolean extrude) {
        this.extrude = extrude;
    }

    public final void setTesselate(boolean tesselate) {
        this.tesselate = tesselate;
    }

    public final void setAltitudeMode(@Nullable String altitudeMode) {
        this.altitudeMode = altitudeMode;
    }

    public final void setPrecision(int precision) {
        if (precision >= 0) {
            this.numberFormatter = KMLWriter.Companion.createFormatter(precision);
        }
    }

    @NotNull
    public final String write(@NotNull Geometry geom) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        StringBuilder buf = new StringBuilder();
        this.write(geom, buf);
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final void write(@NotNull Geometry geometry, @NotNull Writer writer) throws IOException {
        Intrinsics.checkNotNullParameter((Object)geometry, (String)"geometry");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        writer.write(this.write(geometry));
    }

    public final void write(@NotNull Geometry geometry, @NotNull StringBuilder buf) {
        Intrinsics.checkNotNullParameter((Object)geometry, (String)"geometry");
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        this.writeGeometry(geometry, 0, buf);
    }

    private final void writeGeometry(Geometry g, int level, StringBuilder buf) {
        String attributes = "";
        if (g instanceof Point) {
            this.writePoint((Point)g, attributes, level, buf);
        } else if (g instanceof LinearRing) {
            this.writeLinearRing((LinearRing)g, attributes, true, level, buf);
        } else if (g instanceof LineString) {
            this.writeLineString((LineString)g, attributes, level, buf);
        } else if (g instanceof Polygon) {
            this.writePolygon((Polygon)g, attributes, level, buf);
        } else if (g instanceof GeometryCollection) {
            this.writeGeometryCollection((GeometryCollection)g, attributes, level, buf);
        } else {
            throw new IllegalArgumentException("Geometry type not supported: " + g.getGeometryType());
        }
    }

    private final void startLine(String text, int level, StringBuilder buf) {
        if (this.linePrefix != null) {
            buf.append(this.linePrefix);
        }
        buf.append(StringUtil.INSTANCE.spaces(2 * level));
        buf.append(text);
    }

    private final String geometryTag(String geometryName, String attributes) {
        StringBuilder buf = new StringBuilder();
        buf.append("<");
        buf.append(geometryName);
        if (attributes != null && attributes.length() > 0) {
            buf.append(TUPLE_SEPARATOR);
            buf.append(attributes);
        }
        buf.append(">");
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void writeModifiers(int level, StringBuilder buf) {
        if (this.extrude) {
            this.startLine("<extrude>1</extrude>\n", level, buf);
        }
        if (this.tesselate) {
            this.startLine("<tesselate>1</tesselate>\n", level, buf);
        }
        if (this.altitudeMode != null) {
            this.startLine("<altitudeMode>" + this.altitudeMode + "</altitudeMode>\n", level, buf);
        }
    }

    private final void writePoint(Point p, String attributes, int level, StringBuilder buf) {
        this.startLine(StringsKt.trimIndent((String)("\n    " + this.geometryTag("Point", attributes) + "\n    \n    ")), level, buf);
        this.writeModifiers(level, buf);
        Coordinate[] coordinateArray = new Coordinate[1];
        Intrinsics.checkNotNull((Object)p.getCoordinate());
        this.write(coordinateArray, level + 1, buf);
        this.startLine("</Point>\n", level, buf);
    }

    private final void writeLineString(LineString ls, String attributes, int level, StringBuilder buf) {
        this.startLine(StringsKt.trimIndent((String)("\n    " + this.geometryTag("LineString", attributes) + "\n    \n    ")), level, buf);
        this.writeModifiers(level, buf);
        this.write(ls.getCoordinates(), level + 1, buf);
        this.startLine("</LineString>\n", level, buf);
    }

    private final void writeLinearRing(LinearRing lr, String attributes, boolean writeModifiers, int level, StringBuilder buf) {
        this.startLine(StringsKt.trimIndent((String)("\n    " + this.geometryTag("LinearRing", attributes) + "\n    \n    ")), level, buf);
        if (writeModifiers) {
            this.writeModifiers(level, buf);
        }
        LinearRing linearRing = lr;
        Intrinsics.checkNotNull((Object)linearRing);
        this.write(linearRing.getCoordinates(), level + 1, buf);
        this.startLine("</LinearRing>\n", level, buf);
    }

    private final void writePolygon(Polygon p, String attributes, int level, StringBuilder buf) {
        this.startLine(StringsKt.trimIndent((String)("\n    " + this.geometryTag("Polygon", attributes) + "\n    \n    ")), level, buf);
        this.writeModifiers(level, buf);
        this.startLine("  <outerBoundaryIs>\n", level, buf);
        this.writeLinearRing(p.getExteriorRing(), null, false, level + 1, buf);
        this.startLine("  </outerBoundaryIs>\n", level, buf);
        int n = p.getNumInteriorRing();
        for (int t = 0; t < n; ++t) {
            this.startLine("  <innerBoundaryIs>\n", level, buf);
            this.writeLinearRing(p.getInteriorRingN(t), null, false, level + 1, buf);
            this.startLine("  </innerBoundaryIs>\n", level, buf);
        }
        this.startLine("</Polygon>\n", level, buf);
    }

    private final void writeGeometryCollection(GeometryCollection gc, String attributes, int level, StringBuilder buf) {
        this.startLine("<MultiGeometry>\n", level, buf);
        int n = gc.getNumGeometries();
        for (int t = 0; t < n; ++t) {
            this.writeGeometry(gc.getGeometryN(t), level + 1, buf);
        }
        this.startLine("</MultiGeometry>\n", level, buf);
    }

    private final void write(Coordinate[] coords, int level, StringBuilder buf) {
        this.startLine("<coordinates>", level, buf);
        boolean isNewLine = false;
        int n = coords.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                buf.append(TUPLE_SEPARATOR);
            }
            if (isNewLine) {
                this.startLine("  ", level, buf);
                isNewLine = false;
            }
            this.write(coords[i], buf);
            if ((i + 1) % this.maxCoordinatesPerLine != 0 || i >= coords.length - 1) continue;
            buf.append("\n");
            isNewLine = true;
        }
        buf.append("</coordinates>\n");
    }

    private final void write(Coordinate p, StringBuilder buf) {
        this.write(p.x, buf);
        buf.append(COORDINATE_SEPARATOR);
        this.write(p.y, buf);
        double z = p.getZ();
        if (!Math.INSTANCE.isNaN(this.zVal)) {
            z = this.zVal;
        }
        if (!Math.INSTANCE.isNaN(z)) {
            buf.append(COORDINATE_SEPARATOR);
            this.write(z, buf);
        }
    }

    private final void write(double num, StringBuilder buf) {
        if (this.numberFormatter != null) {
            DecimalFormat decimalFormat = this.numberFormatter;
            Intrinsics.checkNotNull((Object)decimalFormat);
            v1 = buf.append(decimalFormat.format(num));
        } else {
            v1 = buf.append(num);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J0\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u0012\u0010\r\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/locationtech/jts/io/kml/KMLWriter$Companion;", "", "<init>", "()V", "ALTITUDE_MODE_CLAMPTOGROUND", "", "getALTITUDE_MODE_CLAMPTOGROUND", "()Ljava/lang/String;", "setALTITUDE_MODE_CLAMPTOGROUND", "(Ljava/lang/String;)V", "ALTITUDE_MODE_RELATIVETOGROUND", "getALTITUDE_MODE_RELATIVETOGROUND", "setALTITUDE_MODE_RELATIVETOGROUND", "ALTITUDE_MODE_ABSOLUTE", "writeGeometry", "geometry", "Lorg/locationtech/jts/geom/Geometry;", "z", "", "precision", "", "extrude", "", "altitudeMode", "INDENT_SIZE", "COORDINATE_SEPARATOR", "TUPLE_SEPARATOR", "createFormatter", "Ljava/text/DecimalFormat;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getALTITUDE_MODE_CLAMPTOGROUND() {
            return ALTITUDE_MODE_CLAMPTOGROUND;
        }

        public final void setALTITUDE_MODE_CLAMPTOGROUND(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            ALTITUDE_MODE_CLAMPTOGROUND = string;
        }

        @NotNull
        public final String getALTITUDE_MODE_RELATIVETOGROUND() {
            return ALTITUDE_MODE_RELATIVETOGROUND;
        }

        public final void setALTITUDE_MODE_RELATIVETOGROUND(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            ALTITUDE_MODE_RELATIVETOGROUND = string;
        }

        @NotNull
        public final String writeGeometry(@NotNull Geometry geometry, double z) {
            Intrinsics.checkNotNullParameter((Object)geometry, (String)"geometry");
            KMLWriter writer = new KMLWriter();
            writer.setZ(z);
            return writer.write(geometry);
        }

        @NotNull
        public final String writeGeometry(@NotNull Geometry geometry, double z, int precision, boolean extrude, @Nullable String altitudeMode) {
            Intrinsics.checkNotNullParameter((Object)geometry, (String)"geometry");
            KMLWriter writer = new KMLWriter();
            writer.setZ(z);
            writer.setPrecision(precision);
            writer.setExtrude(extrude);
            writer.setAltitudeMode(altitudeMode);
            return writer.write(geometry);
        }

        private final DecimalFormat createFormatter(int precision) {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols();
            symbols.setDecimalSeparator('.');
            DecimalFormat format = new DecimalFormat("0." + StringUtil.INSTANCE.chars('#', precision), symbols);
            format.setDecimalSeparatorAlwaysShown(false);
            return format;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

