/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.linearref;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.linearref.LinearIterator;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0007J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J \u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/locationtech/jts/linearref/LengthIndexOfPoint;", "", "linearGeom", "Lorg/locationtech/jts/geom/Geometry;", "<init>", "(Lorg/locationtech/jts/geom/Geometry;)V", "indexOf", "", "inputPt", "Lorg/locationtech/jts/geom/Coordinate;", "indexOfAfter", "minIndex", "indexOfFromStart", "segmentNearestMeasure", "seg", "Lorg/locationtech/jts/geom/LineSegment;", "segmentStartMeasure", "Companion", "kts-core"})
public final class LengthIndexOfPoint {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Geometry linearGeom;

    public LengthIndexOfPoint(@NotNull Geometry linearGeom) {
        Intrinsics.checkNotNullParameter((Object)linearGeom, (String)"linearGeom");
        this.linearGeom = linearGeom;
    }

    public final double indexOf(@NotNull Coordinate inputPt) {
        Intrinsics.checkNotNullParameter((Object)inputPt, (String)"inputPt");
        return this.indexOfFromStart(inputPt, -1.0);
    }

    public final double indexOfAfter(@NotNull Coordinate inputPt, double minIndex) {
        Intrinsics.checkNotNullParameter((Object)inputPt, (String)"inputPt");
        if (minIndex < 0.0) {
            return this.indexOf(inputPt);
        }
        double endIndex = this.linearGeom.getLength();
        if (endIndex < minIndex) {
            return endIndex;
        }
        double closestAfter = this.indexOfFromStart(inputPt, minIndex);
        Assert.INSTANCE.isTrue(closestAfter >= minIndex, "computed index is before specified minimum index");
        return closestAfter;
    }

    private final double indexOfFromStart(Coordinate inputPt, double minIndex) {
        double minDistance = Double.MAX_VALUE;
        double ptMeasure = minIndex;
        double segmentStartMeasure = 0.0;
        LineSegment seg = new LineSegment(null, null, 3, null);
        LinearIterator it = new LinearIterator(this.linearGeom);
        while (it.hasNext()) {
            if (!it.isEndOfLine()) {
                seg.p0 = it.getSegmentStart();
                Intrinsics.checkNotNull((Object)it.getSegmentEnd());
                seg.p1 = seg.p1;
                double segDistance = seg.distance(inputPt);
                double segMeasureToPt = this.segmentNearestMeasure(seg, inputPt, segmentStartMeasure);
                if (segDistance < minDistance && segMeasureToPt > minIndex) {
                    ptMeasure = segMeasureToPt;
                    minDistance = segDistance;
                }
                segmentStartMeasure += seg.getLength();
            }
            it.next();
        }
        return ptMeasure;
    }

    private final double segmentNearestMeasure(LineSegment seg, Coordinate inputPt, double segmentStartMeasure) {
        double projFactor = seg.projectionFactor(inputPt);
        if (projFactor <= 0.0) {
            return segmentStartMeasure;
        }
        return projFactor <= 1.0 ? segmentStartMeasure + projFactor * seg.getLength() : segmentStartMeasure + seg.getLength();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0005\u00a8\u0006\f"}, d2={"Lorg/locationtech/jts/linearref/LengthIndexOfPoint$Companion;", "", "<init>", "()V", "indexOf", "", "linearGeom", "Lorg/locationtech/jts/geom/Geometry;", "inputPt", "Lorg/locationtech/jts/geom/Coordinate;", "indexOfAfter", "minIndex", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final double indexOf(@NotNull Geometry linearGeom, @NotNull Coordinate inputPt) {
            Intrinsics.checkNotNullParameter((Object)linearGeom, (String)"linearGeom");
            Intrinsics.checkNotNullParameter((Object)inputPt, (String)"inputPt");
            LengthIndexOfPoint locater = new LengthIndexOfPoint(linearGeom);
            return locater.indexOf(inputPt);
        }

        public final double indexOfAfter(@NotNull Geometry linearGeom, @NotNull Coordinate inputPt, double minIndex) {
            Intrinsics.checkNotNullParameter((Object)linearGeom, (String)"linearGeom");
            Intrinsics.checkNotNullParameter((Object)inputPt, (String)"inputPt");
            LengthIndexOfPoint locater = new LengthIndexOfPoint(linearGeom);
            return locater.indexOfAfter(inputPt, minIndex);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

