/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.linearref;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Lineal;
import org.locationtech.jts.linearref.LinearLocation;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 $2\u00020\u0001:\u0001$B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\nB\u0019\b\u0016\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\u0007\u0010\rJ\b\u0010\u0017\u001a\u00020\u0018H\u0002J\t\u0010\u0019\u001a\u00020\u001aH\u0086\u0002J\t\u0010\u001b\u001a\u00020\u0018H\u0086\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u001c\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0013\u0010\"\u001a\u0004\u0018\u00010\u001f8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010!\u00a8\u0006%"}, d2={"Lorg/locationtech/jts/linearref/LinearIterator;", "", "linearGeom", "Lorg/locationtech/jts/geom/Geometry;", "componentIndex", "", "vertexIndex", "<init>", "(Lorg/locationtech/jts/geom/Geometry;II)V", "linear", "(Lorg/locationtech/jts/geom/Geometry;)V", "start", "Lorg/locationtech/jts/linearref/LinearLocation;", "(Lorg/locationtech/jts/geom/Geometry;Lorg/locationtech/jts/linearref/LinearLocation;)V", "numLines", "value", "Lorg/locationtech/jts/geom/LineString;", "line", "getLine", "()Lorg/locationtech/jts/geom/LineString;", "getComponentIndex", "()I", "getVertexIndex", "loadCurrentLine", "", "hasNext", "", "next", "isEndOfLine", "()Z", "segmentStart", "Lorg/locationtech/jts/geom/Coordinate;", "getSegmentStart", "()Lorg/locationtech/jts/geom/Coordinate;", "segmentEnd", "getSegmentEnd", "Companion", "kts-core"})
public final class LinearIterator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Geometry linearGeom;
    private final int numLines;
    @Nullable
    private LineString line;
    private int componentIndex;
    private int vertexIndex;

    public LinearIterator(@NotNull Geometry linearGeom, int componentIndex, int vertexIndex) {
        Intrinsics.checkNotNullParameter((Object)linearGeom, (String)"linearGeom");
        if (!(linearGeom instanceof Lineal)) {
            throw new IllegalArgumentException("Lineal geometry is required");
        }
        this.linearGeom = linearGeom;
        this.numLines = linearGeom.getNumGeometries();
        this.componentIndex = componentIndex;
        this.vertexIndex = vertexIndex;
        this.loadCurrentLine();
    }

    @Nullable
    public final LineString getLine() {
        return this.line;
    }

    public final int getComponentIndex() {
        return this.componentIndex;
    }

    public final int getVertexIndex() {
        return this.vertexIndex;
    }

    public LinearIterator(@NotNull Geometry linear) {
        Intrinsics.checkNotNullParameter((Object)linear, (String)"linear");
        this(linear, 0, 0);
    }

    public LinearIterator(@NotNull Geometry linear, @NotNull LinearLocation start) {
        Intrinsics.checkNotNullParameter((Object)linear, (String)"linear");
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        this(linear, start.getComponentIndex(), LinearIterator.Companion.segmentEndVertexIndex(start));
    }

    private final void loadCurrentLine() {
        if (this.componentIndex >= this.numLines) {
            this.line = null;
            return;
        }
        Geometry geometry = this.linearGeom.getGeometryN(this.componentIndex);
        Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
        this.line = (LineString)geometry;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasNext() {
        if (this.componentIndex >= this.numLines) {
            return false;
        }
        if (this.componentIndex != this.numLines - 1) return true;
        LineString lineString = this.line;
        Intrinsics.checkNotNull((Object)lineString);
        if (this.vertexIndex >= lineString.getNumPoints()) return false;
        return true;
    }

    public final void next() {
        if (!this.hasNext()) {
            return;
        }
        int n = this.vertexIndex;
        this.vertexIndex = n + 1;
        LineString lineString = this.line;
        Intrinsics.checkNotNull((Object)lineString);
        if (this.vertexIndex >= lineString.getNumPoints()) {
            n = this.componentIndex;
            this.componentIndex = n + 1;
            this.loadCurrentLine();
            this.vertexIndex = 0;
        }
    }

    public final boolean isEndOfLine() {
        if (this.componentIndex >= this.numLines) {
            return false;
        }
        LineString lineString = this.line;
        Intrinsics.checkNotNull((Object)lineString);
        return this.vertexIndex >= lineString.getNumPoints() - 1;
    }

    @NotNull
    public final Coordinate getSegmentStart() {
        LineString lineString = this.line;
        Intrinsics.checkNotNull((Object)lineString);
        return lineString.getCoordinateN(this.vertexIndex);
    }

    @Nullable
    public final Coordinate getSegmentEnd() {
        Coordinate coordinate;
        LineString lineString = this.line;
        Intrinsics.checkNotNull((Object)lineString);
        if (this.vertexIndex < lineString.getNumPoints() - 1) {
            LineString lineString2 = this.line;
            Intrinsics.checkNotNull((Object)lineString2);
            coordinate = lineString2.getCoordinateN(this.vertexIndex + 1);
        } else {
            coordinate = null;
        }
        return coordinate;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lorg/locationtech/jts/linearref/LinearIterator$Companion;", "", "<init>", "()V", "segmentEndVertexIndex", "", "loc", "Lorg/locationtech/jts/linearref/LinearLocation;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        private final int segmentEndVertexIndex(LinearLocation loc) {
            return loc.getSegmentFraction() > 0.0 ? loc.getSegmentIndex() + 1 : loc.getSegmentIndex();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

