/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.math;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0016\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005J\u001e\u0010\u0004\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tJ\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u0016\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005J\u001e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005J&\u0010\b\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005J&\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005J\u001a\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00052\b\b\u0002\u0010\u001e\u001a\u00020\u0005H\u0007R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001f"}, d2={"Lorg/locationtech/jts/math/MathUtil;", "", "<init>", "()V", "clamp", "", "x", "min", "max", "", "clampMax", "ceil", "num", "denom", "LOG_10", "log10", "wrap", "index", "average", "x1", "x2", "v1", "v2", "v3", "v4", "PHI_INV", "getPHI_INV", "()D", "quasirandom", "curr", "alpha", "kts-core"})
public final class MathUtil {
    @NotNull
    public static final MathUtil INSTANCE = new MathUtil();
    private static final double LOG_10 = Math.INSTANCE.log(10.0);
    private static final double PHI_INV = (Math.INSTANCE.sqrt(5.0) - 1.0) / 2.0;

    private MathUtil() {
    }

    public final double clamp(double x, double min, double max) {
        if (x < min) {
            return min;
        }
        return x > max ? max : x;
    }

    public final int clamp(int x, int min, int max) {
        if (x < min) {
            return min;
        }
        return x > max ? max : x;
    }

    public final int clampMax(int x, int max) {
        return x > max ? max : x;
    }

    public final int ceil(int num, int denom) {
        int div = num / denom;
        return div * denom >= num ? div : div + 1;
    }

    public final double log10(double x) {
        double ln = Math.INSTANCE.log(x);
        if (Math.INSTANCE.isInfinite(ln)) {
            return ln;
        }
        return Math.INSTANCE.isNaN(ln) ? ln : ln / LOG_10;
    }

    public final int wrap(int index, int max) {
        return index < 0 ? max - -index % max : index % max;
    }

    public final double average(double x1, double x2) {
        return (x1 + x2) / 2.0;
    }

    public final double max(double v1, double v2, double v3) {
        double max = v1;
        if (v2 > max) {
            max = v2;
        }
        if (v3 > max) {
            max = v3;
        }
        return max;
    }

    public final double max(double v1, double v2, double v3, double v4) {
        double max = v1;
        if (v2 > max) {
            max = v2;
        }
        if (v3 > max) {
            max = v3;
        }
        if (v4 > max) {
            max = v4;
        }
        return max;
    }

    public final double min(double v1, double v2, double v3, double v4) {
        double min = v1;
        if (v2 < min) {
            min = v2;
        }
        if (v3 < min) {
            min = v3;
        }
        if (v4 < min) {
            min = v4;
        }
        return min;
    }

    public final double getPHI_INV() {
        return PHI_INV;
    }

    @JvmOverloads
    public final double quasirandom(double curr, double alpha) {
        double next = curr + alpha;
        return next < 1.0 ? next : next - Math.INSTANCE.floor(next);
    }

    public static /* synthetic */ double quasirandom$default(MathUtil mathUtil, double d, double d2, int n, Object object) {
        if ((n & 2) != 0) {
            d2 = PHI_INV;
        }
        return mathUtil.quasirandom(d, d2);
    }

    @JvmOverloads
    public final double quasirandom(double curr) {
        return MathUtil.quasirandom$default(this, curr, 0.0, 2, null);
    }
}

