/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.math;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\fJ \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J#\u0010\r\u001a\u0004\u0018\u00010\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000f\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/locationtech/jts/math/Matrix;", "", "<init>", "()V", "swapRows", "", "m", "", "", "i", "", "j", "([[DII)V", "solve", "a", "b", "([[D[D)[D", "kts-core"})
@SourceDebugExtension(value={"SMAP\nMatrix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Matrix.kt\norg/locationtech/jts/math/Matrix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1#2:88\n*E\n"})
public final class Matrix {
    @NotNull
    public static final Matrix INSTANCE = new Matrix();

    private Matrix() {
    }

    private final void swapRows(double[][] m, int i, int j) {
        if (i == j) {
            return;
        }
        int n = m[0].length;
        for (int col = 0; col < n; ++col) {
            double temp = m[i][col];
            m[i][col] = m[j][col];
            m[j][col] = temp;
        }
    }

    private final void swapRows(double[] m, int i, int j) {
        if (i == j) {
            return;
        }
        double temp = m[i];
        m[i] = m[j];
        m[j] = temp;
    }

    @Nullable
    public final double[] solve(@NotNull double[][] a, @NotNull double[] b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int n = b.length;
        if (!(((Object[])a).length == n && a[0].length == n)) {
            boolean $i$a$-require-Matrix$solve$22 = false;
            String $i$a$-require-Matrix$solve$22 = "Matrix A is incorrectly sized";
            throw new IllegalArgumentException($i$a$-require-Matrix$solve$22.toString());
        }
        for (int i = 0; i < n; ++i) {
            int j;
            int maxElementRow = i;
            for (j = i + 1; j < n; ++j) {
                if (!(Math.INSTANCE.abs(a[j][i]) > Math.INSTANCE.abs(a[maxElementRow][i]))) continue;
                maxElementRow = j;
            }
            if (a[maxElementRow][i] == 0.0) {
                return null;
            }
            this.swapRows(a, i, maxElementRow);
            this.swapRows(b, i, maxElementRow);
            j = i + 1;
            while (j < n) {
                double rowFactor = a[j][i] / a[i][i];
                int k = n - 1;
                if (i <= k) {
                    do {
                        double[] dArray = a[j];
                        int n2 = --k;
                        dArray[n2] = dArray[n2] - a[i][k] * rowFactor;
                    } while (k != i);
                }
                int n3 = j++;
                b[n3] = b[n3] - b[i] * rowFactor;
            }
        }
        double[] solution = new double[n];
        for (int j = n - 1; -1 < j; --j) {
            double t = 0.0;
            for (int k = j + 1; k < n; ++k) {
                t += a[j][k] * solution[k];
            }
            solution[j] = (b[j] - t) / a[j][j];
        }
        return solution;
    }
}

