/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.math;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.Angle;
import org.locationtech.jts.algorithm.CGAlgorithmsDD;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.legacy.Cloneable;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 42\u00020\u0001:\u00014B\u001d\b\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0005\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0005\u0010\fB\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\n\u00a2\u0006\u0004\b\u0005\u0010\rJ\u000e\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0000J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0000J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0003J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0003J\u0006\u0010\u001a\u001a\u00020\u0000J\u0006\u0010\u001b\u001a\u00020\u0003J\u0006\u0010\u001c\u001a\u00020\u0003J\u0006\u0010\u001d\u001a\u00020\u0000J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0000J\u0016\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0003J\u000e\u0010!\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0000J\u000e\u0010\"\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0000J\u0006\u0010#\u001a\u00020\u0003J\u000e\u0010#\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0000J\u000e\u0010$\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0000J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0003J\u0010\u0010&\u001a\u0004\u0018\u00010\u00002\u0006\u0010'\u001a\u00020\u0014J\u000e\u0010(\u001a\u00020)2\u0006\u0010\u0007\u001a\u00020\u0000J\u000e\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\nJ\u0006\u0010,\u001a\u00020\nJ\b\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u000200H\u0016J\u0013\u00101\u001a\u00020)2\b\u00102\u001a\u0004\u0018\u00010.H\u0096\u0002J\b\u00103\u001a\u00020\u0014H\u0016R\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u00065"}, d2={"Lorg/locationtech/jts/math/Vector2D;", "Lorg/locationtech/jts/legacy/Cloneable;", "x", "", "y", "<init>", "(DD)V", "v", "(Lorg/locationtech/jts/math/Vector2D;)V", "from", "Lorg/locationtech/jts/geom/Coordinate;", "to", "(Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;)V", "(Lorg/locationtech/jts/geom/Coordinate;)V", "value", "getX", "()D", "getY", "getComponent", "index", "", "add", "subtract", "multiply", "d", "divide", "negate", "length", "lengthSquared", "normalize", "average", "weightedSum", "frac", "distance", "dot", "angle", "angleTo", "rotate", "rotateByQuarterCircle", "numQuarters", "isParallel", "", "translate", "coord", "toCoordinate", "clone", "", "toString", "", "equals", "o", "hashCode", "Companion", "kts-core"})
public final class Vector2D
implements Cloneable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double x;
    private double y;

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    @JvmOverloads
    public Vector2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public /* synthetic */ Vector2D(double d, double d2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 0.0;
        }
        if ((n & 2) != 0) {
            d2 = 0.0;
        }
        this(d, d2);
    }

    public Vector2D(@NotNull Vector2D v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        this.x = v.x;
        this.y = v.y;
    }

    public Vector2D(@NotNull Coordinate from, @NotNull Coordinate to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        this.x = to.x - from.x;
        this.y = to.y - from.y;
    }

    public Vector2D(@NotNull Coordinate v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        this.x = v.x;
        this.y = v.y;
    }

    public final double getComponent(int index) {
        return index == 0 ? this.x : this.y;
    }

    @NotNull
    public final Vector2D add(@NotNull Vector2D v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return Companion.create(this.x + v.x, this.y + v.y);
    }

    @NotNull
    public final Vector2D subtract(@NotNull Vector2D v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return Companion.create(this.x - v.x, this.y - v.y);
    }

    @NotNull
    public final Vector2D multiply(double d) {
        return Companion.create(this.x * d, this.y * d);
    }

    @NotNull
    public final Vector2D divide(double d) {
        return Companion.create(this.x / d, this.y / d);
    }

    @NotNull
    public final Vector2D negate() {
        return Companion.create(-this.x, -this.y);
    }

    public final double length() {
        return Math.INSTANCE.sqrt(this.x * this.x + this.y * this.y);
    }

    public final double lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    @NotNull
    public final Vector2D normalize() {
        double length = this.length();
        return length > 0.0 ? this.divide(length) : Companion.create(0.0, 0.0);
    }

    @NotNull
    public final Vector2D average(@NotNull Vector2D v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return this.weightedSum(v, 0.5);
    }

    @NotNull
    public final Vector2D weightedSum(@NotNull Vector2D v, double frac) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return Companion.create(frac * this.x + (1.0 - frac) * v.x, frac * this.y + (1.0 - frac) * v.y);
    }

    public final double distance(@NotNull Vector2D v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        double delx = v.x - this.x;
        double dely = v.y - this.y;
        return Math.INSTANCE.sqrt(delx * delx + dely * dely);
    }

    public final double dot(@NotNull Vector2D v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return this.x * v.x + this.y * v.y;
    }

    public final double angle() {
        return Math.INSTANCE.atan2(this.y, this.x);
    }

    public final double angle(@NotNull Vector2D v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return Angle.INSTANCE.diff(v.angle(), this.angle());
    }

    public final double angleTo(@NotNull Vector2D v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        double a1 = this.angle();
        double a2 = v.angle();
        double angDel = a2 - a1;
        if (angDel <= -java.lang.Math.PI) {
            return angDel + java.lang.Math.PI * 2;
        }
        return angDel > java.lang.Math.PI ? angDel - java.lang.Math.PI * 2 : angDel;
    }

    @NotNull
    public final Vector2D rotate(double angle) {
        double cos = Math.INSTANCE.cos(angle);
        double sin = Math.INSTANCE.sin(angle);
        return Companion.create(this.x * cos - this.y * sin, this.x * sin + this.y * cos);
    }

    @Nullable
    public final Vector2D rotateByQuarterCircle(int numQuarters) {
        int nQuad = numQuarters % 4;
        if (numQuarters < 0 && nQuad != 0) {
            nQuad += 4;
        }
        switch (nQuad) {
            case 0: {
                return Companion.create(this.x, this.y);
            }
            case 1: {
                return Companion.create(-this.y, this.x);
            }
            case 2: {
                return Companion.create(-this.x, -this.y);
            }
            case 3: {
                return Companion.create(this.y, -this.x);
            }
        }
        Assert.shouldNeverReachHere$default(null, 1, null);
        return null;
    }

    public final boolean isParallel(@NotNull Vector2D v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return 0.0 == (double)CGAlgorithmsDD.signOfDet2x2(this.x, this.y, v.x, v.y);
    }

    @NotNull
    public final Coordinate translate(@NotNull Coordinate coord) {
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        return new Coordinate(this.x + coord.x, this.y + coord.y);
    }

    @NotNull
    public final Coordinate toCoordinate() {
        return new Coordinate(this.x, this.y);
    }

    @Override
    @NotNull
    public Object clone() {
        return new Vector2D(this);
    }

    @NotNull
    public String toString() {
        return "[" + this.x + ", " + this.y + "]";
    }

    public boolean equals(@Nullable Object o) {
        if (!(o instanceof Vector2D)) {
            return false;
        }
        Object v = o;
        return this.x == ((Vector2D)v).x && this.y == ((Vector2D)v).y;
    }

    public int hashCode() {
        int result2 = 17;
        result2 = 37 * result2 + Coordinate.Companion.hashCode(this.x);
        result2 = 37 * result2 + Coordinate.Companion.hashCode(this.y);
        return result2;
    }

    @JvmOverloads
    public Vector2D(double x) {
        this(x, 0.0, 2, null);
    }

    @JvmOverloads
    public Vector2D() {
        this(0.0, 0.0, 3, null);
    }

    @JvmStatic
    @NotNull
    public static final Vector2D create(double x, double y) {
        return Companion.create(x, y);
    }

    @JvmStatic
    @NotNull
    public static final Vector2D create(@NotNull Coordinate coord) {
        return Companion.create(coord);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0007J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b\u00a8\u0006\u000e"}, d2={"Lorg/locationtech/jts/math/Vector2D$Companion;", "", "<init>", "()V", "create", "Lorg/locationtech/jts/math/Vector2D;", "x", "", "y", "v", "coord", "Lorg/locationtech/jts/geom/Coordinate;", "from", "to", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Vector2D create(double x, double y) {
            return new Vector2D(x, y);
        }

        @NotNull
        public final Vector2D create(@NotNull Vector2D v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            return new Vector2D(v);
        }

        @JvmStatic
        @NotNull
        public final Vector2D create(@NotNull Coordinate coord) {
            Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
            return new Vector2D(coord);
        }

        @NotNull
        public final Vector2D create(@NotNull Coordinate from, @NotNull Coordinate to) {
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            return new Vector2D(from, to);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

