/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.math;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\bB!\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0004\b\u0004\u0010\rJ\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\nJ\u000e\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0000J\u0006\u0010\u0018\u001a\u00020\nJ\u0006\u0010\u0019\u001a\u00020\u0000J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001f\u001a\u00020 H\u0016R\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u001e\u0010\f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\""}, d2={"Lorg/locationtech/jts/math/Vector3D;", "", "v", "Lorg/locationtech/jts/geom/Coordinate;", "<init>", "(Lorg/locationtech/jts/geom/Coordinate;)V", "from", "to", "(Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;)V", "x", "", "y", "z", "(DDD)V", "value", "getX", "()D", "getY", "getZ", "add", "subtract", "divide", "d", "dot", "length", "normalize", "toString", "", "equals", "", "o", "hashCode", "", "Companion", "kts-core"})
public final class Vector3D {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double x;
    private double y;
    private double z;

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getZ() {
        return this.z;
    }

    public Vector3D(@NotNull Coordinate v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        this.x = v.x;
        this.y = v.y;
        this.z = v.getZ();
    }

    public Vector3D(@NotNull Coordinate from, @NotNull Coordinate to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        this.x = to.x - from.x;
        this.y = to.y - from.y;
        this.z = to.getZ() - from.getZ();
    }

    public Vector3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @NotNull
    public final Vector3D add(@NotNull Vector3D v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return Companion.create(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    @NotNull
    public final Vector3D subtract(@NotNull Vector3D v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return Companion.create(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    @NotNull
    public final Vector3D divide(double d) {
        return Companion.create(this.x / d, this.y / d, this.z / d);
    }

    public final double dot(@NotNull Vector3D v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public final double length() {
        return Math.INSTANCE.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    @NotNull
    public final Vector3D normalize() {
        double length = this.length();
        return length > 0.0 ? this.divide(this.length()) : Companion.create(0.0, 0.0, 0.0);
    }

    @NotNull
    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + "]";
    }

    public boolean equals(@Nullable Object o) {
        if (!(o instanceof Vector3D)) {
            return false;
        }
        Object v = o;
        return this.x == ((Vector3D)v).x && this.y == ((Vector3D)v).y && this.z == ((Vector3D)v).z;
    }

    public int hashCode() {
        int result2 = 17;
        result2 = 37 * result2 + Coordinate.Companion.hashCode(this.x);
        result2 = 37 * result2 + Coordinate.Companion.hashCode(this.y);
        result2 = 37 * result2 + Coordinate.Companion.hashCode(this.z);
        return result2;
    }

    @JvmStatic
    public static final double dot(@NotNull Coordinate A, @NotNull Coordinate B, @NotNull Coordinate C, @NotNull Coordinate D) {
        return Companion.dot(A, B, C, D);
    }

    @JvmStatic
    @NotNull
    public static final Vector3D create(double x, double y, double z) {
        return Companion.create(x, y, z);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0007J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0007J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0007J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007J\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0007J\u000e\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0007\u00a8\u0006\u0016"}, d2={"Lorg/locationtech/jts/math/Vector3D$Companion;", "", "<init>", "()V", "dot", "", "A", "Lorg/locationtech/jts/geom/Coordinate;", "B", "C", "D", "create", "Lorg/locationtech/jts/math/Vector3D;", "x", "y", "z", "coord", "v1", "v2", "length", "v", "normalize", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final double dot(@NotNull Coordinate A, @NotNull Coordinate B, @NotNull Coordinate C, @NotNull Coordinate D) {
            Intrinsics.checkNotNullParameter((Object)A, (String)"A");
            Intrinsics.checkNotNullParameter((Object)B, (String)"B");
            Intrinsics.checkNotNullParameter((Object)C, (String)"C");
            Intrinsics.checkNotNullParameter((Object)D, (String)"D");
            double ABx = B.x - A.x;
            double ABy = B.y - A.y;
            double ABz = B.getZ() - A.getZ();
            double CDx = D.x - C.x;
            double CDy = D.y - C.y;
            double CDz = D.getZ() - C.getZ();
            return ABx * CDx + ABy * CDy + ABz * CDz;
        }

        @JvmStatic
        @NotNull
        public final Vector3D create(double x, double y, double z) {
            return new Vector3D(x, y, z);
        }

        @NotNull
        public final Vector3D create(@NotNull Coordinate coord) {
            Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
            return new Vector3D(coord);
        }

        public final double dot(@NotNull Coordinate v1, @NotNull Coordinate v2) {
            Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
            Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
            return v1.x * v2.x + v1.y * v2.y + v1.getZ() * v2.getZ();
        }

        public final double length(@NotNull Coordinate v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            return Math.INSTANCE.sqrt(v.x * v.x + v.y * v.y + v.getZ() * v.getZ());
        }

        @NotNull
        public final Coordinate normalize(@NotNull Coordinate v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            double len = this.length(v);
            return new Coordinate(v.x / len, v.y / len, v.getZ() / len);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

