/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.noding.Octant;
import org.locationtech.jts.noding.SegmentString;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0011H\u0016J\u000e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0011J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016\u00a8\u0006\u001b"}, d2={"Lorg/locationtech/jts/noding/BasicSegmentString;", "Lorg/locationtech/jts/noding/SegmentString;", "coordinates", "", "Lorg/locationtech/jts/geom/Coordinate;", "data", "", "<init>", "([Lorg/locationtech/jts/geom/Coordinate;Ljava/lang/Object;)V", "getCoordinates", "()[Lorg/locationtech/jts/geom/Coordinate;", "[Lorg/locationtech/jts/geom/Coordinate;", "getData", "()Ljava/lang/Object;", "setData", "(Ljava/lang/Object;)V", "size", "", "getCoordinate", "i", "isClosed", "", "()Z", "getSegmentOctant", "index", "toString", "", "kts-core"})
public final class BasicSegmentString
implements SegmentString {
    @NotNull
    private final Coordinate[] coordinates;
    @Nullable
    private Object data;

    public BasicSegmentString(@NotNull Coordinate[] coordinates, @Nullable Object data) {
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        this.coordinates = coordinates;
        this.data = data;
    }

    @Override
    @NotNull
    public Coordinate[] getCoordinates() {
        return this.coordinates;
    }

    @Override
    @Nullable
    public Object getData() {
        return this.data;
    }

    @Override
    public void setData(@Nullable Object object) {
        this.data = object;
    }

    @Override
    public int size() {
        return this.getCoordinates().length;
    }

    @Override
    @NotNull
    public Coordinate getCoordinate(int i) {
        return this.getCoordinates()[i];
    }

    @Override
    public boolean isClosed() {
        return Intrinsics.areEqual((Object)this.getCoordinates()[0], (Object)this.getCoordinates()[this.getCoordinates().length - 1]);
    }

    public final int getSegmentOctant(int index) {
        return index == this.getCoordinates().length - 1 ? -1 : Octant.octant(this.getCoordinate(index), this.getCoordinate(index + 1));
    }

    @NotNull
    public String toString() {
        return WKTWriter.Companion.toLineString(new CoordinateArraySequence(this.getCoordinates(), 0, 0, 6, null));
    }
}

