/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.noding.BasicSegmentString;
import org.locationtech.jts.noding.Noder;
import org.locationtech.jts.noding.SegmentString;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0003\u000e\u000f\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0016R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lorg/locationtech/jts/noding/BoundaryChainNoder;", "Lorg/locationtech/jts/noding/Noder;", "<init>", "()V", "chainList", "", "Lorg/locationtech/jts/noding/SegmentString;", "computeNodes", "", "segStrings", "", "nodedSubstrings", "getNodedSubstrings", "()Ljava/util/Collection;", "BoundaryChainMap", "Segment", "Companion", "kts-core"})
public final class BoundaryChainNoder
implements Noder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private List<? extends SegmentString> chainList;

    @Override
    public void computeNodes(@NotNull Collection<? extends SegmentString> segStrings) {
        Intrinsics.checkNotNullParameter(segStrings, (String)"segStrings");
        HashSet segSet = new HashSet();
        BoundaryChainMap[] boundaryChains = new BoundaryChainMap[segStrings.size()];
        BoundaryChainNoder.Companion.addSegments(segStrings, segSet, boundaryChains);
        BoundaryChainNoder.Companion.markBoundarySegments(segSet);
        this.chainList = BoundaryChainNoder.Companion.extractChains(boundaryChains);
    }

    @Override
    @NotNull
    public Collection<SegmentString> getNodedSubstrings() {
        List<? extends SegmentString> list = this.chainList;
        Intrinsics.checkNotNull(list);
        return list;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0004\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\r\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fJ\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/locationtech/jts/noding/BoundaryChainNoder$BoundaryChainMap;", "", "ss", "Lorg/locationtech/jts/noding/SegmentString;", "<init>", "(Lorg/locationtech/jts/noding/SegmentString;)V", "segString", "isBoundary", "", "setBoundarySegment", "", "index", "", "createChains", "chainList", "", "findChainStart", "findChainEnd", "Companion", "kts-core"})
    private static final class BoundaryChainMap {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final SegmentString segString;
        @NotNull
        private final boolean[] isBoundary;

        public BoundaryChainMap(@NotNull SegmentString ss) {
            Intrinsics.checkNotNullParameter((Object)ss, (String)"ss");
            this.segString = ss;
            this.isBoundary = new boolean[ss.size() - 1];
        }

        public final void setBoundarySegment(int index) {
            this.isBoundary[index] = true;
        }

        public final void createChains(@NotNull List<SegmentString> chainList) {
            int startIndex;
            Intrinsics.checkNotNullParameter(chainList, (String)"chainList");
            int endIndex = 0;
            while ((startIndex = this.findChainStart(endIndex)) < this.segString.size() - 1) {
                endIndex = this.findChainEnd(startIndex);
                SegmentString ss = BoundaryChainMap.Companion.createChain(this.segString, startIndex, endIndex);
                chainList.add(ss);
            }
        }

        private final int findChainStart(int index) {
            int index2;
            for (index2 = index; index2 < this.isBoundary.length && !this.isBoundary[index2]; ++index2) {
            }
            return index2;
        }

        private final int findChainEnd(int index) {
            int index2 = index;
            ++index2;
            while (index2 < this.isBoundary.length && this.isBoundary[index2]) {
                ++index2;
            }
            return index2;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a8\u0006\n"}, d2={"Lorg/locationtech/jts/noding/BoundaryChainNoder$BoundaryChainMap$Companion;", "", "<init>", "()V", "createChain", "Lorg/locationtech/jts/noding/SegmentString;", "segString", "startIndex", "", "endIndex", "kts-core"})
        public static final class Companion {
            private Companion() {
            }

            private final SegmentString createChain(SegmentString segString, int startIndex, int endIndex) {
                Object[] pts = new Coordinate[endIndex - startIndex + 1];
                int ipts = 0;
                int n = endIndex + 1;
                for (int i = startIndex; i < n; ++i) {
                    pts[ipts++] = segString.getCoordinate(i).copy();
                }
                return new BasicSegmentString((Coordinate[])ArraysKt.requireNoNulls((Object[])pts), segString.getData());
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JC\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0016\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\f2\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eH\u0002\u00a2\u0006\u0002\u0010\u0010J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u000f2\u0016\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fH\u0002J \u0010\u0013\u001a\u00020\u00052\u0016\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fH\u0002J#\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u00152\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eH\u0002\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lorg/locationtech/jts/noding/BoundaryChainNoder$Companion;", "", "<init>", "()V", "addSegments", "", "segStrings", "", "Lorg/locationtech/jts/noding/SegmentString;", "segSet", "Ljava/util/HashSet;", "Lorg/locationtech/jts/noding/BoundaryChainNoder$Segment;", "Lkotlin/collections/HashSet;", "boundaryChains", "", "Lorg/locationtech/jts/noding/BoundaryChainNoder$BoundaryChainMap;", "(Ljava/util/Collection;Ljava/util/HashSet;[Lorg/locationtech/jts/noding/BoundaryChainNoder$BoundaryChainMap;)V", "segString", "chainMap", "markBoundarySegments", "extractChains", "", "([Lorg/locationtech/jts/noding/BoundaryChainNoder$BoundaryChainMap;)Ljava/util/List;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        private final void addSegments(Collection<? extends SegmentString> segStrings, HashSet<Segment> segSet, BoundaryChainMap[] boundaryChains) {
            int i = 0;
            for (SegmentString segmentString : segStrings) {
                BoundaryChainMap chainMap = new BoundaryChainMap(segmentString);
                boundaryChains[i++] = chainMap;
                this.addSegments(segmentString, chainMap, segSet);
            }
        }

        private final void addSegments(SegmentString segString, BoundaryChainMap chainMap, HashSet<Segment> segSet) {
            int n = segString.size() - 1;
            for (int i = 0; i < n; ++i) {
                Coordinate p1;
                Coordinate p0 = segString.getCoordinate(i);
                Segment seg = new Segment(p0, p1 = segString.getCoordinate(i + 1), chainMap, i);
                boolean bl = segSet.contains(seg) ? segSet.remove(seg) : segSet.add(seg);
            }
        }

        private final void markBoundarySegments(HashSet<Segment> segSet) {
            Iterator<Segment> iterator2 = segSet.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            Iterator<Segment> iterator3 = iterator2;
            while (iterator3.hasNext()) {
                Segment seg;
                Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
                seg.markBoundary();
            }
        }

        private final List<SegmentString> extractChains(BoundaryChainMap[] boundaryChains) {
            List chainList = new ArrayList();
            int n = boundaryChains.length;
            for (int i = 0; i < n; ++i) {
                BoundaryChainMap chainMap;
                BoundaryChainMap boundaryChainMap = chainMap = boundaryChains[i];
                Intrinsics.checkNotNull((Object)boundaryChainMap);
                boundaryChainMap.createChains(chainList);
            }
            return chainList;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B+\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/locationtech/jts/noding/BoundaryChainNoder$Segment;", "Lorg/locationtech/jts/geom/LineSegment;", "p0", "Lorg/locationtech/jts/geom/Coordinate;", "p1", "segMap", "Lorg/locationtech/jts/noding/BoundaryChainNoder$BoundaryChainMap;", "index", "", "<init>", "(Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/noding/BoundaryChainNoder$BoundaryChainMap;I)V", "markBoundary", "", "kts-core"})
    private static final class Segment
    extends LineSegment {
        @NotNull
        private final BoundaryChainMap segMap;
        private final int index;

        public Segment(@Nullable Coordinate p0, @Nullable Coordinate p1, @NotNull BoundaryChainMap segMap, int index) {
            Intrinsics.checkNotNullParameter((Object)segMap, (String)"segMap");
            Coordinate coordinate = p0;
            Intrinsics.checkNotNull((Object)coordinate);
            Coordinate coordinate2 = p1;
            Intrinsics.checkNotNull((Object)coordinate2);
            super(coordinate, coordinate2);
            this.segMap = segMap;
            this.index = index;
            this.normalize();
        }

        public final void markBoundary() {
            this.segMap.setBoundarySegment(this.index);
        }
    }
}

