/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.noding.BasicSegmentString;
import org.locationtech.jts.noding.Noder;
import org.locationtech.jts.noding.SegmentString;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0006\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000e\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0016R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lorg/locationtech/jts/noding/BoundarySegmentNoder;", "Lorg/locationtech/jts/noding/Noder;", "<init>", "()V", "segList", "", "Lorg/locationtech/jts/noding/SegmentString;", "computeNodes", "", "segStrings", "", "nodedSubstrings", "getNodedSubstrings", "()Ljava/util/Collection;", "Segment", "Companion", "kts-core"})
public final class BoundarySegmentNoder
implements Noder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private List<? extends SegmentString> segList;

    @Override
    public void computeNodes(@NotNull Collection<? extends SegmentString> segStrings) {
        Intrinsics.checkNotNullParameter(segStrings, (String)"segStrings");
        HashSet segSet = new HashSet();
        BoundarySegmentNoder.Companion.addSegments(segStrings, (HashSet<Segment>)segSet);
        this.segList = BoundarySegmentNoder.Companion.extractSegments(segSet);
    }

    @Override
    @NotNull
    public Collection<SegmentString> getNodedSubstrings() {
        List<? extends SegmentString> list = this.segList;
        Intrinsics.checkNotNull(list);
        return list;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0016\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fH\u0002J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\b2\u0016\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fH\u0002J&\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000f2\u0016\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/locationtech/jts/noding/BoundarySegmentNoder$Companion;", "", "<init>", "()V", "addSegments", "", "segStrings", "", "Lorg/locationtech/jts/noding/SegmentString;", "segSet", "Ljava/util/HashSet;", "Lorg/locationtech/jts/noding/BoundarySegmentNoder$Segment;", "Lkotlin/collections/HashSet;", "segString", "extractSegments", "", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        private final void addSegments(Collection<? extends SegmentString> segStrings, HashSet<Segment> segSet) {
            for (SegmentString segmentString : segStrings) {
                this.addSegments(segmentString, segSet);
            }
        }

        private final void addSegments(SegmentString segString, HashSet<Segment> segSet) {
            int n = segString.size() - 1;
            for (int i = 0; i < n; ++i) {
                Coordinate p1;
                Coordinate p0 = segString.getCoordinate(i);
                Segment seg = new Segment(p0, p1 = segString.getCoordinate(i + 1), segString, i);
                boolean bl = segSet.contains(seg) ? segSet.remove(seg) : segSet.add(seg);
            }
        }

        private final List<SegmentString> extractSegments(HashSet<Segment> segSet) {
            List segList = new ArrayList();
            Iterator<Segment> iterator2 = segSet.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            Iterator<Segment> iterator3 = iterator2;
            while (iterator3.hasNext()) {
                Segment seg;
                Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
                SegmentString ss = seg.getSegmentString();
                int i = seg.getIndex();
                Coordinate p0 = ss.getCoordinate(i);
                Coordinate p1 = ss.getCoordinate(i + 1);
                Coordinate[] coordinateArray = new Coordinate[]{p0, p1};
                SegmentString segStr = new BasicSegmentString(coordinateArray, ss.getData());
                segList.add(segStr);
            }
            return segList;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B+\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/locationtech/jts/noding/BoundarySegmentNoder$Segment;", "Lorg/locationtech/jts/geom/LineSegment;", "p0", "Lorg/locationtech/jts/geom/Coordinate;", "p1", "segStr", "Lorg/locationtech/jts/noding/SegmentString;", "index", "", "<init>", "(Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/noding/SegmentString;I)V", "getIndex", "()I", "segmentString", "getSegmentString", "()Lorg/locationtech/jts/noding/SegmentString;", "kts-core"})
    public static final class Segment
    extends LineSegment {
        @NotNull
        private final SegmentString segStr;
        private final int index;

        public Segment(@Nullable Coordinate p0, @Nullable Coordinate p1, @NotNull SegmentString segStr, int index) {
            Intrinsics.checkNotNullParameter((Object)segStr, (String)"segStr");
            Coordinate coordinate = p0;
            Intrinsics.checkNotNull((Object)coordinate);
            Coordinate coordinate2 = p1;
            Intrinsics.checkNotNull((Object)coordinate2);
            super(coordinate, coordinate2);
            this.segStr = segStr;
            this.index = index;
            this.normalize();
        }

        public final int getIndex() {
            return this.index;
        }

        @NotNull
        public final SegmentString getSegmentString() {
            return this.segStr;
        }
    }
}

