/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.noding.MCIndexNoder;
import org.locationtech.jts.noding.NodingIntersectionFinder;
import org.locationtech.jts.noding.SegmentString;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0017\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\r\u001a\u00020\nJ\u0006\u0010\u0019\u001a\u00020\u000fJ\b\u0010\u001a\u001a\u00020\u000fH\u0002J\b\u0010\u001b\u001a\u00020\u000fH\u0002R\u0016\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001d"}, d2={"Lorg/locationtech/jts/noding/FastNodingValidator;", "", "segStrings", "", "Lorg/locationtech/jts/noding/SegmentString;", "<init>", "(Ljava/util/Collection;)V", "li", "Lorg/locationtech/jts/algorithm/LineIntersector;", "findAllIntersections", "", "segInt", "Lorg/locationtech/jts/noding/NodingIntersectionFinder;", "isValid", "setFindAllIntersections", "", "intersections", "", "Lorg/locationtech/jts/geom/Coordinate;", "getIntersections", "()Ljava/util/List;", "errorMessage", "", "getErrorMessage", "()Ljava/lang/String;", "checkValid", "execute", "checkInteriorIntersections", "Companion", "kts-core"})
public final class FastNodingValidator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Collection<SegmentString> segStrings;
    @NotNull
    private final LineIntersector li;
    private boolean findAllIntersections;
    @Nullable
    private NodingIntersectionFinder segInt;
    private boolean isValid;

    public FastNodingValidator(@Nullable Collection<? extends SegmentString> segStrings) {
        this.segStrings = segStrings;
        this.li = new RobustLineIntersector();
        this.isValid = true;
    }

    public final void setFindAllIntersections(boolean findAllIntersections) {
        this.findAllIntersections = findAllIntersections;
    }

    @NotNull
    public final List<Coordinate> getIntersections() {
        NodingIntersectionFinder nodingIntersectionFinder = this.segInt;
        Intrinsics.checkNotNull((Object)nodingIntersectionFinder);
        return nodingIntersectionFinder.getIntersections();
    }

    public final boolean isValid() {
        this.execute();
        return this.isValid;
    }

    @NotNull
    public final String getErrorMessage() {
        if (this.isValid) {
            return "no intersections found";
        }
        NodingIntersectionFinder nodingIntersectionFinder = this.segInt;
        Intrinsics.checkNotNull((Object)nodingIntersectionFinder);
        Coordinate[] intSegs = nodingIntersectionFinder.getIntersectionSegments();
        Intrinsics.checkNotNull((Object)intSegs);
        Coordinate coordinate = intSegs[0];
        Intrinsics.checkNotNull((Object)coordinate);
        Coordinate coordinate2 = intSegs[1];
        Intrinsics.checkNotNull((Object)coordinate2);
        String string = WKTWriter.Companion.toLineString(coordinate, coordinate2);
        Coordinate coordinate3 = intSegs[2];
        Intrinsics.checkNotNull((Object)coordinate3);
        Coordinate coordinate4 = intSegs[3];
        Intrinsics.checkNotNull((Object)coordinate4);
        return "found non-noded intersection between " + string + " and " + WKTWriter.Companion.toLineString(coordinate3, coordinate4);
    }

    public final void checkValid() {
        this.execute();
        if (!this.isValid) {
            String string = this.getErrorMessage();
            NodingIntersectionFinder nodingIntersectionFinder = this.segInt;
            Intrinsics.checkNotNull((Object)nodingIntersectionFinder);
            throw new TopologyException(string, nodingIntersectionFinder.getIntersection());
        }
    }

    private final void execute() {
        if (this.segInt != null) {
            return;
        }
        this.checkInteriorIntersections();
    }

    private final void checkInteriorIntersections() {
        this.isValid = true;
        NodingIntersectionFinder nodingIntersectionFinder = this.segInt = new NodingIntersectionFinder(this.li);
        Intrinsics.checkNotNull((Object)nodingIntersectionFinder);
        nodingIntersectionFinder.setFindAllIntersections(this.findAllIntersections);
        MCIndexNoder noder = new MCIndexNoder();
        noder.setSegmentIntersector(this.segInt);
        Collection<SegmentString> collection = this.segStrings;
        Intrinsics.checkNotNull(collection);
        noder.computeNodes(collection);
        NodingIntersectionFinder nodingIntersectionFinder2 = this.segInt;
        Intrinsics.checkNotNull((Object)nodingIntersectionFinder2);
        if (nodingIntersectionFinder2.hasIntersection()) {
            this.isValid = false;
            return;
        }
    }

    @JvmStatic
    @NotNull
    public static final List<Coordinate> computeIntersections(@Nullable Collection<? extends SegmentString> segStrings) {
        return Companion.computeIntersections(segStrings);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bH\u0007\u00a8\u0006\n"}, d2={"Lorg/locationtech/jts/noding/FastNodingValidator$Companion;", "", "<init>", "()V", "computeIntersections", "", "Lorg/locationtech/jts/geom/Coordinate;", "segStrings", "", "Lorg/locationtech/jts/noding/SegmentString;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final List<Coordinate> computeIntersections(@Nullable Collection<? extends SegmentString> segStrings) {
            FastNodingValidator nv = new FastNodingValidator(segStrings);
            nv.setFindAllIntersections(true);
            nv.isValid();
            return nv.getIntersections();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

