/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.chain.MonotoneChain;
import org.locationtech.jts.index.chain.MonotoneChainBuilder;
import org.locationtech.jts.index.chain.MonotoneChainOverlapAction;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.noding.SegmentIntersector;
import org.locationtech.jts.noding.SegmentSetMutualIntersector;
import org.locationtech.jts.noding.SegmentString;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0018B\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0002J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0010\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u001e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u001e\u0010\u0017\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/locationtech/jts/noding/MCIndexSegmentSetMutualIntersector;", "Lorg/locationtech/jts/noding/SegmentSetMutualIntersector;", "baseSegStrings", "", "<init>", "(Ljava/util/Collection;)V", "index", "Lorg/locationtech/jts/index/strtree/STRtree;", "getIndex", "Lorg/locationtech/jts/index/SpatialIndex;", "initBaseSegments", "", "segStrings", "addToIndex", "segStr", "Lorg/locationtech/jts/noding/SegmentString;", "process", "segInt", "Lorg/locationtech/jts/noding/SegmentIntersector;", "addToMonoChains", "monoChains", "", "Lorg/locationtech/jts/index/chain/MonotoneChain;", "intersectChains", "SegmentOverlapAction", "kts-core"})
public final class MCIndexSegmentSetMutualIntersector
implements SegmentSetMutualIntersector {
    @NotNull
    private final STRtree index;

    public MCIndexSegmentSetMutualIntersector(@NotNull Collection<?> baseSegStrings) {
        Intrinsics.checkNotNullParameter(baseSegStrings, (String)"baseSegStrings");
        this.index = new STRtree();
        this.initBaseSegments(baseSegStrings);
    }

    @NotNull
    public final SpatialIndex getIndex() {
        return this.index;
    }

    private final void initBaseSegments(Collection<?> segStrings) {
        for (Object obj : segStrings) {
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.noding.SegmentString");
            this.addToIndex((SegmentString)obj);
        }
        this.index.build();
    }

    private final void addToIndex(SegmentString segStr) {
        List<MonotoneChain> segChains = MonotoneChainBuilder.getChains(segStr.getCoordinates(), segStr);
        Iterator<MonotoneChain> i = segChains.iterator();
        while (i.hasNext()) {
            MonotoneChain mc;
            Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.index.chain.MonotoneChain");
            this.index.insert(mc.getEnvelope(), (Object)mc);
        }
    }

    @Override
    public void process(@Nullable Collection<?> segStrings, @Nullable SegmentIntersector segInt) {
        List monoChains = new ArrayList();
        Collection<?> collection = segStrings;
        Intrinsics.checkNotNull(collection);
        for (Object obj : collection) {
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.noding.SegmentString");
            this.addToMonoChains((SegmentString)obj, monoChains);
        }
        SegmentIntersector segmentIntersector = segInt;
        Intrinsics.checkNotNull((Object)segmentIntersector);
        this.intersectChains(monoChains, segmentIntersector);
    }

    private final void addToMonoChains(SegmentString segStr, List<MonotoneChain> monoChains) {
        List<MonotoneChain> segChains = MonotoneChainBuilder.getChains(segStr.getCoordinates(), segStr);
        Iterator<MonotoneChain> i = segChains.iterator();
        while (i.hasNext()) {
            MonotoneChain mc;
            Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.index.chain.MonotoneChain");
            monoChains.add(mc);
        }
    }

    private final void intersectChains(List<MonotoneChain> monoChains, SegmentIntersector segInt) {
        MonotoneChainOverlapAction overlapAction = new SegmentOverlapAction(segInt);
        Iterator<MonotoneChain> i = monoChains.iterator();
        while (i.hasNext()) {
            MonotoneChain queryChain;
            List overlapChains;
            Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.index.chain.MonotoneChain");
            List list = overlapChains = TypeIntrinsics.asMutableList(this.index.query(queryChain.getEnvelope()));
            Intrinsics.checkNotNull((Object)list);
            for (Object e : list) {
                Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.locationtech.jts.index.chain.MonotoneChain");
                MonotoneChain testChain = (MonotoneChain)e;
                queryChain.computeOverlaps(testChain, overlapAction);
                if (!segInt.isDone()) continue;
                return;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000bH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/locationtech/jts/noding/MCIndexSegmentSetMutualIntersector$SegmentOverlapAction;", "Lorg/locationtech/jts/index/chain/MonotoneChainOverlapAction;", "si", "Lorg/locationtech/jts/noding/SegmentIntersector;", "<init>", "(Lorg/locationtech/jts/noding/SegmentIntersector;)V", "overlap", "", "mc1", "Lorg/locationtech/jts/index/chain/MonotoneChain;", "start1", "", "mc2", "start2", "kts-core"})
    public static final class SegmentOverlapAction
    extends MonotoneChainOverlapAction {
        @Nullable
        private final SegmentIntersector si;

        public SegmentOverlapAction(@Nullable SegmentIntersector si) {
            this.si = si;
        }

        public /* synthetic */ SegmentOverlapAction(SegmentIntersector segmentIntersector, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                segmentIntersector = null;
            }
            this(segmentIntersector);
        }

        @Override
        public void overlap(@NotNull MonotoneChain mc1, int start1, @NotNull MonotoneChain mc2, int start2) {
            Intrinsics.checkNotNullParameter((Object)mc1, (String)"mc1");
            Intrinsics.checkNotNullParameter((Object)mc2, (String)"mc2");
            SegmentString ss1 = (SegmentString)mc1.getContext();
            SegmentString ss2 = (SegmentString)mc2.getContext();
            SegmentIntersector segmentIntersector = this.si;
            Intrinsics.checkNotNull((Object)segmentIntersector);
            SegmentString segmentString = ss1;
            Intrinsics.checkNotNull((Object)segmentString);
            SegmentString segmentString2 = ss2;
            Intrinsics.checkNotNull((Object)segmentString2);
            segmentIntersector.processIntersections(segmentString, start1, segmentString2, start2);
        }

        public SegmentOverlapAction() {
            this(null, 1, null);
        }
    }
}

