/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.markers.KMutableIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.noding.SegmentNode;
import org.locationtech.jts.noding.SegmentNodeList;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010)\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\u0010\u001a\u00020\u0011H\u0096\u0002J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/locationtech/jts/noding/NodeVertexIterator;", "", "", "nodeList", "Lorg/locationtech/jts/noding/SegmentNodeList;", "<init>", "(Lorg/locationtech/jts/noding/SegmentNodeList;)V", "edge", "Lorg/locationtech/jts/noding/NodedSegmentString;", "nodeIt", "", "currNode", "Lorg/locationtech/jts/noding/SegmentNode;", "nextNode", "currSegIndex", "", "hasNext", "", "next", "readNextNode", "", "remove", "kts-core"})
public final class NodeVertexIterator
implements Iterator<Object>,
KMutableIterator {
    @NotNull
    private final NodedSegmentString edge;
    @NotNull
    private final Iterator<?> nodeIt;
    @Nullable
    private SegmentNode currNode;
    @Nullable
    private SegmentNode nextNode;
    private int currSegIndex;

    public NodeVertexIterator(@NotNull SegmentNodeList nodeList) {
        Intrinsics.checkNotNullParameter((Object)nodeList, (String)"nodeList");
        this.edge = nodeList.getEdge();
        this.nodeIt = nodeList.iterator();
        this.readNextNode();
    }

    @Override
    public boolean hasNext() {
        return this.nextNode != null;
    }

    @Override
    @Nullable
    public Object next() {
        if (this.currNode == null) {
            SegmentNode segmentNode = this.currNode = this.nextNode;
            Intrinsics.checkNotNull((Object)segmentNode);
            this.currSegIndex = segmentNode.getSegmentIndex();
            this.readNextNode();
            return this.currNode;
        }
        if (this.nextNode == null) {
            return null;
        }
        SegmentNode segmentNode = this.nextNode;
        Intrinsics.checkNotNull((Object)segmentNode);
        int n = segmentNode.getSegmentIndex();
        SegmentNode segmentNode2 = this.currNode;
        Intrinsics.checkNotNull((Object)segmentNode2);
        if (n == segmentNode2.getSegmentIndex()) {
            SegmentNode segmentNode3 = this.currNode = this.nextNode;
            Intrinsics.checkNotNull((Object)segmentNode3);
            this.currSegIndex = segmentNode3.getSegmentIndex();
            this.readNextNode();
            return this.currNode;
        }
        SegmentNode segmentNode4 = this.nextNode;
        Intrinsics.checkNotNull((Object)segmentNode4);
        int n2 = segmentNode4.getSegmentIndex();
        SegmentNode segmentNode5 = this.currNode;
        Intrinsics.checkNotNull((Object)segmentNode5);
        if (n2 > segmentNode5.getSegmentIndex()) {
            // empty if block
        }
        return null;
    }

    private final void readNextNode() {
        this.nextNode = this.nodeIt.hasNext() ? (SegmentNode)this.nodeIt.next() : null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException(Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName());
    }
}

