/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.noding.Noder;
import org.locationtech.jts.noding.SegmentString;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B-\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J!\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0016\u0010\u001b\u001a\u00020\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u001b\u0010\u001b\u001a\u00020\u00132\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002\u00a2\u0006\u0002\u0010\u001cR\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lorg/locationtech/jts/noding/ScaledNoder;", "Lorg/locationtech/jts/noding/Noder;", "noder", "scaleFactor", "", "offsetX", "offsetY", "<init>", "(Lorg/locationtech/jts/noding/Noder;DDD)V", "isScaled", "", "isIntegerPrecision", "()Z", "nodedSubstrings", "", "Lorg/locationtech/jts/noding/SegmentString;", "getNodedSubstrings", "()Ljava/util/Collection;", "computeNodes", "", "inputSegStrings", "scale", "segStrings", "", "Lorg/locationtech/jts/geom/Coordinate;", "pts", "([Lorg/locationtech/jts/geom/Coordinate;)[Lorg/locationtech/jts/geom/Coordinate;", "rescale", "([Lorg/locationtech/jts/geom/Coordinate;)V", "kts-core"})
public final class ScaledNoder
implements Noder {
    @NotNull
    private final Noder noder;
    private final double scaleFactor;
    private final double offsetX;
    private final double offsetY;
    private boolean isScaled;

    @JvmOverloads
    public ScaledNoder(@NotNull Noder noder, double scaleFactor, double offsetX, double offsetY) {
        Intrinsics.checkNotNullParameter((Object)noder, (String)"noder");
        this.noder = noder;
        this.scaleFactor = scaleFactor;
        this.isScaled = !this.isIntegerPrecision();
    }

    public /* synthetic */ ScaledNoder(Noder noder, double d, double d2, double d3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            d2 = 0.0;
        }
        if ((n & 8) != 0) {
            d3 = 0.0;
        }
        this(noder, d, d2, d3);
    }

    public final boolean isIntegerPrecision() {
        return this.scaleFactor == 1.0;
    }

    @Override
    @NotNull
    public Collection<SegmentString> getNodedSubstrings() {
        Collection<SegmentString> collection = this.noder.getNodedSubstrings();
        Intrinsics.checkNotNull(collection);
        Collection<SegmentString> splitSS = collection;
        if (this.isScaled) {
            this.rescale(splitSS);
        }
        return splitSS;
    }

    @Override
    public void computeNodes(@NotNull Collection<? extends SegmentString> inputSegStrings) {
        Intrinsics.checkNotNullParameter(inputSegStrings, (String)"inputSegStrings");
        Collection<? extends SegmentString> intSegStrings = inputSegStrings;
        if (this.isScaled) {
            intSegStrings = this.scale(inputSegStrings);
        }
        this.noder.computeNodes(intSegStrings);
    }

    private final Collection<SegmentString> scale(Collection<? extends SegmentString> segStrings) {
        List nodedSegmentStrings = new ArrayList(segStrings.size());
        for (SegmentString segmentString : segStrings) {
            nodedSegmentStrings.add(new NodedSegmentString(this.scale(segmentString.getCoordinates()), segmentString.getData()));
        }
        return nodedSegmentStrings;
    }

    private final Coordinate[] scale(Coordinate[] pts) {
        Object[] roundPts = new Coordinate[pts.length];
        int n = pts.length;
        for (int i = 0; i < n; ++i) {
            roundPts[i] = new Coordinate(Math.INSTANCE.round((pts[i].x - this.offsetX) * this.scaleFactor), Math.INSTANCE.round((pts[i].y - this.offsetY) * this.scaleFactor), pts[i].getZ());
        }
        return CoordinateArrays.INSTANCE.removeRepeatedPoints((Coordinate[])ArraysKt.requireNoNulls((Object[])roundPts));
    }

    private final void rescale(Collection<? extends SegmentString> segStrings) {
        for (SegmentString segmentString : segStrings) {
            this.rescale(segmentString.getCoordinates());
        }
    }

    private final void rescale(Coordinate[] pts) {
        int n = pts.length;
        for (int i = 0; i < n; ++i) {
            pts[i].x = pts[i].x / this.scaleFactor + this.offsetX;
            pts[i].y = pts[i].y / this.scaleFactor + this.offsetY;
        }
    }

    @JvmOverloads
    public ScaledNoder(@NotNull Noder noder, double scaleFactor, double offsetX) {
        Intrinsics.checkNotNullParameter((Object)noder, (String)"noder");
        this(noder, scaleFactor, offsetX, 0.0, 8, null);
    }

    @JvmOverloads
    public ScaledNoder(@NotNull Noder noder, double scaleFactor) {
        Intrinsics.checkNotNullParameter((Object)noder, (String)"noder");
        this(noder, scaleFactor, 0.0, 0.0, 12, null);
    }
}

