/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.noding.SegmentPointComparator;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\bJ\u0013\u0010\u0017\u001a\u00020\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0014\u00a8\u0006\u001b"}, d2={"Lorg/locationtech/jts/noding/SegmentNode;", "", "", "segString", "Lorg/locationtech/jts/noding/NodedSegmentString;", "coord", "Lorg/locationtech/jts/geom/Coordinate;", "segmentIndex", "", "segmentOctant", "<init>", "(Lorg/locationtech/jts/noding/NodedSegmentString;Lorg/locationtech/jts/geom/Coordinate;II)V", "getCoord", "()Lorg/locationtech/jts/geom/Coordinate;", "coordinate", "getCoordinate", "getSegmentIndex", "()I", "isInterior", "", "()Z", "isEndPoint", "maxSegmentIndex", "compareTo", "obj", "toString", "", "kts-core"})
public final class SegmentNode
implements Comparable<Object> {
    @NotNull
    private final Coordinate coord;
    @NotNull
    private final Coordinate coordinate;
    private final int segmentIndex;
    private final int segmentOctant;
    private final boolean isInterior;

    public SegmentNode(@NotNull NodedSegmentString segString, @NotNull Coordinate coord, int segmentIndex, int segmentOctant) {
        Intrinsics.checkNotNullParameter((Object)segString, (String)"segString");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        this.coord = coord;
        this.coordinate = new Coordinate(this.coord);
        this.segmentIndex = segmentIndex;
        this.segmentOctant = segmentOctant;
        this.isInterior = !this.coord.equals2D(segString.getCoordinate(segmentIndex));
    }

    @NotNull
    public final Coordinate getCoord() {
        return this.coord;
    }

    @NotNull
    public final Coordinate getCoordinate() {
        return this.coordinate;
    }

    public final int getSegmentIndex() {
        return this.segmentIndex;
    }

    public final boolean isInterior() {
        return this.isInterior;
    }

    public final boolean isEndPoint(int maxSegmentIndex) {
        if (this.segmentIndex == 0 && !this.isInterior) {
            return true;
        }
        return this.segmentIndex == maxSegmentIndex;
    }

    @Override
    public int compareTo(@Nullable Object obj) {
        SegmentNode other;
        SegmentNode segmentNode = other = (SegmentNode)obj;
        Intrinsics.checkNotNull((Object)segmentNode);
        if (this.segmentIndex < segmentNode.segmentIndex) {
            return -1;
        }
        if (this.segmentIndex > other.segmentIndex) {
            return 1;
        }
        if (this.coordinate.equals2D(other.coordinate)) {
            return 0;
        }
        if (!this.isInterior) {
            return -1;
        }
        return !other.isInterior ? 1 : SegmentPointComparator.compare(this.segmentOctant, this.coordinate, other.coordinate);
    }

    @NotNull
    public String toString() {
        return this.segmentIndex + ":" + this.coordinate;
    }
}

