/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.util.LinearComponentExtracter;
import org.locationtech.jts.noding.BasicSegmentString;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.noding.SegmentString;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u001c\u0010\u000b\u001a\u0004\u0018\u00010\b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0010\u001a\u00020\u00112\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0012"}, d2={"Lorg/locationtech/jts/noding/SegmentStringUtil;", "", "<init>", "()V", "extractSegmentStrings", "", "Lorg/locationtech/jts/noding/SegmentString;", "geom", "Lorg/locationtech/jts/geom/Geometry;", "extractNodedSegmentStrings", "extractBasicSegmentStrings", "toGeometry", "segStrings", "", "geomFact", "Lorg/locationtech/jts/geom/GeometryFactory;", "toString", "", "kts-core"})
public final class SegmentStringUtil {
    @NotNull
    public static final SegmentStringUtil INSTANCE = new SegmentStringUtil();

    private SegmentStringUtil() {
    }

    @JvmStatic
    @NotNull
    public static final List<SegmentString> extractSegmentStrings(@NotNull Geometry geom) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        return INSTANCE.extractNodedSegmentStrings(geom);
    }

    @NotNull
    public final List<SegmentString> extractNodedSegmentStrings(@NotNull Geometry geom) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        List segStr = new ArrayList();
        List<Geometry> lines = LinearComponentExtracter.Companion.getLines(geom);
        for (Geometry geometry : lines) {
            Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
            LineString line = (LineString)geometry;
            Coordinate[] pts = line.getCoordinates();
            segStr.add(new NodedSegmentString(pts, geom));
        }
        return segStr;
    }

    @NotNull
    public final List<SegmentString> extractBasicSegmentStrings(@NotNull Geometry geom) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        List segStr = new ArrayList();
        List<Geometry> lines = LinearComponentExtracter.Companion.getLines(geom);
        for (Geometry geometry : lines) {
            Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
            LineString line = (LineString)geometry;
            Coordinate[] pts = line.getCoordinates();
            segStr.add(new BasicSegmentString(pts, geom));
        }
        return segStr;
    }

    @Nullable
    public final Geometry toGeometry(@NotNull Collection<?> segStrings, @NotNull GeometryFactory geomFact) {
        Intrinsics.checkNotNullParameter(segStrings, (String)"segStrings");
        Intrinsics.checkNotNullParameter((Object)geomFact, (String)"geomFact");
        Object[] lines = new LineString[segStrings.size()];
        int index = 0;
        for (Object obj : segStrings) {
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.noding.SegmentString");
            SegmentString ss = (SegmentString)obj;
            LineString line = geomFact.createLineString(ss.getCoordinates());
            lines[index++] = line;
        }
        return lines.length == 1 ? (Geometry)lines[0] : (Geometry)geomFact.createMultiLineString((LineString[])ArraysKt.requireNoNulls((Object[])lines));
    }

    @NotNull
    public final String toString(@NotNull List<SegmentString> segStrings) {
        Intrinsics.checkNotNullParameter(segStrings, (String)"segStrings");
        StringBuilder buf = new StringBuilder();
        Iterator<SegmentString> i = segStrings.iterator();
        while (i.hasNext()) {
            SegmentString segStr;
            Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.noding.SegmentString");
            buf.append(segStr.toString());
            buf.append("\n");
        }
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

