/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding.snapround;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.ItemVisitor;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.chain.MonotoneChain;
import org.locationtech.jts.index.chain.MonotoneChainSelectAction;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.noding.SegmentString;
import org.locationtech.jts.noding.snapround.HotPixel;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0002\u0012\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0007J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/locationtech/jts/noding/snapround/MCIndexPointSnapper;", "", "index", "Lorg/locationtech/jts/index/SpatialIndex;", "<init>", "(Lorg/locationtech/jts/index/SpatialIndex;)V", "Lorg/locationtech/jts/index/strtree/STRtree;", "snap", "", "hotPixel", "Lorg/locationtech/jts/noding/snapround/HotPixel;", "parentEdge", "Lorg/locationtech/jts/noding/SegmentString;", "hotPixelVertexIndex", "", "getSafeEnvelope", "Lorg/locationtech/jts/geom/Envelope;", "hp", "HotPixelSnapAction", "Companion", "kts-core"})
public final class MCIndexPointSnapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final STRtree index;
    private static final double SAFE_ENV_EXPANSION_FACTOR = 0.75;

    public MCIndexPointSnapper(@NotNull SpatialIndex index) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        this.index = (STRtree)index;
    }

    @JvmOverloads
    public final boolean snap(@NotNull HotPixel hotPixel, @Nullable SegmentString parentEdge, int hotPixelVertexIndex) {
        Intrinsics.checkNotNullParameter((Object)hotPixel, (String)"hotPixel");
        Envelope pixelEnv = this.getSafeEnvelope(hotPixel);
        HotPixelSnapAction hotPixelSnapAction = new HotPixelSnapAction(hotPixel, parentEdge, hotPixelVertexIndex);
        this.index.query(pixelEnv, new ItemVisitor(pixelEnv, hotPixelSnapAction){
            final /* synthetic */ Envelope $pixelEnv;
            final /* synthetic */ HotPixelSnapAction $hotPixelSnapAction;
            {
                this.$pixelEnv = $pixelEnv;
                this.$hotPixelSnapAction = $hotPixelSnapAction;
            }

            public void visitItem(Object item) {
                MonotoneChain testChain;
                MonotoneChain monotoneChain = testChain = (MonotoneChain)item;
                Intrinsics.checkNotNull((Object)monotoneChain);
                monotoneChain.select(this.$pixelEnv, this.$hotPixelSnapAction);
            }
        });
        return hotPixelSnapAction.isNodeAdded();
    }

    public static /* synthetic */ boolean snap$default(MCIndexPointSnapper mCIndexPointSnapper, HotPixel hotPixel, SegmentString segmentString, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            segmentString = null;
        }
        if ((n2 & 4) != 0) {
            n = -1;
        }
        return mCIndexPointSnapper.snap(hotPixel, segmentString, n);
    }

    @NotNull
    public final Envelope getSafeEnvelope(@NotNull HotPixel hp) {
        Intrinsics.checkNotNullParameter((Object)hp, (String)"hp");
        double safeTolerance = 0.75 / hp.getScaleFactor();
        Envelope safeEnv = new Envelope(hp.getCoordinate());
        safeEnv.expandBy(safeTolerance);
        return safeEnv;
    }

    @JvmOverloads
    public final boolean snap(@NotNull HotPixel hotPixel, @Nullable SegmentString parentEdge) {
        Intrinsics.checkNotNullParameter((Object)hotPixel, (String)"hotPixel");
        return MCIndexPointSnapper.snap$default(this, hotPixel, parentEdge, 0, 4, null);
    }

    @JvmOverloads
    public final boolean snap(@NotNull HotPixel hotPixel) {
        Intrinsics.checkNotNullParameter((Object)hotPixel, (String)"hotPixel");
        return MCIndexPointSnapper.snap$default(this, hotPixel, null, 0, 6, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/locationtech/jts/noding/snapround/MCIndexPointSnapper$Companion;", "", "<init>", "()V", "SAFE_ENV_EXPANSION_FACTOR", "", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0016J\u001e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lorg/locationtech/jts/noding/snapround/MCIndexPointSnapper$HotPixelSnapAction;", "Lorg/locationtech/jts/index/chain/MonotoneChainSelectAction;", "hotPixel", "Lorg/locationtech/jts/noding/snapround/HotPixel;", "parentEdge", "Lorg/locationtech/jts/noding/SegmentString;", "hotPixelVertexIndex", "", "<init>", "(Lorg/locationtech/jts/noding/snapround/HotPixel;Lorg/locationtech/jts/noding/SegmentString;I)V", "value", "", "isNodeAdded", "()Z", "select", "", "mc", "Lorg/locationtech/jts/index/chain/MonotoneChain;", "startIndex", "addSnappedNode", "segStr", "Lorg/locationtech/jts/noding/NodedSegmentString;", "segIndex", "kts-core"})
    public static final class HotPixelSnapAction
    extends MonotoneChainSelectAction {
        @NotNull
        private final HotPixel hotPixel;
        @Nullable
        private final SegmentString parentEdge;
        private final int hotPixelVertexIndex;
        private boolean isNodeAdded;

        public HotPixelSnapAction(@NotNull HotPixel hotPixel, @Nullable SegmentString parentEdge, int hotPixelVertexIndex) {
            Intrinsics.checkNotNullParameter((Object)hotPixel, (String)"hotPixel");
            this.hotPixel = hotPixel;
            this.parentEdge = parentEdge;
            this.hotPixelVertexIndex = hotPixelVertexIndex;
        }

        public final boolean isNodeAdded() {
            return this.isNodeAdded;
        }

        @Override
        public void select(@NotNull MonotoneChain mc, int startIndex) {
            Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
            Object object = mc.getContext();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.locationtech.jts.noding.NodedSegmentString");
            NodedSegmentString ss = (NodedSegmentString)object;
            if (this.parentEdge != null && ss == this.parentEdge && (startIndex == this.hotPixelVertexIndex || startIndex + 1 == this.hotPixelVertexIndex)) {
                return;
            }
            this.isNodeAdded |= this.addSnappedNode(this.hotPixel, ss, startIndex);
        }

        public final boolean addSnappedNode(@NotNull HotPixel hotPixel, @NotNull NodedSegmentString segStr, int segIndex) {
            Intrinsics.checkNotNullParameter((Object)hotPixel, (String)"hotPixel");
            Intrinsics.checkNotNullParameter((Object)segStr, (String)"segStr");
            Coordinate p0 = segStr.getCoordinate(segIndex);
            Coordinate p1 = segStr.getCoordinate(segIndex + 1);
            if (hotPixel.intersects(p0, p1)) {
                segStr.addIntersection(hotPixel.getCoordinate(), segIndex);
                return true;
            }
            return false;
        }
    }
}

