/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding.snapround;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.algorithm.Distance;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.noding.SegmentIntersector;
import org.locationtech.jts.noding.SegmentString;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fJ(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0012H\u0016J0\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lorg/locationtech/jts/noding/snapround/SnapRoundingIntersectionAdder;", "Lorg/locationtech/jts/noding/SegmentIntersector;", "nearnessTol", "", "<init>", "(D)V", "li", "Lorg/locationtech/jts/algorithm/LineIntersector;", "intersections", "", "Lorg/locationtech/jts/geom/Coordinate;", "getIntersections", "", "processIntersections", "", "e0", "Lorg/locationtech/jts/noding/SegmentString;", "segIndex0", "", "e1", "segIndex1", "processNearVertex", "p", "edge", "segIndex", "p0", "p1", "isDone", "", "()Z", "kts-core"})
public final class SnapRoundingIntersectionAdder
implements SegmentIntersector {
    private final double nearnessTol;
    @NotNull
    private final LineIntersector li;
    @NotNull
    private final List<Coordinate> intersections;

    public SnapRoundingIntersectionAdder(double nearnessTol) {
        this.nearnessTol = nearnessTol;
        this.li = new RobustLineIntersector();
        this.intersections = new ArrayList();
    }

    @NotNull
    public final List<Coordinate> getIntersections() {
        return this.intersections;
    }

    @Override
    public void processIntersections(@NotNull SegmentString e0, int segIndex0, @NotNull SegmentString e1, int segIndex1) {
        Intrinsics.checkNotNullParameter((Object)e0, (String)"e0");
        Intrinsics.checkNotNullParameter((Object)e1, (String)"e1");
        if (e0 == e1 && segIndex0 == segIndex1) {
            return;
        }
        Coordinate p00 = e0.getCoordinate(segIndex0);
        Coordinate p01 = e0.getCoordinate(segIndex0 + 1);
        Coordinate p10 = e1.getCoordinate(segIndex1);
        Coordinate p11 = e1.getCoordinate(segIndex1 + 1);
        this.li.computeIntersection(p00, p01, p10, p11);
        if (this.li.hasIntersection() && this.li.isInteriorIntersection()) {
            int n = this.li.getIntersectionNum();
            for (int intIndex = 0; intIndex < n; ++intIndex) {
                this.intersections.add(this.li.getIntersection(intIndex));
            }
            ((NodedSegmentString)e0).addIntersections(this.li, segIndex0, 0);
            ((NodedSegmentString)e1).addIntersections(this.li, segIndex1, 1);
            return;
        }
        this.processNearVertex(p00, e1, segIndex1, p10, p11);
        this.processNearVertex(p01, e1, segIndex1, p10, p11);
        this.processNearVertex(p10, e0, segIndex0, p00, p01);
        this.processNearVertex(p11, e0, segIndex0, p00, p01);
    }

    private final void processNearVertex(Coordinate p, SegmentString edge, int segIndex, Coordinate p0, Coordinate p1) {
        if (p.distance(p0) < this.nearnessTol) {
            return;
        }
        if (p.distance(p1) < this.nearnessTol) {
            return;
        }
        double distSeg = Distance.pointToSegment(p, p0, p1);
        if (distSeg < this.nearnessTol) {
            this.intersections.add(p);
            Intrinsics.checkNotNull((Object)edge, (String)"null cannot be cast to non-null type org.locationtech.jts.noding.NodedSegmentString");
            ((NodedSegmentString)edge).addIntersection(p, segIndex);
        }
    }

    @Override
    public boolean isDone() {
        return false;
    }
}

