/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.BoundaryNodeRule;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.legacy.map.TreeMap;
import org.locationtech.jts.operation.Counter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001b\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0016H\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001f\u001a\u00020 H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/locationtech/jts/operation/BoundaryOp;", "", "geom", "Lorg/locationtech/jts/geom/Geometry;", "bnRule", "Lorg/locationtech/jts/algorithm/BoundaryNodeRule;", "<init>", "(Lorg/locationtech/jts/geom/Geometry;Lorg/locationtech/jts/algorithm/BoundaryNodeRule;)V", "geomFact", "Lorg/locationtech/jts/geom/GeometryFactory;", "boundary", "getBoundary", "()Lorg/locationtech/jts/geom/Geometry;", "emptyMultiPoint", "Lorg/locationtech/jts/geom/MultiPoint;", "getEmptyMultiPoint", "()Lorg/locationtech/jts/geom/MultiPoint;", "boundaryMultiLineString", "mLine", "Lorg/locationtech/jts/geom/MultiLineString;", "endpointMap", "", "Lorg/locationtech/jts/geom/Coordinate;", "Lorg/locationtech/jts/operation/Counter;", "computeBoundaryCoordinates", "", "(Lorg/locationtech/jts/geom/MultiLineString;)[Lorg/locationtech/jts/geom/Coordinate;", "addEndpoint", "", "pt", "boundaryLineString", "line", "Lorg/locationtech/jts/geom/LineString;", "Companion", "kts-core"})
public final class BoundaryOp {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Geometry geom;
    @NotNull
    private final GeometryFactory geomFact;
    @NotNull
    private final BoundaryNodeRule bnRule;
    @Nullable
    private Map<Coordinate, Counter> endpointMap;

    @JvmOverloads
    public BoundaryOp(@NotNull Geometry geom, @NotNull BoundaryNodeRule bnRule) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        Intrinsics.checkNotNullParameter((Object)bnRule, (String)"bnRule");
        this.geom = geom;
        this.geomFact = this.geom.getFactory();
        this.bnRule = bnRule;
    }

    public /* synthetic */ BoundaryOp(Geometry geometry, BoundaryNodeRule boundaryNodeRule, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            boundaryNodeRule = BoundaryNodeRule.MOD2_BOUNDARY_RULE;
        }
        this(geometry, boundaryNodeRule);
    }

    @Nullable
    public final Geometry getBoundary() {
        if (this.geom instanceof LineString) {
            return this.boundaryLineString((LineString)this.geom);
        }
        return this.geom instanceof MultiLineString ? this.boundaryMultiLineString((MultiLineString)this.geom) : this.geom.getBoundary();
    }

    private final MultiPoint getEmptyMultiPoint() {
        return this.geomFact.createMultiPoint();
    }

    private final Geometry boundaryMultiLineString(MultiLineString mLine) {
        if (this.geom.isEmpty()) {
            return this.getEmptyMultiPoint();
        }
        Coordinate[] bdyPts = this.computeBoundaryCoordinates(mLine);
        return bdyPts.length == 1 ? (Geometry)this.geomFact.createPoint(bdyPts[0]) : (Geometry)this.geomFact.createMultiPointFromCoords(bdyPts);
    }

    private final Coordinate[] computeBoundaryCoordinates(MultiLineString mLine) {
        List bdyPts = new ArrayList();
        this.endpointMap = new TreeMap(null, 1, null);
        int n = mLine.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Geometry geometry = mLine.getGeometryN(i);
            Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
            LineString line = (LineString)geometry;
            if (line.getNumPoints() == 0) continue;
            this.addEndpoint(line.getCoordinateN(0));
            this.addEndpoint(line.getCoordinateN(line.getNumPoints() - 1));
        }
        Map<Coordinate, Counter> map = this.endpointMap;
        Intrinsics.checkNotNull(map);
        Iterator<Map.Entry<Coordinate, Counter>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Coordinate, Counter> entry;
            Intrinsics.checkNotNull(it.next(), (String)"null cannot be cast to non-null type kotlin.collections.Map.Entry<*, *>");
            Coordinate key = entry.getKey();
            Counter value = entry.getValue();
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.Counter");
            Counter counter = value;
            int valence = counter.getCount();
            if (!this.bnRule.isInBoundary(valence)) continue;
            bdyPts.add(key);
        }
        return CoordinateArrays.toCoordinateArray(bdyPts);
    }

    private final void addEndpoint(Coordinate pt) {
        Map<Coordinate, Counter> map = this.endpointMap;
        Intrinsics.checkNotNull(map);
        Counter counter = map.get(pt);
        if (counter == null) {
            counter = new Counter();
            Map<Coordinate, Counter> map2 = this.endpointMap;
            Intrinsics.checkNotNull(map2);
            map2.put(pt, counter);
        }
        Counter counter2 = counter;
        int n = counter2.getCount();
        counter2.setCount(n + 1);
    }

    private final Geometry boundaryLineString(LineString line) {
        if (this.geom.isEmpty()) {
            return this.getEmptyMultiPoint();
        }
        if (line.isClosed()) {
            boolean closedEndpointOnBoundary = this.bnRule.isInBoundary(2);
            return closedEndpointOnBoundary ? (Geometry)line.getStartPoint() : (Geometry)this.geomFact.createMultiPoint();
        }
        Point[] pointArray = new Point[2];
        Intrinsics.checkNotNull((Object)line.getStartPoint());
        Intrinsics.checkNotNull((Object)line.getEndPoint());
        return this.geomFact.createMultiPoint(pointArray);
    }

    @JvmOverloads
    public BoundaryOp(@NotNull Geometry geom) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        this(geom, null, 2, null);
    }

    @JvmStatic
    public static final boolean hasBoundary(@NotNull Geometry geom, @NotNull BoundaryNodeRule boundaryNodeRule) {
        return Companion.hasBoundary(geom, boundaryNodeRule);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\bH\u0007\u00a8\u0006\r"}, d2={"Lorg/locationtech/jts/operation/BoundaryOp$Companion;", "", "<init>", "()V", "getBoundary", "Lorg/locationtech/jts/geom/Geometry;", "g", "bnRule", "Lorg/locationtech/jts/algorithm/BoundaryNodeRule;", "hasBoundary", "", "geom", "boundaryNodeRule", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Geometry getBoundary(@NotNull Geometry g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            BoundaryOp bop = new BoundaryOp(g, null, 2, null);
            return bop.getBoundary();
        }

        @Nullable
        public final Geometry getBoundary(@NotNull Geometry g, @NotNull BoundaryNodeRule bnRule) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)bnRule, (String)"bnRule");
            BoundaryOp bop = new BoundaryOp(g, bnRule);
            return bop.getBoundary();
        }

        @JvmStatic
        public final boolean hasBoundary(@NotNull Geometry geom, @NotNull BoundaryNodeRule boundaryNodeRule) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            Intrinsics.checkNotNullParameter((Object)boundaryNodeRule, (String)"boundaryNodeRule");
            if (geom.isEmpty()) {
                return false;
            }
            switch (geom.getDimension()) {
                case 0: {
                    return false;
                }
                case 1: {
                    Geometry boundary;
                    Geometry geometry = boundary = this.getBoundary(geom, boundaryNodeRule);
                    Intrinsics.checkNotNull((Object)geometry);
                    return !geometry.isEmpty();
                }
                case 2: {
                    return true;
                }
            }
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

