/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.EdgeList;
import org.locationtech.jts.geomgraph.Label;
import org.locationtech.jts.geomgraph.Node;
import org.locationtech.jts.geomgraph.PlanarGraph;
import org.locationtech.jts.noding.FastNodingValidator;
import org.locationtech.jts.noding.IntersectionAdder;
import org.locationtech.jts.noding.MCIndexNoder;
import org.locationtech.jts.noding.Noder;
import org.locationtech.jts.noding.SegmentString;
import org.locationtech.jts.operation.buffer.BufferCurveSetBuilder;
import org.locationtech.jts.operation.buffer.BufferParameters;
import org.locationtech.jts.operation.buffer.BufferSubgraph;
import org.locationtech.jts.operation.buffer.SubgraphDepthLocater;
import org.locationtech.jts.operation.overlay.OverlayNodeFactory;
import org.locationtech.jts.operation.overlay.PolygonBuilder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 .2\u00020\u0001:\u0001.B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\u0015\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\tJ\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J&\u0010\u001f\u001a\u00020\u00132\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u0011H\u0002J\u0010\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020&H\u0004J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020(0!2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010)\u001a\u00020\u00132\f\u0010*\u001a\b\u0012\u0004\u0012\u00020(0!2\u0006\u0010+\u001a\u00020,H\u0002J\b\u0010-\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/locationtech/jts/operation/buffer/BufferBuilder;", "", "bufParams", "Lorg/locationtech/jts/operation/buffer/BufferParameters;", "<init>", "(Lorg/locationtech/jts/operation/buffer/BufferParameters;)V", "workingPrecisionModel", "Lorg/locationtech/jts/geom/PrecisionModel;", "workingNoder", "Lorg/locationtech/jts/noding/Noder;", "geomFact", "Lorg/locationtech/jts/geom/GeometryFactory;", "graph", "Lorg/locationtech/jts/geomgraph/PlanarGraph;", "edgeList", "Lorg/locationtech/jts/geomgraph/EdgeList;", "isInvertOrientation", "", "setWorkingPrecisionModel", "", "pm", "setNoder", "noder", "setInvertOrientation", "buffer", "Lorg/locationtech/jts/geom/Geometry;", "g", "distance", "", "getNoder", "precisionModel", "computeNodedEdges", "bufferSegStrList", "", "Lorg/locationtech/jts/noding/SegmentString;", "isNodingValidated", "insertUniqueEdge", "e", "Lorg/locationtech/jts/geomgraph/Edge;", "createSubgraphs", "Lorg/locationtech/jts/operation/buffer/BufferSubgraph;", "buildSubgraphs", "subgraphList", "polyBuilder", "Lorg/locationtech/jts/operation/overlay/PolygonBuilder;", "createEmptyResultGeometry", "Companion", "kts-core"})
public final class BufferBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BufferParameters bufParams;
    @Nullable
    private PrecisionModel workingPrecisionModel;
    @Nullable
    private Noder workingNoder;
    @Nullable
    private GeometryFactory geomFact;
    @Nullable
    private PlanarGraph graph;
    @NotNull
    private final EdgeList edgeList;
    private boolean isInvertOrientation;

    public BufferBuilder(@NotNull BufferParameters bufParams) {
        Intrinsics.checkNotNullParameter((Object)bufParams, (String)"bufParams");
        this.edgeList = new EdgeList();
        this.bufParams = bufParams;
    }

    public final void setWorkingPrecisionModel(@Nullable PrecisionModel pm) {
        this.workingPrecisionModel = pm;
    }

    public final void setNoder(@Nullable Noder noder) {
        this.workingNoder = noder;
    }

    public final void setInvertOrientation(boolean isInvertOrientation) {
        this.isInvertOrientation = isInvertOrientation;
    }

    @NotNull
    public final Geometry buffer(@Nullable Geometry g, double distance) {
        Geometry geometry;
        PrecisionModel precisionModel = this.workingPrecisionModel;
        if (precisionModel == null) {
            Geometry geometry2 = g;
            Intrinsics.checkNotNull((Object)geometry2);
            precisionModel = geometry2.getPrecisionModel();
        }
        Geometry geometry3 = g;
        Intrinsics.checkNotNull((Object)geometry3);
        this.geomFact = geometry3.getFactory();
        BufferCurveSetBuilder curveSetBuilder = new BufferCurveSetBuilder(g, distance, precisionModel, this.bufParams);
        curveSetBuilder.setInvertOrientation(this.isInvertOrientation);
        List<SegmentString> bufferSegStrList = curveSetBuilder.getCurves();
        if (bufferSegStrList.size() <= 0) {
            return this.createEmptyResultGeometry();
        }
        boolean isNodingValidated = distance == 0.0;
        this.computeNodedEdges(bufferSegStrList, precisionModel, isNodingValidated);
        PlanarGraph planarGraph = this.graph = new PlanarGraph(new OverlayNodeFactory());
        Intrinsics.checkNotNull((Object)planarGraph);
        planarGraph.addEdges(this.edgeList.getEdges());
        PlanarGraph planarGraph2 = this.graph;
        Intrinsics.checkNotNull((Object)planarGraph2);
        List<BufferSubgraph> subgraphList = this.createSubgraphs(planarGraph2);
        GeometryFactory geometryFactory = this.geomFact;
        Intrinsics.checkNotNull((Object)geometryFactory);
        PolygonBuilder polyBuilder = new PolygonBuilder(geometryFactory);
        this.buildSubgraphs(subgraphList, polyBuilder);
        List<Polygon> resultPolyList = polyBuilder.getPolygons();
        if (resultPolyList.size() <= 0) {
            geometry = this.createEmptyResultGeometry();
        } else {
            GeometryFactory geometryFactory2 = this.geomFact;
            Intrinsics.checkNotNull((Object)geometryFactory2);
            geometry = geometryFactory2.buildGeometry((Collection<? extends Geometry>)resultPolyList);
        }
        return geometry;
    }

    private final Noder getNoder(PrecisionModel precisionModel) {
        if (this.workingNoder != null) {
            Noder noder = this.workingNoder;
            Intrinsics.checkNotNull((Object)noder);
            return noder;
        }
        MCIndexNoder noder = new MCIndexNoder();
        LineIntersector li = new RobustLineIntersector();
        li.setPrecisionModel(precisionModel);
        noder.setSegmentIntersector(new IntersectionAdder(li));
        return noder;
    }

    private final void computeNodedEdges(List<SegmentString> bufferSegStrList, PrecisionModel precisionModel, boolean isNodingValidated) {
        Noder noder = this.getNoder(precisionModel);
        noder.computeNodes((Collection<? extends SegmentString>)bufferSegStrList);
        Collection<SegmentString> nodedSegStrings = noder.getNodedSubstrings();
        if (isNodingValidated) {
            FastNodingValidator nv = new FastNodingValidator(nodedSegStrings);
            nv.checkValid();
        }
        Collection<SegmentString> collection = nodedSegStrings;
        Intrinsics.checkNotNull(collection);
        for (SegmentString segStr : collection) {
            Coordinate[] pts = segStr.getCoordinates();
            if (pts.length == 2 && pts[0].equals2D(pts[1])) continue;
            Label oldLabel = (Label)segStr.getData();
            Coordinate[] coordinateArray = segStr.getCoordinates();
            Label label = oldLabel;
            Intrinsics.checkNotNull((Object)label);
            Edge edge = new Edge(coordinateArray, new Label(label));
            this.insertUniqueEdge(edge);
        }
    }

    protected final void insertUniqueEdge(@NotNull Edge e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Edge existingEdge = this.edgeList.findEqualEdge(e);
        if (existingEdge != null) {
            Label existingLabel = existingEdge.getLabel();
            Label labelToMerge = e.getLabel();
            if (!existingEdge.isPointwiseEqual(e)) {
                Label label = e.getLabel();
                Intrinsics.checkNotNull((Object)label);
                labelToMerge = new Label(label);
                labelToMerge.flip();
            }
            Label label = existingLabel;
            Intrinsics.checkNotNull((Object)label);
            Label label2 = labelToMerge;
            Intrinsics.checkNotNull((Object)label2);
            label.merge(label2);
            int mergeDelta = BufferBuilder.Companion.depthDelta(labelToMerge);
            int existingDelta = existingEdge.getDepthDelta();
            int newDelta = existingDelta + mergeDelta;
            existingEdge.setDepthDelta(newDelta);
        } else {
            this.edgeList.add(e);
            e.setDepthDelta(BufferBuilder.Companion.depthDelta(e.getLabel()));
        }
    }

    private final List<BufferSubgraph> createSubgraphs(PlanarGraph graph) {
        List subgraphList = new ArrayList();
        for (Object obj : graph.getNodes()) {
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.Node");
            Node node = (Node)obj;
            if (node.isVisited()) continue;
            BufferSubgraph subgraph = new BufferSubgraph();
            subgraph.create(node);
            subgraphList.add(subgraph);
        }
        CollectionsKt.sortDescending((List)subgraphList);
        return subgraphList;
    }

    private final void buildSubgraphs(List<BufferSubgraph> subgraphList, PolygonBuilder polyBuilder) {
        List processedGraphs = new ArrayList();
        Iterator<BufferSubgraph> i = subgraphList.iterator();
        while (i.hasNext()) {
            BufferSubgraph subgraph;
            Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.operation.buffer.BufferSubgraph");
            Coordinate p = subgraph.getRightmostCoordinate();
            SubgraphDepthLocater locater = new SubgraphDepthLocater(processedGraphs);
            int outsideDepth = locater.getDepth(p);
            subgraph.computeDepth(outsideDepth);
            subgraph.findResultEdges();
            processedGraphs.add(subgraph);
            polyBuilder.add((Collection)subgraph.getDirectedEdges(), (Collection)subgraph.getNodes());
        }
    }

    private final Geometry createEmptyResultGeometry() {
        GeometryFactory geometryFactory = this.geomFact;
        Intrinsics.checkNotNull((Object)geometryFactory);
        return GeometryFactory.createPolygon$default(geometryFactory, null, null, 3, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0014\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002\u00a8\u0006\f"}, d2={"Lorg/locationtech/jts/operation/buffer/BufferBuilder$Companion;", "", "<init>", "()V", "depthDelta", "", "label", "Lorg/locationtech/jts/geomgraph/Label;", "convertSegStrings", "Lorg/locationtech/jts/geom/Geometry;", "it", "", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        private final int depthDelta(Label label) {
            Label label2 = label;
            Intrinsics.checkNotNull((Object)label2);
            int lLoc = label2.getLocation(0, 1);
            int rLoc = label.getLocation(0, 2);
            if (lLoc == 0 && rLoc == 2) {
                return 1;
            }
            if (lLoc == 2 && rLoc == 0) {
                return -1;
            }
            return 0;
        }

        private final Geometry convertSegStrings(Iterator<?> it) {
            GeometryFactory fact = new GeometryFactory();
            List lines = new ArrayList();
            while (it.hasNext()) {
                Object obj = it.next();
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.noding.SegmentString");
                SegmentString ss = (SegmentString)obj;
                LineString line = fact.createLineString(ss.getCoordinates());
                lines.add(line);
            }
            return fact.buildGeometry(lines);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

