/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.geomgraph.DirectedEdge;
import org.locationtech.jts.geomgraph.DirectedEdgeStar;
import org.locationtech.jts.geomgraph.Label;
import org.locationtech.jts.geomgraph.Node;
import org.locationtech.jts.legacy.LinkedListKt;
import org.locationtech.jts.legacy.StackKt;
import org.locationtech.jts.operation.buffer.RightmostEdgeFinder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\b\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\bJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000bJ\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u000bH\u0002J(\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000b2\u0016\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\u000b0\bj\b\u0012\u0004\u0012\u00020\u000b`!H\u0002J\b\u0010\"\u001a\u00020\u001bH\u0002J\u000e\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020%J\u0012\u0010&\u001a\u00020\u001b2\b\u0010'\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020\u000bH\u0002J\u0012\u0010*\u001a\u00020\u001b2\b\u0010+\u001a\u0004\u0018\u00010\tH\u0002J\u0006\u0010,\u001a\u00020\u001bJ\u0013\u0010-\u001a\u00020%2\b\u0010.\u001a\u0004\u0018\u00010\u0002H\u0096\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006/"}, d2={"Lorg/locationtech/jts/operation/buffer/BufferSubgraph;", "", "", "<init>", "()V", "finder", "Lorg/locationtech/jts/operation/buffer/RightmostEdgeFinder;", "dirEdgeList", "", "Lorg/locationtech/jts/geomgraph/DirectedEdge;", "nodes", "Lorg/locationtech/jts/geomgraph/Node;", "value", "Lorg/locationtech/jts/geom/Coordinate;", "rightmostCoordinate", "getRightmostCoordinate", "()Lorg/locationtech/jts/geom/Coordinate;", "env", "Lorg/locationtech/jts/geom/Envelope;", "directedEdges", "getDirectedEdges", "()Ljava/util/List;", "getNodes", "envelope", "getEnvelope", "()Lorg/locationtech/jts/geom/Envelope;", "create", "", "node", "addReachable", "startNode", "add", "nodeStack", "Lorg/locationtech/jts/legacy/Stack;", "clearVisitedEdges", "computeDepth", "outsideDepth", "", "computeDepths", "startEdge", "computeNodeDepth", "n", "copySymDepths", "de", "findResultEdges", "compareTo", "o", "kts-core"})
@SourceDebugExtension(value={"SMAP\nBufferSubgraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BufferSubgraph.kt\norg/locationtech/jts/operation/buffer/BufferSubgraph\n+ 2 Stack.kt\norg/locationtech/jts/legacy/StackKt\n*L\n1#1,294:1\n21#2:295\n*S KotlinDebug\n*F\n+ 1 BufferSubgraph.kt\norg/locationtech/jts/operation/buffer/BufferSubgraph\n*L\n125#1:295\n*E\n"})
public final class BufferSubgraph
implements Comparable<Object> {
    @NotNull
    private final RightmostEdgeFinder finder = new RightmostEdgeFinder();
    @NotNull
    private final List<DirectedEdge> dirEdgeList = new ArrayList();
    @NotNull
    private final List<Node> nodes = new ArrayList();
    @Nullable
    private Coordinate rightmostCoordinate;
    @Nullable
    private Envelope env;

    @Nullable
    public final Coordinate getRightmostCoordinate() {
        return this.rightmostCoordinate;
    }

    @NotNull
    public final List<DirectedEdge> getDirectedEdges() {
        return this.dirEdgeList;
    }

    @NotNull
    public final List<Node> getNodes() {
        return this.nodes;
    }

    @Nullable
    public final Envelope getEnvelope() {
        if (this.env == null) {
            Envelope edgeEnv = new Envelope();
            Iterator<DirectedEdge> it = this.dirEdgeList.iterator();
            while (it.hasNext()) {
                DirectedEdge dirEdge;
                Intrinsics.checkNotNull((Object)it.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.DirectedEdge");
                Coordinate[] pts = dirEdge.getEdge().getCoordinates();
                int n = pts.length - 1;
                for (int i = 0; i < n; ++i) {
                    edgeEnv.expandToInclude(pts[i]);
                }
            }
            this.env = edgeEnv;
        }
        return this.env;
    }

    public final void create(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.addReachable(node);
        this.finder.findEdge(this.dirEdgeList);
        this.rightmostCoordinate = this.finder.getCoordinate();
    }

    private final void addReachable(Node startNode) {
        List nodeStack = new ArrayList();
        nodeStack.add(startNode);
        while (!StackKt.empty(nodeStack)) {
            Object t = StackKt.pop(nodeStack);
            Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.Node");
            Node node = (Node)t;
            this.add(node, nodeStack);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void add(Node node, List<Node> nodeStack) {
        node.setVisited(true);
        this.nodes.add(node);
        DirectedEdgeStar directedEdgeStar = (DirectedEdgeStar)node.getEdges();
        Intrinsics.checkNotNull((Object)directedEdgeStar);
        Iterator<?> i = directedEdgeStar.iterator();
        while (i.hasNext()) {
            void $this$push$iv;
            Node symNode;
            DirectedEdge sym;
            Object obj = i.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.DirectedEdge");
            DirectedEdge de = (DirectedEdge)obj;
            this.dirEdgeList.add(de);
            DirectedEdge directedEdge = sym = de.getSym();
            Intrinsics.checkNotNull((Object)directedEdge);
            Intrinsics.checkNotNull((Object)directedEdge.getNode());
            if (symNode.isVisited()) continue;
            List<Node> list = nodeStack;
            Node item$iv = symNode;
            boolean $i$f$push = false;
            $this$push$iv.add(item$iv);
        }
    }

    private final void clearVisitedEdges() {
        Iterator<DirectedEdge> it = this.dirEdgeList.iterator();
        while (it.hasNext()) {
            DirectedEdge de;
            Intrinsics.checkNotNull((Object)it.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.DirectedEdge");
            de.setVisited(false);
        }
    }

    public final void computeDepth(int outsideDepth) {
        this.clearVisitedEdges();
        DirectedEdge directedEdge = this.finder.getEdge();
        Intrinsics.checkNotNull((Object)directedEdge);
        DirectedEdge de = directedEdge;
        Node node = de.getNode();
        Intrinsics.checkNotNull((Object)node);
        Node n = node;
        Label label = de.getLabel();
        Intrinsics.checkNotNull((Object)label);
        Label label2 = label;
        de.setEdgeDepths(2, outsideDepth);
        this.copySymDepths(de);
        this.computeDepths(de);
    }

    private final void computeDepths(DirectedEdge startEdge) {
        Set nodesVisited = new HashSet();
        ArrayList nodeQueue = new ArrayList();
        DirectedEdge directedEdge = startEdge;
        Intrinsics.checkNotNull((Object)directedEdge);
        Node node = directedEdge.getNode();
        Intrinsics.checkNotNull((Object)node);
        Node startNode = node;
        LinkedListKt.addLast(nodeQueue, startNode);
        nodesVisited.add(startNode);
        startEdge.setVisited(true);
        while (!nodeQueue.isEmpty()) {
            Node n = (Node)CollectionsKt.removeFirst((List)nodeQueue);
            nodesVisited.add(n);
            this.computeNodeDepth(n);
            DirectedEdgeStar directedEdgeStar = (DirectedEdgeStar)n.getEdges();
            Intrinsics.checkNotNull((Object)directedEdgeStar);
            Iterator<?> i = directedEdgeStar.iterator();
            while (i.hasNext()) {
                Node adjNode;
                DirectedEdge sym;
                Object obj = i.next();
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.DirectedEdge");
                DirectedEdge de = (DirectedEdge)obj;
                DirectedEdge directedEdge2 = sym = de.getSym();
                Intrinsics.checkNotNull((Object)directedEdge2);
                if (directedEdge2.isVisited()) continue;
                Intrinsics.checkNotNull((Object)sym.getNode());
                if (nodesVisited.contains(adjNode)) continue;
                LinkedListKt.addLast(nodeQueue, adjNode);
                nodesVisited.add(adjNode);
            }
        }
    }

    private final void computeNodeDepth(Node n) {
        DirectedEdge startEdge = null;
        BufferSubgraph $this$computeNodeDepth_u24lambda_u240 = this;
        boolean bl = false;
        DirectedEdgeStar directedEdgeStar = (DirectedEdgeStar)n.getEdges();
        Intrinsics.checkNotNull((Object)directedEdgeStar);
        Iterator<?> i = directedEdgeStar.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.DirectedEdge");
            DirectedEdge de = (DirectedEdge)obj;
            if (!de.isVisited()) {
                DirectedEdge directedEdge = de.getSym();
                Intrinsics.checkNotNull((Object)directedEdge);
                if (!directedEdge.isVisited()) continue;
            }
            startEdge = de;
            break;
        }
        if (startEdge == null) {
            throw new TopologyException("unable to find edge to compute depths at " + n.getCoordinate());
        }
        DirectedEdgeStar directedEdgeStar2 = (DirectedEdgeStar)n.getEdges();
        Intrinsics.checkNotNull((Object)directedEdgeStar2);
        directedEdgeStar2.computeDepths(startEdge);
        DirectedEdgeStar directedEdgeStar3 = (DirectedEdgeStar)n.getEdges();
        Intrinsics.checkNotNull((Object)directedEdgeStar3);
        Iterator<?> i2 = directedEdgeStar3.iterator();
        while (i2.hasNext()) {
            Object obj = i2.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.DirectedEdge");
            DirectedEdge de = (DirectedEdge)obj;
            de.setVisited(true);
            this.copySymDepths(de);
        }
    }

    private final void copySymDepths(DirectedEdge de) {
        DirectedEdge sym;
        DirectedEdge directedEdge = de;
        Intrinsics.checkNotNull((Object)directedEdge);
        DirectedEdge directedEdge2 = sym = directedEdge.getSym();
        Intrinsics.checkNotNull((Object)directedEdge2);
        directedEdge2.setDepth(1, de.getDepth(2));
        sym.setDepth(2, de.getDepth(1));
    }

    public final void findResultEdges() {
        Iterator<DirectedEdge> it = this.dirEdgeList.iterator();
        while (it.hasNext()) {
            DirectedEdge de;
            Intrinsics.checkNotNull((Object)it.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.DirectedEdge");
            if (de.getDepth(2) < 1 || de.getDepth(1) > 0 || de.isInteriorAreaEdge()) continue;
            de.setInResult(true);
        }
    }

    @Override
    public int compareTo(@Nullable Object o) {
        BufferSubgraph graph = (BufferSubgraph)o;
        Coordinate coordinate = this.rightmostCoordinate;
        Intrinsics.checkNotNull((Object)coordinate);
        double d = coordinate.x;
        BufferSubgraph bufferSubgraph = graph;
        Intrinsics.checkNotNull((Object)bufferSubgraph);
        Coordinate coordinate2 = bufferSubgraph.rightmostCoordinate;
        Intrinsics.checkNotNull((Object)coordinate2);
        if (d < coordinate2.x) {
            return -1;
        }
        Coordinate coordinate3 = this.rightmostCoordinate;
        Intrinsics.checkNotNull((Object)coordinate3);
        double d2 = coordinate3.x;
        Coordinate coordinate4 = graph.rightmostCoordinate;
        Intrinsics.checkNotNull((Object)coordinate4);
        return d2 > coordinate4.x ? 1 : 0;
    }
}

