/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.operation.buffer.BufferInputLineSimplifier;
import org.locationtech.jts.operation.buffer.BufferParameters;
import org.locationtech.jts.operation.buffer.OffsetSegmentGenerator;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u0000 )2\u00020\u0001:\u0001)B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J)\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tJ1\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0017J)\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\tH\u0002J\u001a\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u000f2\u0006\u0010 \u001a\u00020\u001aH\u0002J#\u0010!\u001a\u00020\u001e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010 \u001a\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010\"J+\u0010#\u001a\u00020\u001e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010$\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010%J+\u0010&\u001a\u00020\u001e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010$\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010%J+\u0010'\u001a\u00020\u001e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010(R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006*"}, d2={"Lorg/locationtech/jts/operation/buffer/OffsetCurveBuilder;", "", "precisionModel", "Lorg/locationtech/jts/geom/PrecisionModel;", "bufParams", "Lorg/locationtech/jts/operation/buffer/BufferParameters;", "<init>", "(Lorg/locationtech/jts/geom/PrecisionModel;Lorg/locationtech/jts/operation/buffer/BufferParameters;)V", "distance", "", "bufferParameters", "getBufferParameters", "()Lorg/locationtech/jts/operation/buffer/BufferParameters;", "getLineCurve", "", "Lorg/locationtech/jts/geom/Coordinate;", "inputPts", "([Lorg/locationtech/jts/geom/Coordinate;D)[Lorg/locationtech/jts/geom/Coordinate;", "isLineOffsetEmpty", "", "getRingCurve", "side", "", "([Lorg/locationtech/jts/geom/Coordinate;ID)[Lorg/locationtech/jts/geom/Coordinate;", "getOffsetCurve", "getSegGen", "Lorg/locationtech/jts/operation/buffer/OffsetSegmentGenerator;", "simplifyTolerance", "bufDistance", "computePointCurve", "", "pt", "segGen", "computeLineBufferCurve", "([Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/operation/buffer/OffsetSegmentGenerator;)V", "computeSingleSidedBufferCurve", "isRightSide", "([Lorg/locationtech/jts/geom/Coordinate;ZLorg/locationtech/jts/operation/buffer/OffsetSegmentGenerator;)V", "computeOffsetCurve", "computeRingBufferCurve", "([Lorg/locationtech/jts/geom/Coordinate;ILorg/locationtech/jts/operation/buffer/OffsetSegmentGenerator;)V", "Companion", "kts-core"})
public final class OffsetCurveBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PrecisionModel precisionModel;
    private double distance;
    @NotNull
    private final BufferParameters bufParams;

    public OffsetCurveBuilder(@NotNull PrecisionModel precisionModel, @NotNull BufferParameters bufParams) {
        Intrinsics.checkNotNullParameter((Object)precisionModel, (String)"precisionModel");
        Intrinsics.checkNotNullParameter((Object)bufParams, (String)"bufParams");
        this.precisionModel = precisionModel;
        this.bufParams = bufParams;
    }

    @NotNull
    public final BufferParameters getBufferParameters() {
        return this.bufParams;
    }

    @Nullable
    public final Coordinate[] getLineCurve(@NotNull Coordinate[] inputPts, double distance) {
        Intrinsics.checkNotNullParameter((Object)inputPts, (String)"inputPts");
        this.distance = distance;
        if (this.isLineOffsetEmpty(distance)) {
            return null;
        }
        double posDistance = Math.INSTANCE.abs(distance);
        OffsetSegmentGenerator segGen = this.getSegGen(posDistance);
        if (inputPts.length <= 1) {
            this.computePointCurve(inputPts[0], segGen);
        } else if (this.bufParams.isSingleSided()) {
            boolean isRightSide = distance < 0.0;
            this.computeSingleSidedBufferCurve(inputPts, isRightSide, segGen);
        } else {
            this.computeLineBufferCurve(inputPts, segGen);
        }
        return segGen.getCoordinates();
    }

    public final boolean isLineOffsetEmpty(double distance) {
        if (distance == 0.0) {
            return true;
        }
        return distance < 0.0 && !this.bufParams.isSingleSided();
    }

    @Nullable
    public final Coordinate[] getRingCurve(@NotNull Coordinate[] inputPts, int side, double distance) {
        Intrinsics.checkNotNullParameter((Object)inputPts, (String)"inputPts");
        this.distance = distance;
        if (inputPts.length <= 2) {
            return this.getLineCurve(inputPts, distance);
        }
        if (distance == 0.0) {
            return OffsetCurveBuilder.Companion.copyCoordinates(inputPts);
        }
        OffsetSegmentGenerator segGen = this.getSegGen(distance);
        this.computeRingBufferCurve(inputPts, side, segGen);
        return segGen.getCoordinates();
    }

    @Nullable
    public final Coordinate[] getOffsetCurve(@NotNull Coordinate[] inputPts, double distance) {
        Intrinsics.checkNotNullParameter((Object)inputPts, (String)"inputPts");
        this.distance = distance;
        if (distance == 0.0) {
            return null;
        }
        boolean isRightSide = distance < 0.0;
        double posDistance = Math.INSTANCE.abs(distance);
        OffsetSegmentGenerator segGen = this.getSegGen(posDistance);
        if (inputPts.length <= 1) {
            this.computePointCurve(inputPts[0], segGen);
        } else {
            this.computeOffsetCurve(inputPts, isRightSide, segGen);
        }
        Coordinate[] curvePts = segGen.getCoordinates();
        if (isRightSide) {
            CoordinateArrays.reverse(curvePts);
        }
        return curvePts;
    }

    private final OffsetSegmentGenerator getSegGen(double distance) {
        return new OffsetSegmentGenerator(this.precisionModel, this.bufParams, distance);
    }

    private final double simplifyTolerance(double bufDistance) {
        return bufDistance * this.bufParams.getSimplifyFactor();
    }

    private final void computePointCurve(Coordinate pt, OffsetSegmentGenerator segGen) {
        switch (this.bufParams.getEndCapStyle()) {
            case 1: {
                segGen.createCircle(pt);
                break;
            }
            case 3: {
                segGen.createSquare(pt);
            }
        }
    }

    private final void computeLineBufferCurve(Coordinate[] inputPts, OffsetSegmentGenerator segGen) {
        double distTol = this.simplifyTolerance(this.distance);
        Coordinate[] simp1 = BufferInputLineSimplifier.Companion.simplify(inputPts, distTol);
        int n1 = simp1.length - 1;
        segGen.initSideSegments(simp1[0], simp1[1], 1);
        int i = 2;
        if (i <= n1) {
            while (true) {
                segGen.addNextSegment(simp1[i], true);
                if (i == n1) break;
                ++i;
            }
        }
        segGen.addLastSegment();
        segGen.addLineEndCap(simp1[n1 - 1], simp1[n1]);
        Coordinate[] simp2 = BufferInputLineSimplifier.Companion.simplify(inputPts, -distTol);
        int n2 = simp2.length - 1;
        segGen.initSideSegments(simp2[n2], simp2[n2 - 1], 1);
        for (int i2 = n2 - 2; -1 < i2; --i2) {
            segGen.addNextSegment(simp2[i2], true);
        }
        segGen.addLastSegment();
        segGen.addLineEndCap(simp2[1], simp2[0]);
        segGen.closeRing();
    }

    private final void computeSingleSidedBufferCurve(Coordinate[] inputPts, boolean isRightSide, OffsetSegmentGenerator segGen) {
        double distTol = this.simplifyTolerance(this.distance);
        if (isRightSide) {
            segGen.addSegments(inputPts, true);
            Coordinate[] simp2 = BufferInputLineSimplifier.Companion.simplify(inputPts, -distTol);
            int n2 = simp2.length - 1;
            segGen.initSideSegments(simp2[n2], simp2[n2 - 1], 1);
            segGen.addFirstSegment();
            for (int i = n2 - 2; -1 < i; --i) {
                segGen.addNextSegment(simp2[i], true);
            }
        } else {
            segGen.addSegments(inputPts, false);
            Coordinate[] simp1 = BufferInputLineSimplifier.Companion.simplify(inputPts, distTol);
            int n1 = simp1.length - 1;
            segGen.initSideSegments(simp1[0], simp1[1], 1);
            segGen.addFirstSegment();
            int i = 2;
            if (i <= n1) {
                while (true) {
                    segGen.addNextSegment(simp1[i], true);
                    if (i == n1) break;
                    ++i;
                }
            }
        }
        segGen.addLastSegment();
        segGen.closeRing();
    }

    private final void computeOffsetCurve(Coordinate[] inputPts, boolean isRightSide, OffsetSegmentGenerator segGen) {
        double distTol = this.simplifyTolerance(Math.INSTANCE.abs(this.distance));
        if (isRightSide) {
            Coordinate[] simp2 = BufferInputLineSimplifier.Companion.simplify(inputPts, -distTol);
            int n2 = simp2.length - 1;
            segGen.initSideSegments(simp2[n2], simp2[n2 - 1], 1);
            segGen.addFirstSegment();
            for (int i = n2 - 2; -1 < i; --i) {
                segGen.addNextSegment(simp2[i], true);
            }
        } else {
            Coordinate[] simp1 = BufferInputLineSimplifier.Companion.simplify(inputPts, distTol);
            int n1 = simp1.length - 1;
            segGen.initSideSegments(simp1[0], simp1[1], 1);
            segGen.addFirstSegment();
            int i = 2;
            if (i <= n1) {
                while (true) {
                    segGen.addNextSegment(simp1[i], true);
                    if (i == n1) break;
                    ++i;
                }
            }
        }
        segGen.addLastSegment();
    }

    private final void computeRingBufferCurve(Coordinate[] inputPts, int side, OffsetSegmentGenerator segGen) {
        double distTol = this.simplifyTolerance(this.distance);
        if (side == 2) {
            distTol = -distTol;
        }
        Coordinate[] simp = BufferInputLineSimplifier.Companion.simplify(inputPts, distTol);
        int n = simp.length - 1;
        segGen.initSideSegments(simp[n - 1], simp[0], side);
        int i = 1;
        if (i <= n) {
            while (true) {
                boolean addStartPoint = i != 1;
                segGen.addNextSegment(simp[i], addStartPoint);
                if (i == n) break;
                ++i;
            }
        }
        segGen.closeRing();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/locationtech/jts/operation/buffer/OffsetCurveBuilder$Companion;", "", "<init>", "()V", "copyCoordinates", "", "Lorg/locationtech/jts/geom/Coordinate;", "pts", "([Lorg/locationtech/jts/geom/Coordinate;)[Lorg/locationtech/jts/geom/Coordinate;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        private final Coordinate[] copyCoordinates(Coordinate[] pts) {
            Object[] copy = new Coordinate[pts.length];
            int n = copy.length;
            for (int i = 0; i < n; ++i) {
                copy[i] = new Coordinate(pts[i]);
            }
            return (Coordinate[])ArraysKt.requireNoNulls((Object[])copy);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

