/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.Angle;
import org.locationtech.jts.algorithm.Distance;
import org.locationtech.jts.algorithm.Intersection;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.operation.buffer.BufferParameters;
import org.locationtech.jts.operation.buffer.OffsetSegmentString;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\"\b\u0000\u0018\u0000 C2\u00020\u0001:\u0001CB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\"\u0010 \u001a\u00020\u001f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001b\u001a\u00020\rJ\u0006\u0010%\u001a\u00020\u001fJ!\u0010&\u001a\u00020\u001f2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130\"2\u0006\u0010(\u001a\u00020\u001d\u00a2\u0006\u0002\u0010)J\u0006\u0010*\u001a\u00020\u001fJ\u0006\u0010+\u001a\u00020\u001fJ\u0018\u0010,\u001a\u00020\u001f2\b\u0010-\u001a\u0004\u0018\u00010\u00132\u0006\u0010.\u001a\u00020\u001dJ\u0010\u0010/\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020\u001dH\u0002J\u0018\u00100\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\r2\u0006\u0010.\u001a\u00020\u001dH\u0002J\u0018\u00102\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\r2\u0006\u0010.\u001a\u00020\u001dH\u0002J\u0016\u00103\u001a\u00020\u001f2\u0006\u00104\u001a\u00020\u00132\u0006\u00105\u001a\u00020\u0013J*\u00106\u001a\u00020\u001f2\b\u00107\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J(\u00108\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00109\u001a\u00020\u0007H\u0002J\u0018\u0010:\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0017H\u0002J2\u0010;\u001a\u00020\u001f2\b\u0010-\u001a\u0004\u0018\u00010\u00132\u0006\u00104\u001a\u00020\u00132\u0006\u00105\u001a\u00020\u00132\u0006\u0010<\u001a\u00020\r2\u0006\u0010=\u001a\u00020\u0007H\u0002J2\u0010>\u001a\u00020\u001f2\b\u0010-\u001a\u0004\u0018\u00010\u00132\u0006\u0010?\u001a\u00020\u00072\u0006\u0010@\u001a\u00020\u00072\u0006\u0010<\u001a\u00020\r2\u0006\u0010=\u001a\u00020\u0007H\u0002J\u0010\u0010A\u001a\u00020\u001f2\b\u0010-\u001a\u0004\u0018\u00010\u0013J\u0010\u0010B\u001a\u00020\u001f2\b\u0010-\u001a\u0004\u0018\u00010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00130\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006D"}, d2={"Lorg/locationtech/jts/operation/buffer/OffsetSegmentGenerator;", "", "precisionModel", "Lorg/locationtech/jts/geom/PrecisionModel;", "bufParams", "Lorg/locationtech/jts/operation/buffer/BufferParameters;", "distance", "", "<init>", "(Lorg/locationtech/jts/geom/PrecisionModel;Lorg/locationtech/jts/operation/buffer/BufferParameters;D)V", "maxCurveSegmentError", "filletAngleQuantum", "closingSegLengthFactor", "", "segList", "Lorg/locationtech/jts/operation/buffer/OffsetSegmentString;", "li", "Lorg/locationtech/jts/algorithm/LineIntersector;", "s0", "Lorg/locationtech/jts/geom/Coordinate;", "s1", "s2", "seg0", "Lorg/locationtech/jts/geom/LineSegment;", "seg1", "offset0", "offset1", "side", "hasNarrowConcaveAngle", "", "init", "", "initSideSegments", "coordinates", "", "getCoordinates", "()[Lorg/locationtech/jts/geom/Coordinate;", "closeRing", "addSegments", "pt", "isForward", "([Lorg/locationtech/jts/geom/Coordinate;Z)V", "addFirstSegment", "addLastSegment", "addNextSegment", "p", "addStartPoint", "addCollinear", "addOutsideTurn", "orientation", "addInsideTurn", "addLineEndCap", "p0", "p1", "addMitreJoin", "cornerPt", "addLimitedMitreJoin", "mitreLimitDistance", "addBevelJoin", "addCornerFillet", "direction", "radius", "addDirectedFillet", "startAngle", "endAngle", "createCircle", "createSquare", "Companion", "kts-core"})
public final class OffsetSegmentGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PrecisionModel precisionModel;
    private double maxCurveSegmentError;
    private final double filletAngleQuantum;
    private int closingSegLengthFactor;
    @Nullable
    private OffsetSegmentString segList;
    private double distance;
    @NotNull
    private final BufferParameters bufParams;
    @NotNull
    private final LineIntersector li;
    @Nullable
    private Coordinate s0;
    @Nullable
    private Coordinate s1;
    @Nullable
    private Coordinate s2;
    @NotNull
    private final LineSegment seg0;
    @NotNull
    private final LineSegment seg1;
    @NotNull
    private final LineSegment offset0;
    @NotNull
    private final LineSegment offset1;
    private int side;
    private boolean hasNarrowConcaveAngle;
    private static final double OFFSET_SEGMENT_SEPARATION_FACTOR = 0.001;
    private static final double INSIDE_TURN_VERTEX_SNAP_DISTANCE_FACTOR = 0.001;
    private static final double CURVE_VERTEX_SNAP_DISTANCE_FACTOR = 1.0E-6;
    private static final int MAX_CLOSING_SEG_LEN_FACTOR = 80;

    public OffsetSegmentGenerator(@NotNull PrecisionModel precisionModel, @NotNull BufferParameters bufParams, double distance) {
        Intrinsics.checkNotNullParameter((Object)precisionModel, (String)"precisionModel");
        Intrinsics.checkNotNullParameter((Object)bufParams, (String)"bufParams");
        this.precisionModel = precisionModel;
        this.closingSegLengthFactor = 1;
        this.seg0 = new LineSegment(null, null, 3, null);
        this.seg1 = new LineSegment(null, null, 3, null);
        this.offset0 = new LineSegment(null, null, 3, null);
        this.offset1 = new LineSegment(null, null, 3, null);
        this.bufParams = bufParams;
        this.li = new RobustLineIntersector();
        int quadSegs = bufParams.getQuadrantSegments();
        if (quadSegs < 1) {
            quadSegs = 1;
        }
        this.filletAngleQuantum = 1.5707963267948966 / (double)quadSegs;
        if (bufParams.getQuadrantSegments() >= 8 && bufParams.getJoinStyle() == 1) {
            this.closingSegLengthFactor = 80;
        }
        this.init(distance);
    }

    public final boolean hasNarrowConcaveAngle() {
        return this.hasNarrowConcaveAngle;
    }

    private final void init(double distance) {
        this.distance = distance;
        this.maxCurveSegmentError = distance * (1.0 - Math.INSTANCE.cos(this.filletAngleQuantum / 2.0));
        OffsetSegmentString offsetSegmentString = this.segList = new OffsetSegmentString();
        Intrinsics.checkNotNull((Object)offsetSegmentString);
        offsetSegmentString.setPrecisionModel(this.precisionModel);
        OffsetSegmentString offsetSegmentString2 = this.segList;
        Intrinsics.checkNotNull((Object)offsetSegmentString2);
        offsetSegmentString2.setMinimumVertexDistance(distance * 1.0E-6);
    }

    public final void initSideSegments(@Nullable Coordinate s1, @Nullable Coordinate s2, int side) {
        this.s1 = s1;
        this.s2 = s2;
        this.side = side;
        Coordinate coordinate = s1;
        Intrinsics.checkNotNull((Object)coordinate);
        Coordinate coordinate2 = s2;
        Intrinsics.checkNotNull((Object)coordinate2);
        this.seg1.setCoordinates(coordinate, coordinate2);
        Companion.computeOffsetSegment(this.seg1, side, this.distance, this.offset1);
    }

    @NotNull
    public final Coordinate[] getCoordinates() {
        OffsetSegmentString offsetSegmentString = this.segList;
        Intrinsics.checkNotNull((Object)offsetSegmentString);
        return offsetSegmentString.getCoordinates();
    }

    public final void closeRing() {
        OffsetSegmentString offsetSegmentString = this.segList;
        Intrinsics.checkNotNull((Object)offsetSegmentString);
        offsetSegmentString.closeRing();
    }

    public final void addSegments(@NotNull Coordinate[] pt, boolean isForward) {
        Intrinsics.checkNotNullParameter((Object)pt, (String)"pt");
        OffsetSegmentString offsetSegmentString = this.segList;
        Intrinsics.checkNotNull((Object)offsetSegmentString);
        offsetSegmentString.addPts(pt, isForward);
    }

    public final void addFirstSegment() {
        OffsetSegmentString offsetSegmentString = this.segList;
        Intrinsics.checkNotNull((Object)offsetSegmentString);
        offsetSegmentString.addPt(this.offset1.p0);
    }

    public final void addLastSegment() {
        OffsetSegmentString offsetSegmentString = this.segList;
        Intrinsics.checkNotNull((Object)offsetSegmentString);
        offsetSegmentString.addPt(this.offset1.p1);
    }

    public final void addNextSegment(@Nullable Coordinate p, boolean addStartPoint) {
        boolean outsideTurn;
        this.s0 = this.s1;
        this.s1 = this.s2;
        this.s2 = p;
        Coordinate coordinate = this.s0;
        Intrinsics.checkNotNull((Object)coordinate);
        Coordinate coordinate2 = this.s1;
        Intrinsics.checkNotNull((Object)coordinate2);
        this.seg0.setCoordinates(coordinate, coordinate2);
        Companion.computeOffsetSegment(this.seg0, this.side, this.distance, this.offset0);
        Coordinate coordinate3 = this.s1;
        Intrinsics.checkNotNull((Object)coordinate3);
        Coordinate coordinate4 = this.s2;
        Intrinsics.checkNotNull((Object)coordinate4);
        this.seg1.setCoordinates(coordinate3, coordinate4);
        Companion.computeOffsetSegment(this.seg1, this.side, this.distance, this.offset1);
        Coordinate coordinate5 = this.s1;
        Intrinsics.checkNotNull((Object)coordinate5);
        if (Intrinsics.areEqual((Object)coordinate5, (Object)this.s2)) {
            return;
        }
        int orientation = Orientation.index(this.s0, this.s1, this.s2);
        boolean bl = outsideTurn = orientation == -1 && this.side == 1 || orientation == 1 && this.side == 2;
        if (orientation == 0) {
            this.addCollinear(addStartPoint);
        } else if (outsideTurn) {
            this.addOutsideTurn(orientation, addStartPoint);
        } else {
            this.addInsideTurn(orientation, addStartPoint);
        }
    }

    private final void addCollinear(boolean addStartPoint) {
        this.li.computeIntersection(this.s0, this.s1, this.s1, this.s2);
        int numInt = this.li.getIntersectionNum();
        if (numInt >= 2) {
            if (this.bufParams.getJoinStyle() == 3 || this.bufParams.getJoinStyle() == 2) {
                if (addStartPoint) {
                    OffsetSegmentString offsetSegmentString = this.segList;
                    Intrinsics.checkNotNull((Object)offsetSegmentString);
                    offsetSegmentString.addPt(this.offset0.p1);
                }
                OffsetSegmentString offsetSegmentString = this.segList;
                Intrinsics.checkNotNull((Object)offsetSegmentString);
                offsetSegmentString.addPt(this.offset1.p0);
            } else {
                this.addCornerFillet(this.s1, this.offset0.p1, this.offset1.p0, -1, this.distance);
            }
        }
    }

    private final void addOutsideTurn(int orientation, boolean addStartPoint) {
        if (this.offset0.p1.distance(this.offset1.p0) < this.distance * 0.001) {
            OffsetSegmentString offsetSegmentString = this.segList;
            Intrinsics.checkNotNull((Object)offsetSegmentString);
            offsetSegmentString.addPt(this.offset0.p1);
            return;
        }
        if (this.bufParams.getJoinStyle() == 2) {
            this.addMitreJoin(this.s1, this.offset0, this.offset1, this.distance);
        } else if (this.bufParams.getJoinStyle() == 3) {
            this.addBevelJoin(this.offset0, this.offset1);
        } else {
            if (addStartPoint) {
                OffsetSegmentString offsetSegmentString = this.segList;
                Intrinsics.checkNotNull((Object)offsetSegmentString);
                offsetSegmentString.addPt(this.offset0.p1);
            }
            this.addCornerFillet(this.s1, this.offset0.p1, this.offset1.p0, orientation, this.distance);
            OffsetSegmentString offsetSegmentString = this.segList;
            Intrinsics.checkNotNull((Object)offsetSegmentString);
            offsetSegmentString.addPt(this.offset1.p0);
        }
    }

    private final void addInsideTurn(int orientation, boolean addStartPoint) {
        this.li.computeIntersection(this.offset0.p0, this.offset0.p1, this.offset1.p0, this.offset1.p1);
        if (this.li.hasIntersection()) {
            OffsetSegmentString offsetSegmentString = this.segList;
            Intrinsics.checkNotNull((Object)offsetSegmentString);
            offsetSegmentString.addPt(this.li.getIntersection(0));
        } else {
            this.hasNarrowConcaveAngle = true;
            if (this.offset0.p1.distance(this.offset1.p0) < this.distance * 0.001) {
                OffsetSegmentString offsetSegmentString = this.segList;
                Intrinsics.checkNotNull((Object)offsetSegmentString);
                offsetSegmentString.addPt(this.offset0.p1);
            } else {
                OffsetSegmentString offsetSegmentString = this.segList;
                Intrinsics.checkNotNull((Object)offsetSegmentString);
                offsetSegmentString.addPt(this.offset0.p1);
                if (this.closingSegLengthFactor > 0) {
                    double d = (double)this.closingSegLengthFactor * this.offset0.p1.x;
                    Coordinate coordinate = this.s1;
                    Intrinsics.checkNotNull((Object)coordinate);
                    double d2 = (d + coordinate.x) / (double)(this.closingSegLengthFactor + 1);
                    double d3 = (double)this.closingSegLengthFactor * this.offset0.p1.y;
                    Coordinate coordinate2 = this.s1;
                    Intrinsics.checkNotNull((Object)coordinate2);
                    Coordinate mid0 = new Coordinate(d2, (d3 + coordinate2.y) / (double)(this.closingSegLengthFactor + 1));
                    OffsetSegmentString offsetSegmentString2 = this.segList;
                    Intrinsics.checkNotNull((Object)offsetSegmentString2);
                    offsetSegmentString2.addPt(mid0);
                    double d4 = (double)this.closingSegLengthFactor * this.offset1.p0.x;
                    Coordinate coordinate3 = this.s1;
                    Intrinsics.checkNotNull((Object)coordinate3);
                    double d5 = (d4 + coordinate3.x) / (double)(this.closingSegLengthFactor + 1);
                    double d6 = (double)this.closingSegLengthFactor * this.offset1.p0.y;
                    Coordinate coordinate4 = this.s1;
                    Intrinsics.checkNotNull((Object)coordinate4);
                    Coordinate mid1 = new Coordinate(d5, (d6 + coordinate4.y) / (double)(this.closingSegLengthFactor + 1));
                    OffsetSegmentString offsetSegmentString3 = this.segList;
                    Intrinsics.checkNotNull((Object)offsetSegmentString3);
                    offsetSegmentString3.addPt(mid1);
                } else {
                    OffsetSegmentString offsetSegmentString4 = this.segList;
                    Intrinsics.checkNotNull((Object)offsetSegmentString4);
                    offsetSegmentString4.addPt(this.s1);
                }
                OffsetSegmentString offsetSegmentString5 = this.segList;
                Intrinsics.checkNotNull((Object)offsetSegmentString5);
                offsetSegmentString5.addPt(this.offset1.p0);
            }
        }
    }

    public final void addLineEndCap(@NotNull Coordinate p0, @NotNull Coordinate p1) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        LineSegment seg = new LineSegment(p0, p1);
        LineSegment offsetL = new LineSegment(null, null, 3, null);
        Companion.computeOffsetSegment(seg, 1, this.distance, offsetL);
        LineSegment offsetR = new LineSegment(null, null, 3, null);
        Companion.computeOffsetSegment(seg, 2, this.distance, offsetR);
        double dx = p1.x - p0.x;
        double dy = p1.y - p0.y;
        double angle = Math.INSTANCE.atan2(dy, dx);
        switch (this.bufParams.getEndCapStyle()) {
            case 1: {
                OffsetSegmentString offsetSegmentString = this.segList;
                Intrinsics.checkNotNull((Object)offsetSegmentString);
                offsetSegmentString.addPt(offsetL.p1);
                this.addDirectedFillet(p1, angle + 1.5707963267948966, angle - 1.5707963267948966, -1, this.distance);
                OffsetSegmentString offsetSegmentString2 = this.segList;
                Intrinsics.checkNotNull((Object)offsetSegmentString2);
                offsetSegmentString2.addPt(offsetR.p1);
                break;
            }
            case 2: {
                OffsetSegmentString offsetSegmentString = this.segList;
                Intrinsics.checkNotNull((Object)offsetSegmentString);
                offsetSegmentString.addPt(offsetL.p1);
                OffsetSegmentString offsetSegmentString3 = this.segList;
                Intrinsics.checkNotNull((Object)offsetSegmentString3);
                offsetSegmentString3.addPt(offsetR.p1);
                break;
            }
            case 3: {
                Coordinate squareCapSideOffset = new Coordinate();
                squareCapSideOffset.x = Math.INSTANCE.abs(this.distance) * Math.INSTANCE.cos(angle);
                squareCapSideOffset.y = Math.INSTANCE.abs(this.distance) * Math.INSTANCE.sin(angle);
                Coordinate squareCapLOffset = new Coordinate(offsetL.p1.x + squareCapSideOffset.x, offsetL.p1.y + squareCapSideOffset.y);
                Coordinate squareCapROffset = new Coordinate(offsetR.p1.x + squareCapSideOffset.x, offsetR.p1.y + squareCapSideOffset.y);
                OffsetSegmentString offsetSegmentString = this.segList;
                Intrinsics.checkNotNull((Object)offsetSegmentString);
                offsetSegmentString.addPt(squareCapLOffset);
                OffsetSegmentString offsetSegmentString4 = this.segList;
                Intrinsics.checkNotNull((Object)offsetSegmentString4);
                offsetSegmentString4.addPt(squareCapROffset);
            }
        }
    }

    private final void addMitreJoin(Coordinate cornerPt, LineSegment offset0, LineSegment offset1, double distance) {
        double mitreLimitDistance = this.bufParams.getMitreLimit() * distance;
        Coordinate intPt = Intersection.intersection(offset0.p0, offset0.p1, offset1.p0, offset1.p1);
        if (intPt != null) {
            Coordinate coordinate = cornerPt;
            Intrinsics.checkNotNull((Object)coordinate);
            if (intPt.distance(coordinate) <= mitreLimitDistance) {
                OffsetSegmentString offsetSegmentString = this.segList;
                Intrinsics.checkNotNull((Object)offsetSegmentString);
                offsetSegmentString.addPt(intPt);
                return;
            }
        }
        Coordinate coordinate = cornerPt;
        Intrinsics.checkNotNull((Object)coordinate);
        double bevelDist = Distance.pointToSegment(coordinate, offset0.p1, offset1.p0);
        if (bevelDist >= mitreLimitDistance) {
            this.addBevelJoin(offset0, offset1);
            return;
        }
        this.addLimitedMitreJoin(offset0, offset1, distance, mitreLimitDistance);
    }

    private final void addLimitedMitreJoin(LineSegment offset0, LineSegment offset1, double distance, double mitreLimitDistance) {
        Coordinate cornerPt = this.seg0.p1;
        double angInterior = Angle.INSTANCE.angleBetweenOriented(this.seg0.p0, cornerPt, this.seg1.p1);
        double angInterior2 = angInterior / (double)2;
        double dir0 = Angle.INSTANCE.angle(cornerPt, this.seg0.p0);
        double dirBisector = Angle.normalize(dir0 + angInterior2);
        Coordinate bevelMidPt = OffsetSegmentGenerator.Companion.project(cornerPt, -mitreLimitDistance, dirBisector);
        double dirBevel = Angle.normalize(dirBisector + 1.5707963267948966);
        Coordinate bevel0 = OffsetSegmentGenerator.Companion.project(bevelMidPt, distance, dirBevel);
        Coordinate bevel1 = OffsetSegmentGenerator.Companion.project(bevelMidPt, distance, dirBevel + java.lang.Math.PI);
        Coordinate bevelInt0 = Intersection.lineSegment(offset0.p0, offset0.p1, bevel0, bevel1);
        Coordinate bevelInt1 = Intersection.lineSegment(offset1.p0, offset1.p1, bevel0, bevel1);
        if (bevelInt0 != null && bevelInt1 != null) {
            OffsetSegmentString offsetSegmentString = this.segList;
            Intrinsics.checkNotNull((Object)offsetSegmentString);
            offsetSegmentString.addPt(bevelInt0);
            OffsetSegmentString offsetSegmentString2 = this.segList;
            Intrinsics.checkNotNull((Object)offsetSegmentString2);
            offsetSegmentString2.addPt(bevelInt1);
            return;
        }
        this.addBevelJoin(offset0, offset1);
    }

    private final void addBevelJoin(LineSegment offset0, LineSegment offset1) {
        OffsetSegmentString offsetSegmentString = this.segList;
        Intrinsics.checkNotNull((Object)offsetSegmentString);
        offsetSegmentString.addPt(offset0.p1);
        OffsetSegmentString offsetSegmentString2 = this.segList;
        Intrinsics.checkNotNull((Object)offsetSegmentString2);
        offsetSegmentString2.addPt(offset1.p0);
    }

    private final void addCornerFillet(Coordinate p, Coordinate p0, Coordinate p1, int direction, double radius) {
        double d = p0.x;
        Coordinate coordinate = p;
        Intrinsics.checkNotNull((Object)coordinate);
        double dx0 = d - coordinate.x;
        double dy0 = p0.y - p.y;
        double startAngle = Math.INSTANCE.atan2(dy0, dx0);
        double dx1 = p1.x - p.x;
        double dy1 = p1.y - p.y;
        double endAngle = Math.INSTANCE.atan2(dy1, dx1);
        if (direction == -1) {
            if (startAngle <= endAngle) {
                startAngle += java.lang.Math.PI * 2;
            }
        } else if (startAngle >= endAngle) {
            startAngle -= java.lang.Math.PI * 2;
        }
        OffsetSegmentString offsetSegmentString = this.segList;
        Intrinsics.checkNotNull((Object)offsetSegmentString);
        offsetSegmentString.addPt(p0);
        this.addDirectedFillet(p, startAngle, endAngle, direction, radius);
        OffsetSegmentString offsetSegmentString2 = this.segList;
        Intrinsics.checkNotNull((Object)offsetSegmentString2);
        offsetSegmentString2.addPt(p1);
    }

    private final void addDirectedFillet(Coordinate p, double startAngle, double endAngle, int direction, double radius) {
        int directionFactor = direction == -1 ? -1 : 1;
        double totalAngle = Math.INSTANCE.abs(startAngle - endAngle);
        int nSegs = (int)(totalAngle / this.filletAngleQuantum + 0.5);
        if (nSegs < 1) {
            return;
        }
        double angleInc = totalAngle / (double)nSegs;
        Coordinate pt = new Coordinate();
        for (int i = 0; i < nSegs; ++i) {
            double angle = startAngle + (double)(directionFactor * i) * angleInc;
            Coordinate coordinate = p;
            Intrinsics.checkNotNull((Object)coordinate);
            pt.x = coordinate.x + radius * Math.INSTANCE.cos(angle);
            pt.y = p.y + radius * Math.INSTANCE.sin(angle);
            OffsetSegmentString offsetSegmentString = this.segList;
            Intrinsics.checkNotNull((Object)offsetSegmentString);
            offsetSegmentString.addPt(pt);
        }
    }

    public final void createCircle(@Nullable Coordinate p) {
        Coordinate coordinate = p;
        Intrinsics.checkNotNull((Object)coordinate);
        Coordinate pt = new Coordinate(coordinate.x + this.distance, p.y);
        OffsetSegmentString offsetSegmentString = this.segList;
        Intrinsics.checkNotNull((Object)offsetSegmentString);
        offsetSegmentString.addPt(pt);
        this.addDirectedFillet(p, 0.0, java.lang.Math.PI * 2, -1, this.distance);
        OffsetSegmentString offsetSegmentString2 = this.segList;
        Intrinsics.checkNotNull((Object)offsetSegmentString2);
        offsetSegmentString2.closeRing();
    }

    public final void createSquare(@Nullable Coordinate p) {
        OffsetSegmentString offsetSegmentString = this.segList;
        Intrinsics.checkNotNull((Object)offsetSegmentString);
        Coordinate coordinate = p;
        Intrinsics.checkNotNull((Object)coordinate);
        offsetSegmentString.addPt(new Coordinate(coordinate.x + this.distance, p.y + this.distance));
        OffsetSegmentString offsetSegmentString2 = this.segList;
        Intrinsics.checkNotNull((Object)offsetSegmentString2);
        offsetSegmentString2.addPt(new Coordinate(p.x + this.distance, p.y - this.distance));
        OffsetSegmentString offsetSegmentString3 = this.segList;
        Intrinsics.checkNotNull((Object)offsetSegmentString3);
        offsetSegmentString3.addPt(new Coordinate(p.x - this.distance, p.y - this.distance));
        OffsetSegmentString offsetSegmentString4 = this.segList;
        Intrinsics.checkNotNull((Object)offsetSegmentString4);
        offsetSegmentString4.addPt(new Coordinate(p.x - this.distance, p.y + this.distance));
        OffsetSegmentString offsetSegmentString5 = this.segList;
        Intrinsics.checkNotNull((Object)offsetSegmentString5);
        offsetSegmentString5.closeRing();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\rJ \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/locationtech/jts/operation/buffer/OffsetSegmentGenerator$Companion;", "", "<init>", "()V", "OFFSET_SEGMENT_SEPARATION_FACTOR", "", "INSIDE_TURN_VERTEX_SNAP_DISTANCE_FACTOR", "CURVE_VERTEX_SNAP_DISTANCE_FACTOR", "MAX_CLOSING_SEG_LEN_FACTOR", "", "computeOffsetSegment", "", "seg", "Lorg/locationtech/jts/geom/LineSegment;", "side", "distance", "offset", "project", "Lorg/locationtech/jts/geom/Coordinate;", "pt", "d", "dir", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final void computeOffsetSegment(@NotNull LineSegment seg, int side, double distance, @NotNull LineSegment offset) {
            Intrinsics.checkNotNullParameter((Object)seg, (String)"seg");
            Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
            int sideSign = side == 1 ? 1 : -1;
            double dx = seg.p1.x - seg.p0.x;
            double dy = seg.p1.y - seg.p0.y;
            double len = Math.INSTANCE.sqrt(dx * dx + dy * dy);
            double ux = (double)sideSign * distance * dx / len;
            double uy = (double)sideSign * distance * dy / len;
            offset.p0.x = seg.p0.x - uy;
            offset.p0.y = seg.p0.y + ux;
            offset.p1.x = seg.p1.x - uy;
            offset.p1.y = seg.p1.y + ux;
        }

        private final Coordinate project(Coordinate pt, double d, double dir) {
            double x = pt.x + d * Math.INSTANCE.cos(dir);
            double y = pt.y + d * Math.INSTANCE.sin(dir);
            return new Coordinate(x, y);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

