/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.PrecisionModel;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000e\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J!\u0010\u0011\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0017\u001a\u00020\fJ\u0006\u0010\u0018\u001a\u00020\fJ\b\u0010\u001c\u001a\u00020\u001dH\u0016R\"\u0010\u0004\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0005j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0001`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001f"}, d2={"Lorg/locationtech/jts/operation/buffer/OffsetSegmentString;", "", "<init>", "()V", "ptList", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "precisionModel", "Lorg/locationtech/jts/geom/PrecisionModel;", "minimimVertexDistance", "", "setPrecisionModel", "", "setMinimumVertexDistance", "addPt", "pt", "Lorg/locationtech/jts/geom/Coordinate;", "addPts", "", "isForward", "", "([Lorg/locationtech/jts/geom/Coordinate;Z)V", "isRedundant", "closeRing", "reverse", "coordinates", "getCoordinates", "()[Lorg/locationtech/jts/geom/Coordinate;", "toString", "", "Companion", "kts-core"})
@SourceDebugExtension(value={"SMAP\nOffsetSegmentString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OffsetSegmentString.kt\norg/locationtech/jts/operation/buffer/OffsetSegmentString\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,118:1\n1563#2:119\n1634#2,3:120\n37#3,2:123\n*S KotlinDebug\n*F\n+ 1 OffsetSegmentString.kt\norg/locationtech/jts/operation/buffer/OffsetSegmentString\n*L\n106#1:119\n106#1:120,3\n106#1:123,2\n*E\n"})
public final class OffsetSegmentString {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ArrayList<Object> ptList = new ArrayList();
    @Nullable
    private PrecisionModel precisionModel;
    private double minimimVertexDistance;
    @NotNull
    private static final Coordinate[] COORDINATE_ARRAY_TYPE = new Coordinate[0];

    public final void setPrecisionModel(@Nullable PrecisionModel precisionModel) {
        this.precisionModel = precisionModel;
    }

    public final void setMinimumVertexDistance(double minimimVertexDistance) {
        this.minimimVertexDistance = minimimVertexDistance;
    }

    public final void addPt(@Nullable Coordinate pt) {
        Coordinate coordinate = pt;
        Intrinsics.checkNotNull((Object)coordinate);
        Coordinate bufPt = new Coordinate(coordinate);
        PrecisionModel precisionModel = this.precisionModel;
        Intrinsics.checkNotNull((Object)precisionModel);
        precisionModel.makePrecise(bufPt);
        if (this.isRedundant(bufPt)) {
            return;
        }
        this.ptList.add(bufPt);
    }

    public final void addPts(@NotNull Coordinate[] pt, boolean isForward) {
        Intrinsics.checkNotNullParameter((Object)pt, (String)"pt");
        if (isForward) {
            int n = pt.length;
            for (int i = 0; i < n; ++i) {
                this.addPt(pt[i]);
            }
        } else {
            int n = pt.length + -1;
            if (0 <= n) {
                do {
                    int i = n--;
                    this.addPt(pt[i]);
                } while (0 <= n);
            }
        }
    }

    private final boolean isRedundant(Coordinate pt) {
        if (this.ptList.size() < 1) {
            return false;
        }
        Object object = this.ptList.get(this.ptList.size() - 1);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Coordinate");
        Coordinate lastPt = (Coordinate)object;
        double ptDist = pt.distance(lastPt);
        return ptDist < this.minimimVertexDistance;
    }

    public final void closeRing() {
        if (this.ptList.size() < 1) {
            return;
        }
        Object object = this.ptList.get(0);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Coordinate");
        Coordinate startPt = new Coordinate((Coordinate)object);
        Object object2 = this.ptList.get(this.ptList.size() - 1);
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Coordinate");
        Coordinate lastPt = (Coordinate)object2;
        if (Intrinsics.areEqual((Object)startPt, (Object)lastPt)) {
            return;
        }
        this.ptList.add(startPt);
    }

    public final void reverse() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Coordinate[] getCoordinates() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.ptList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Coordinate");
            collection.add((Coordinate)it);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Coordinate[0]);
    }

    @NotNull
    public String toString() {
        GeometryFactory fact = new GeometryFactory();
        LineString line = fact.createLineString(this.getCoordinates());
        return line.toString();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/locationtech/jts/operation/buffer/OffsetSegmentString$Companion;", "", "<init>", "()V", "COORDINATE_ARRAY_TYPE", "", "Lorg/locationtech/jts/geom/Coordinate;", "[Lorg/locationtech/jts/geom/Coordinate;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

